/*
 * Decompiled with CFR 0.152.
 */
package IZX;

import DYH.AOP;
import IZX.DYH;
import IZX.GMT;
import IZX.HUI;
import IZX.HXH;
import IZX.IRK;
import IZX.IZX;
import IZX.KEM;
import IZX.LMH;
import IZX.NZV;
import IZX.OJW;
import IZX.RGI;
import IZX.RPN;
import IZX.SUU;
import IZX.UFF;
import IZX.VIN;
import IZX.VLN;
import IZX.YCE;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

public abstract class CVA {
    public static final byte MESSAGE_TYPE_CONNECT = 1;
    public static final byte MESSAGE_TYPE_CONNACK = 2;
    public static final byte MESSAGE_TYPE_PUBLISH = 3;
    public static final byte MESSAGE_TYPE_PUBACK = 4;
    public static final byte MESSAGE_TYPE_PUBREC = 5;
    public static final byte MESSAGE_TYPE_PUBREL = 6;
    public static final byte MESSAGE_TYPE_PUBCOMP = 7;
    public static final byte MESSAGE_TYPE_SUBSCRIBE = 8;
    public static final byte MESSAGE_TYPE_SUBACK = 9;
    public static final byte MESSAGE_TYPE_UNSUBSCRIBE = 10;
    public static final byte MESSAGE_TYPE_UNSUBACK = 11;
    public static final byte MESSAGE_TYPE_PINGREQ = 12;
    public static final byte MESSAGE_TYPE_PINGRESP = 13;
    public static final byte MESSAGE_TYPE_DISCONNECT = 14;
    protected static final String STRING_ENCODING = "UTF-8";
    private static final String[] NZV = new String[]{"reserved", "CONNECT", "CONNACK", "PUBLISH", "PUBACK", "PUBREC", "PUBREL", "PUBCOMP", "SUBSCRIBE", "SUBACK", "UNSUBSCRIBE", "UNSUBACK", "PINGREQ", "PINGRESP", "DISCONNECT"};
    private byte MRR;
    protected int msgId;
    protected boolean duplicate = false;

    public CVA(byte type) {
        this.MRR = type;
        this.msgId = 0;
    }

    protected abstract byte getMessageInfo();

    public byte[] getPayload() throws AOP.HXH {
        return new byte[0];
    }

    public byte getType() {
        return this.MRR;
    }

    public int getMessageId() {
        return this.msgId;
    }

    public void setMessageId(int msgId) {
        this.msgId = msgId;
    }

    public String getKey() {
        return new Integer(this.getMessageId()).toString();
    }

    public byte[] getHeader() throws AOP.HXH {
        try {
            int first = (this.getType() & 0xF) << 4 ^ this.getMessageInfo() & 0xF;
            byte[] varHeader = this.getVariableHeader();
            int remLen = varHeader.length + this.getPayload().length;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            dos.writeByte(first);
            dos.write(CVA.encodeMBI(remLen));
            dos.write(varHeader);
            dos.flush();
            return baos.toByteArray();
        }
        catch (IOException ioe) {
            throw new AOP.HXH(ioe);
        }
    }

    protected abstract byte[] getVariableHeader() throws AOP.HXH;

    public boolean isMessageIdRequired() {
        return true;
    }

    public static CVA createWireMessage(AOP.LMH data) throws AOP.HXH {
        byte[] payload = data.getPayloadBytes();
        if (payload == null) {
            payload = new byte[]{};
        }
        return CVA.NZV(new VIN(data.getHeaderBytes(), data.getHeaderOffset(), data.getHeaderLength(), payload, data.getPayloadOffset(), data.getPayloadLength()));
    }

    public static CVA createWireMessage(byte[] bytes) throws AOP.HXH {
        return CVA.NZV(new ByteArrayInputStream(bytes));
    }

    private static CVA NZV(InputStream inputStream) throws AOP.HXH {
        try {
            CVA result;
            NZV counter = new NZV(inputStream);
            DataInputStream in = new DataInputStream(counter);
            int first = in.readUnsignedByte();
            byte type = (byte)(first >> 4);
            byte info = (byte)(first & 0xF);
            long remLen = CVA.readMBI(in).getValue();
            long remainder = (long)counter.getCounter() + remLen - (long)counter.getCounter();
            byte[] data = new byte[]{};
            if (remainder > 0L) {
                data = new byte[(int)remainder];
                in.readFully(data, 0, data.length);
            }
            if (type == 1) {
                result = new HUI(info, data);
            } else if (type == 3) {
                result = new SUU(info, data);
            } else if (type == 4) {
                result = new IZX(info, data);
            } else if (type == 7) {
                result = new HXH(info, data);
            } else if (type == 2) {
                result = new OJW(info, data);
            } else if (type == 12) {
                result = new DYH(info, data);
            } else if (type == 13) {
                result = new KEM(info, data);
            } else if (type == 8) {
                result = new IRK(info, data);
            } else if (type == 9) {
                result = new VLN(info, data);
            } else if (type == 10) {
                result = new RPN(info, data);
            } else if (type == 11) {
                result = new RGI(info, data);
            } else if (type == 6) {
                result = new LMH(info, data);
            } else if (type == 5) {
                result = new UFF(info, data);
            } else if (type == 14) {
                result = new YCE(info, data);
            } else {
                throw AOP.createBrokerException(6);
            }
            return result;
        }
        catch (IOException io) {
            throw new AOP.HXH(io);
        }
    }

    protected static byte[] encodeMBI(long number) {
        int numBytes = 0;
        long no = number;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        do {
            byte digit = (byte)(no % 128L);
            if ((no /= 128L) > 0L) {
                digit = (byte)(digit | 0x80);
            }
            bos.write(digit);
        } while (no > 0L && ++numBytes < 4);
        return bos.toByteArray();
    }

    protected static GMT readMBI(DataInputStream in) throws IOException {
        byte digit;
        long msgLength = 0L;
        int multiplier = 1;
        int count = 0;
        do {
            digit = in.readByte();
            ++count;
            msgLength += (long)((digit & 0x7F) * multiplier);
            multiplier *= 128;
        } while ((digit & 0x80) != 0);
        return new GMT(msgLength, count);
    }

    protected byte[] encodeMessageId() throws AOP.HXH {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            dos.writeShort(this.msgId);
            dos.flush();
            return baos.toByteArray();
        }
        catch (IOException ex) {
            throw new AOP.HXH(ex);
        }
    }

    public boolean isRetryable() {
        return false;
    }

    public void setDuplicate(boolean duplicate) {
        this.duplicate = duplicate;
    }

    protected void encodeUTF8(DataOutputStream dos, String stringToEncode) throws AOP.HXH {
        try {
            byte[] encodedString = stringToEncode.getBytes(STRING_ENCODING);
            byte byte1 = (byte)(encodedString.length >>> 8 & 0xFF);
            byte byte2 = (byte)(encodedString.length >>> 0 & 0xFF);
            dos.write(byte1);
            dos.write(byte2);
            dos.write(encodedString);
            return;
        }
        catch (UnsupportedEncodingException ex) {
            throw new AOP.HXH(ex);
        }
        catch (IOException ex) {
            throw new AOP.HXH(ex);
        }
    }

    protected String decodeUTF8(DataInputStream input) throws AOP.HXH {
        try {
            byte[] encodedString = new byte[input.readUnsignedShort()];
            input.readFully(encodedString);
            return new String(encodedString, STRING_ENCODING);
        }
        catch (IOException ex) {
            throw new AOP.HXH(ex);
        }
    }

    public String toString() {
        return NZV[this.MRR];
    }
}

