/*
 * Decompiled with CFR 0.152.
 */
package com.adpdigital.push.location;

import com.adpdigital.push.location.LocationAccuracy;

public final class LocationParams {
    public static final LocationParams NAVIGATION = new Builder().setAccuracy(LocationAccuracy.HIGH).setDistance(0.0f).setInterval(500L).build();
    public static final LocationParams BEST_EFFORT = new Builder().setAccuracy(LocationAccuracy.MEDIUM).setDistance(150.0f).setInterval(2500L).build();
    public static final LocationParams LAZY = new Builder().setAccuracy(LocationAccuracy.LOW).setDistance(500.0f).setInterval(5000L).build();
    private long NZV;
    private float MRR;
    private LocationAccuracy OJW;

    LocationParams(LocationAccuracy accuracy, long interval, float distance) {
        this.NZV = interval;
        this.MRR = distance;
        this.OJW = accuracy;
    }

    public final long getInterval() {
        return this.NZV;
    }

    public final float getDistance() {
        return this.MRR;
    }

    public final LocationAccuracy getAccuracy() {
        return this.OJW;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LocationParams)) {
            return false;
        }
        LocationParams that = (LocationParams)o;
        return Float.compare(that.MRR, this.MRR) == 0 && this.NZV == that.NZV && this.OJW == that.OJW;
    }

    public final int hashCode() {
        int result = (int)(this.NZV ^ this.NZV >>> 32);
        result = 31 * result + (this.MRR != 0.0f ? Float.floatToIntBits(this.MRR) : 0);
        return 31 * result + this.OJW.hashCode();
    }

    public static class Builder {
        private LocationAccuracy accuracy = LocationAccuracy.MEDIUM;
        private long interval = 2500L;
        private float distance = 150.0f;

        public Builder setAccuracy(LocationAccuracy accuracy) {
            this.accuracy = accuracy;
            return this;
        }

        public Builder setInterval(long interval) {
            this.interval = interval;
            return this;
        }

        public Builder setDistance(float distance) {
            this.distance = distance;
            return this;
        }

        public LocationParams build() {
            return new LocationParams(this.accuracy, this.interval, this.distance);
        }
    }
}

