/*
 * Decompiled with CFR 0.152.
 */
package com.adpdigital.push.location;

import com.adpdigital.push.location.LocationAccuracy;

public final class LocationParams {
    public static final LocationParams NAVIGATION = new Builder().setAccuracy(LocationAccuracy.HIGH).setDistance(0.0f).setInterval(500L).build();
    public static final LocationParams BEST_EFFORT = new Builder().setAccuracy(LocationAccuracy.MEDIUM).setDistance(150.0f).setInterval(2500L).build();
    public static final LocationParams LAZY = new Builder().setAccuracy(LocationAccuracy.LOW).setDistance(500.0f).setInterval(5000L).build();
    private long a;
    private float b;
    private LocationAccuracy c;

    LocationParams(LocationAccuracy accuracy, long interval, float distance) {
        this.a = interval;
        this.b = distance;
        this.c = accuracy;
    }

    public final long getInterval() {
        return this.a;
    }

    public final float getDistance() {
        return this.b;
    }

    public final LocationAccuracy getAccuracy() {
        return this.c;
    }

    public final boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof LocationParams)) {
            return false;
        }
        LocationParams that = (LocationParams)o2;
        return Float.compare(that.b, this.b) == 0 && this.a == that.a && this.c == that.c;
    }

    public final int hashCode() {
        int result = (int)(this.a ^ this.a >>> 32);
        result = 31 * result + (this.b != 0.0f ? Float.floatToIntBits(this.b) : 0);
        return 31 * result + this.c.hashCode();
    }

    public static class Builder {
        private LocationAccuracy accuracy = LocationAccuracy.MEDIUM;
        private long interval = 2500L;
        private float distance = 150.0f;

        public Builder setAccuracy(LocationAccuracy accuracy) {
            this.accuracy = accuracy;
            return this;
        }

        public Builder setInterval(long interval) {
            this.interval = interval;
            return this;
        }

        public Builder setDistance(float distance) {
            this.distance = distance;
            return this;
        }

        public LocationParams build() {
            return new LocationParams(this.accuracy, this.interval, this.distance);
        }
    }
}

