/*
 * Decompiled with CFR 0.152.
 */
package com.adpdigital.push.location;

import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.res.Resources;
import android.graphics.BitmapFactory;
import android.location.Location;
import android.os.Bundle;
import android.os.Handler;
import android.os.Parcelable;
import android.preference.PreferenceManager;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.NotificationCompat;
import android.text.TextUtils;
import com.adpdigital.push.AdpPushClient;
import com.adpdigital.push.PushMessage;
import com.adpdigital.push.PushService;
import com.adpdigital.push.R;
import com.adpdigital.push.location.GeofenceParams;
import com.adpdigital.push.location.LocationAccuracy;
import com.adpdigital.push.location.LocationEvent;
import com.adpdigital.push.location.LocationMode;
import com.adpdigital.push.location.LocationParams;
import com.adpdigital.push.location.LocationService;
import com.adpdigital.push.location.OnLocationUpdateListener;
import com.adpdigital.push.location.c;
import com.adpdigital.push.location.e;
import com.adpdigital.push.location.f;
import com.adpdigital.push.location.g;
import com.adpdigital.push.location.h;
import com.adpdigital.push.location.i;
import com.adpdigital.push.location.j;
import com.adpdigital.push.location.l;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.GeofencingRequest;
import com.google.android.gms.location.LocationListener;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationServices;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class LocationManager
implements GoogleApiClient.ConnectionCallbacks,
GoogleApiClient.OnConnectionFailedListener {
    public static final String LOCATION_KEY = "location-key";
    private static LocationManager a;
    private GoogleApiClient b;
    private LocationRequest c;
    private OnLocationUpdateListener d;
    private Context e;
    private Location f;
    private LocationAccuracy g;
    private boolean h = false;
    private long i = 1000L;
    private long j;
    private float k;
    private SharedPreferences l;
    private boolean m = false;
    private Intent n;
    private a o;

    public void setWaitDurationBeforePublish(long waitDuration) {
        this.i = waitDuration * 1000L;
    }

    public static LocationManager init(Context context) {
        if (a == null) {
            a = new LocationManager(context);
        }
        return a;
    }

    private LocationManager(Context context) {
        this.e = context;
        this.l = PreferenceManager.getDefaultSharedPreferences((Context)context);
        this.b = new GoogleApiClient.Builder(context).addApi(LocationServices.API).addConnectionCallbacks((GoogleApiClient.ConnectionCallbacks)this).addOnConnectionFailedListener((GoogleApiClient.OnConnectionFailedListener)this).build();
        this.b.connect();
        AdpPushClient.get().addListener(this);
    }

    public void onEvent(PushMessage message) {
        if (message.getData() != null && message.getData().has("geofence")) {
            try {
                JSONObject geofence = message.getData().getJSONObject("geofence");
                JSONArray center = geofence.has("center") ? geofence.getJSONArray("center") : null;
                if (center != null) {
                    long expireTime = geofence.has("expire") && geofence.get("expire") != null ? geofence.getLong("expire") : Calendar.getInstance().getTime().getTime() + 3600000L;
                    new StringBuilder("setUpGeofence ").append(geofence);
                    this.setUpGeofence(new GeofenceParams.Builder().setCenter(geofence.getString("id"), center.optDouble(0), center.optDouble(1)).setExpire(expireTime).setRadius(geofence.getInt("r")).build(), geofence.has("enter") ? geofence.getString("enter") : "entering", geofence.has("exit") ? geofence.getString("exit") : "exiting", geofence.getInt("count"));
                    return;
                }
                if (geofence.has("id")) {
                    new StringBuilder("removeGeofenceById ").append(geofence.getString("id"));
                    this.removeGeofenceById(geofence.getString("id"));
                }
                return;
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        }
    }

    public void setUpGeofence(GeofenceParams params, String enterMessage, String exitMessage, int count) {
        long now = Calendar.getInstance().getTime().getTime();
        if (params.getExpire() - now > 0L) {
            long duration = params.getExpire() - now;
            Geofence geofence = new Geofence.Builder().setRequestId(params.getId()).setCircularRegion(params.getLatitude(), params.getLongitude(), params.getRadius()).setTransitionTypes(3).setExpirationDuration(duration).build();
            if (!TextUtils.isEmpty((CharSequence)enterMessage)) {
                this.l.edit().putString("enter_message" + params.getId(), enterMessage).apply();
            }
            if (!TextUtils.isEmpty((CharSequence)exitMessage)) {
                this.l.edit().putString("exit_message" + params.getId(), exitMessage).apply();
            }
            if (count > 0) {
                this.l.edit().putInt("key_count" + params.getId(), count).apply();
            }
            if (this.b.isConnected()) {
                this.a(geofence);
                return;
            }
            AdpPushClient.get().addListener(new c(this, geofence));
            this.b.connect();
        }
    }

    public void removeGeofenceById(String geofenceId) {
        ArrayList<String> geofenceIds = new ArrayList<String>();
        geofenceIds.add(geofenceId);
        this.removeGeofencesByIds(geofenceIds);
    }

    public void removeGeofencesByIds(List<String> geofenceIds) {
        if (this.b != null && this.b.isConnected()) {
            LocationServices.GeofencingApi.removeGeofences(this.b, geofenceIds).setResultCallback((ResultCallback)new e(this));
        }
    }

    private void a(Geofence geofence) {
        ArrayList<Geofence> mGeofenceList = new ArrayList<Geofence>();
        mGeofenceList.add(geofence);
        ArrayList<Geofence> arrayList = mGeofenceList;
        GeofencingRequest.Builder builder = new GeofencingRequest.Builder();
        builder.setInitialTrigger(1);
        builder.addGeofences(arrayList);
        LocationServices.GeofencingApi.addGeofences(this.b, builder.build(), this.d()).setResultCallback((ResultCallback)new f(this));
    }

    public void startTrackingMe(long duration, long interval, float distance) {
        new StringBuilder("startTrackingMe: called, duration: ").append(duration).append(" ,interval: ").append(interval);
        this.l.edit().putString("location_mode", "Tracking").apply();
        this.enableBackgroundMode();
        this.l.edit().putLong("duration", duration).apply();
        this.l.edit().putFloat("distance", distance).apply();
        this.l.edit().putLong("interval", interval).apply();
        this.l.edit().putLong("start_time", Calendar.getInstance().getTimeInMillis()).apply();
        this.f = null;
        this.a();
    }

    private void a() {
        LocationParams initialParams = new LocationParams.Builder().setAccuracy(LocationAccuracy.HIGH).setDistance(0.0f).setInterval(0L).build();
        this.startLocationUpdates(initialParams);
    }

    public void startLocationUpdates(LocationParams params) {
        LocationParams locationParams = params;
        LocationManager locationManager = this;
        this.j = locationParams.getInterval();
        locationManager.k = locationParams.getDistance();
        locationManager.g = locationParams.getAccuracy();
        LocationRequest locationRequest = LocationRequest.create().setFastestInterval(locationManager.j).setInterval(locationManager.j).setSmallestDisplacement(locationManager.k);
        switch (locationParams.getAccuracy()) {
            case HIGH: {
                locationRequest.setPriority(100);
                break;
            }
            case MEDIUM: {
                locationRequest.setPriority(102);
                break;
            }
            case LOW: {
                locationRequest.setPriority(104);
                break;
            }
            case LOWEST: {
                locationRequest.setPriority(105);
            }
        }
        this.c = locationRequest;
        if (this.b.isConnected()) {
            this.c();
            return;
        }
        this.o = new g(this);
        this.b.connect();
    }

    public void requestSingleLocation(LocationListener listener) {
        if (this.f()) {
            return;
        }
        this.l.edit().putString("location_mode", "Single").apply();
        this.enableBackgroundMode();
        this.f = null;
        this.a();
    }

    private void b() {
        this.l.edit().putLong("listening_start_time", Calendar.getInstance().getTimeInMillis()).apply();
    }

    public void connect() {
        if (this.b != null && !this.b.isConnected()) {
            this.b.connect();
        }
    }

    public void resume() {
        new StringBuilder("resume Connected=").append(this.b.isConnected());
        if (this.b.isConnected()) {
            this.c();
            return;
        }
        this.b.connect();
    }

    public void stop() {
        if (this.b != null && this.b.isConnected()) {
            h callback = new h(this);
            com.adpdigital.push.location.a handler = new com.adpdigital.push.location.a(1, callback);
            if (!this.h) {
                LocationManager locationManager = this;
                PendingIntent pendingIntent = locationManager.d();
                PendingResult result1 = LocationServices.FusedLocationApi.removeLocationUpdates(locationManager.b, pendingIntent);
                handler.check((PendingResult<Status>)result1);
            }
        }
    }

    public boolean isConnected() {
        return this.b.isConnected();
    }

    private void c() {
        new StringBuilder("start: called, backgoundMode: ").append(this.h);
        if (ActivityCompat.checkSelfPermission((Context)this.e, (String)"android.permission.ACCESS_FINE_LOCATION") != 0 && ActivityCompat.checkSelfPermission((Context)this.e, (String)"android.permission.ACCESS_COARSE_LOCATION") != 0) {
            return;
        }
        LocationManager locationManager = this;
        PendingIntent pendingIntent = locationManager.d();
        LocationServices.FusedLocationApi.requestLocationUpdates(locationManager.b, locationManager.c, pendingIntent);
    }

    private PendingIntent d() {
        Intent intent = new Intent(this.e, LocationService.class);
        return PendingIntent.getService((Context)this.e, (int)1, (Intent)intent, (int)0);
    }

    public Location getLastLocation() {
        if (this.f != null) {
            return this.f;
        }
        if (this.b != null && this.b.isConnected()) {
            if (ActivityCompat.checkSelfPermission((Context)this.e, (String)"android.permission.ACCESS_FINE_LOCATION") != 0 && ActivityCompat.checkSelfPermission((Context)this.e, (String)"android.permission.ACCESS_COARSE_LOCATION") != 0) {
                return null;
            }
            Location location = LocationServices.FusedLocationApi.getLastLocation(this.b);
            if (location != null) {
                return location;
            }
        }
        return null;
    }

    public void onConnected(@Nullable Bundle bundle) {
        AdpPushClient.get().notify((Object)LocationEvent.CONNECTED);
        if (this.o != null) {
            this.o.onConnect();
            this.o = null;
        }
        if (this.d != null) {
            this.d.onConnected(bundle);
        }
    }

    public void onConnectionSuspended(int i2) {
        if (this.d != null) {
            this.d.onSuspended();
        }
    }

    public void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
        if (this.d != null) {
            this.d.onConnectionFailed(connectionResult);
        }
    }

    private void e() {
        LocationManager locationManager;
        if (this.n == null) {
            this.n = this.g();
        }
        if (this.n != null) {
            locationManager = this;
            try {
                Bundle bundle = new Bundle();
                bundle.putParcelable(LOCATION_KEY, (Parcelable)locationManager.f);
                locationManager.n.putExtras(bundle);
                PendingIntent.getService((Context)locationManager.e, (int)0, (Intent)locationManager.n, (int)0).send();
            }
            catch (PendingIntent.CanceledException canceledException) {
                canceledException.printStackTrace();
            }
        }
        AdpPushClient.get().notify(this.f);
        locationManager = this.f;
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("lat", locationManager.getLatitude());
            jSONObject.put("lng", locationManager.getLongitude());
            jSONObject.put("ts", locationManager.getTime());
            AdpPushClient.get().publishEvent("geo", jSONObject, true, false);
        }
        catch (JSONException jSONException) {}
        this.b();
        if (this.d != null) {
            this.d.onLocationUpdated(this.f);
        }
        if (this.f()) {
            if ("Tracking".equalsIgnoreCase(this.l.getString("location_mode", ""))) {
                this.disableBackgroundMode();
                this.stop();
                new Handler().postDelayed((Runnable)new j(this), 500L);
                return;
            }
        } else if ("Single".equalsIgnoreCase(this.l.getString("location_mode", "")) || this.l.getLong("duration", 0L) != 0L) {
            new StringBuilder("updateStateAndSendLocation: time elapsed, provider: ").append(this.f.getProvider()).append(" ,").append(this.f);
            this.l.edit().putString("location_mode", "").apply();
            this.disableBackgroundMode();
            this.stop();
            AdpPushClient.get().notify((Object)LocationMode.TRACKING_STOPPED);
            if (this.l.getLong("duration", 0L) != 0L) {
                this.l.edit().putLong("duration", 0L).apply();
            }
            if (AdpPushClient.get().isBackground()) {
                PushService.performAction(this.e, "DISCONNECT");
            }
        }
    }

    private boolean f() {
        long duration = this.l.getLong("duration", 0L);
        long start = this.l.getLong("start_time", 0L);
        return duration > 0L && Calendar.getInstance().getTimeInMillis() - start < duration * 1000L;
    }

    public void enableLocationOnLaunch() {
        if (this.f()) {
            return;
        }
        this.requestSingleLocation(new l(this));
    }

    public void addListener(OnLocationUpdateListener listener) {
        this.d = listener;
    }

    public void removeListener() {
        this.d = null;
    }

    public long getIntervel() {
        return this.j;
    }

    public float getDistance() {
        return this.k;
    }

    public LocationAccuracy getAccuracy() {
        return this.g;
    }

    public void enableBackgroundMode() {
        this.h = true;
    }

    public void disableBackgroundMode() {
        this.h = false;
    }

    public boolean isBackgoundModeEnabled() {
        return this.h;
    }

    public void onEnteredGeofences(String[] geofenceIds, Location location) {
        String[] stringArray = geofenceIds;
        int n2 = geofenceIds.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String id = stringArray[i2];
            int count = this.l.getInt("key_count" + id, 0);
            if (count > 0) {
                String message = this.l.getString("enter_message" + id, "");
                this.a(id, message);
                this.l.edit().putInt("key_count" + id, count - 1).apply();
                continue;
            }
            this.l.edit().remove("key_count" + id).apply();
            this.l.edit().remove("enter_message" + id).apply();
            this.removeGeofenceById(id);
        }
    }

    public void onExitedGeofences(String[] geofenceIds, Location location) {
        String[] stringArray = geofenceIds;
        int n2 = geofenceIds.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String id = stringArray[i2];
            int count = this.l.getInt("key_count" + id, 0);
            if (count > 0) {
                String message = this.l.getString("exit_message" + id, "");
                this.a(id, message);
                this.l.edit().putInt("key_count" + id, count - 1).apply();
                continue;
            }
            this.l.edit().remove("key_count" + id).apply();
            this.l.edit().remove("exit_message" + id).apply();
            this.removeGeofenceById(id);
        }
    }

    private void a(String id, String message) {
        NotificationCompat.Builder builder = new NotificationCompat.Builder(this.e, id);
        builder.setSmallIcon(R.drawable.common_full_open_on_phone).setLargeIcon(BitmapFactory.decodeResource((Resources)this.e.getResources(), (int)R.drawable.common_full_open_on_phone)).setColor(-65536).setContentTitle((CharSequence)id).setContentText((CharSequence)message);
        builder.setAutoCancel(true);
        ((NotificationManager)this.e.getSystemService("notification")).notify(0, builder.build());
    }

    public void addCallbackIntent(Intent callbackIntent) {
        this.n = callbackIntent;
        String string = callbackIntent.toUri(0);
        this.l.edit().putString("host_intent_uri_key", string).apply();
    }

    public void removeCallbackIntent() {
        this.n = null;
        this.l.edit().remove("host_intent_uri_key").apply();
    }

    @Nullable
    private Intent g() {
        String uri = this.l.getString("host_intent_uri_key", "");
        if (!TextUtils.isEmpty((CharSequence)uri)) {
            try {
                return Intent.parseUri((String)uri, (int)0);
            }
            catch (URISyntaxException uRISyntaxException) {
                uRISyntaxException.printStackTrace();
            }
        }
        return null;
    }

    static /* synthetic */ void a(LocationManager x0, Geofence x1) {
        x0.a(x1);
    }

    static /* synthetic */ OnLocationUpdateListener a(LocationManager x0) {
        return x0.d;
    }

    static /* synthetic */ void b(LocationManager x0) {
        x0.c();
    }

    static /* synthetic */ GoogleApiClient c(LocationManager x0) {
        return x0.b;
    }

    static /* synthetic */ boolean d(LocationManager x0) {
        return x0.m;
    }

    static /* synthetic */ Location e(LocationManager x0) {
        return x0.f;
    }

    static /* synthetic */ void f(LocationManager x0) {
        x0.e();
    }

    static /* synthetic */ SharedPreferences g(LocationManager x0) {
        return x0.l;
    }

    static /* synthetic */ void h(LocationManager x0) {
        LocationManager locationManager = x0;
        float f2 = locationManager.l.getFloat("distance", 0.0f);
        long l2 = locationManager.l.getLong("interval", 0L);
        LocationParams locationParams = new LocationParams.Builder().setAccuracy(LocationAccuracy.HIGH).setDistance(f2).setInterval(l2 * 1000L).build();
        locationManager.enableBackgroundMode();
        locationManager.startLocationUpdates(locationParams);
    }

    /*
     * Unable to fully structure code
     */
    static /* synthetic */ void a(LocationManager x0, Location x1) {
        block10: {
            block11: {
                block9: {
                    var3_2 = x1;
                    var2_3 = x0;
                    new StringBuilder("handleLocation, provider: ").append(var3_2.getProvider()).append(" ,").append(var3_2);
                    if (var2_3.f == null) {
                        var2_3.b();
                        var2_3.m = false;
                        new Handler().postDelayed((Runnable)new i(var2_3), var2_3.i + 500L);
                    }
                    var9_4 = var2_3.f;
                    var8_5 = var3_2;
                    if (var9_4 != null) break block9;
                    v0 = true;
                    break block10;
                }
                var10_6 = var8_5.getTime() - var9_4.getTime();
                var12_7 = var10_6 > 120000L;
                var13_8 = var10_6 < -120000L;
                v1 = var14_9 = var10_6 > 0L;
                if (!var12_7) break block11;
                v0 = true;
                break block10;
            }
            if (var13_8) ** GOTO lbl-1000
            var15_10 = (int)(var8_5.getAccuracy() - var9_4.getAccuracy());
            var16_11 = var15_10 > 0;
            var17_12 = var15_10 < 0;
            var18_13 = var15_10 > 200;
            var21_14 = var9_4.getProvider();
            var20_15 = var8_5.getProvider();
            v2 = var20_15 == null ? var21_14 == null : (var19_16 = var20_15.equals(var21_14));
            if (var17_12) {
                v0 = true;
            } else if (var14_9 && !var16_11) {
                v0 = true;
            } else if (var14_9 && !var18_13 && var19_16) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = false;
            }
        }
        if (v0) {
            var2_3.f = var3_2;
        }
        var4_17 = var2_3.l.getLong("listening_start_time", 0L);
        var6_18 = Calendar.getInstance().getTimeInMillis() - var4_17;
        if (var2_3.f != null && var4_17 != 0L && var6_18 > var2_3.i) {
            var2_3.m = true;
            var2_3.e();
        }
    }

    static interface a {
        public void onConnect();
    }
}

