/*
 * Decompiled with CFR 0.152.
 */
package com.adpdigital.push.location;

public final class GeofenceParams {
    private String a;
    private final double b;
    private final double c;
    private final float d;
    private long e;

    GeofenceParams(String id, double lat, double lng, float radius, long expire) {
        this.a = id;
        this.b = lat;
        this.c = lng;
        this.d = radius;
        this.e = expire;
    }

    public final long getExpire() {
        return this.e;
    }

    public final float getRadius() {
        return this.d;
    }

    public final double getLatitude() {
        return this.b;
    }

    public final double getLongitude() {
        return this.c;
    }

    public final String getId() {
        return this.a;
    }

    public final boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof GeofenceParams)) {
            return false;
        }
        GeofenceParams that = (GeofenceParams)o2;
        return Float.compare(that.d, this.d) == 0 && this.b == that.b && this.c == that.c;
    }

    public static class Builder {
        private double latitude;
        private double longitude;
        private float radius = 100.0f;
        private long expire;
        private String id;

        public Builder setCenter(String id, double lat, double lng) {
            this.id = id;
            this.latitude = lat;
            this.longitude = lng;
            return this;
        }

        public Builder setRadius(float radius) {
            this.radius = radius;
            return this;
        }

        public Builder setExpire(long time) {
            this.expire = time;
            return this;
        }

        public GeofenceParams build() {
            return new GeofenceParams(this.id, this.latitude, this.longitude, this.radius, this.expire);
        }
    }
}

