/*
 * Decompiled with CFR 0.152.
 */
package com.adpdigital.push;

import android.os.Bundle;
import com.adpdigital.push.PushMessage;

public class ChabokNotification {
    private String id;
    private String title;
    private String text;
    private PushMessage message;
    private Bundle extras;
    private int badge;
    private String sound;
    private boolean alert = true;
    private String topicName;

    public ChabokNotification(String id, String title, String text, int badge, Bundle extras) {
        this.id = id;
        this.title = title;
        this.badge = badge;
        this.text = text;
        this.extras = extras;
    }

    public ChabokNotification(PushMessage message, int badge) {
        this.message = message;
        this.id = message.getId();
        this.title = message.getAlertTitle();
        if (this.title == null) {
            this.title = message.getAlertText();
        }
        this.text = message.getBody();
        if (message.getAlertText() != null && !message.getAlertText().trim().equalsIgnoreCase("")) {
            this.text = message.getAlertText();
        }
        this.badge = badge;
    }

    public String getId() {
        return this.id;
    }

    public String getText() {
        return this.text;
    }

    public int getBadge() {
        return this.badge;
    }

    public String getTitle() {
        return this.title;
    }

    public PushMessage getMessage() {
        return this.message;
    }

    public Bundle getExtras() {
        return this.extras;
    }

    public String getSound() {
        return this.sound;
    }

    public void setSound(String sound) {
        this.sound = sound;
    }

    public boolean isAlert() {
        return this.alert;
    }

    public void setAlert(boolean alert) {
        this.alert = alert;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public void setTopicName(String topicName) {
        this.topicName = topicName;
    }
}

