/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock.store;

import com.adobe.testing.s3mock.dto.ObjectOwnership;
import com.adobe.testing.s3mock.store.BucketMetadata;
import com.adobe.testing.s3mock.store.BucketStore;
import com.adobe.testing.s3mock.store.KmsKeyStore;
import com.adobe.testing.s3mock.store.LegacyStoreProperties;
import com.adobe.testing.s3mock.store.MultipartStore;
import com.adobe.testing.s3mock.store.ObjectStore;
import com.adobe.testing.s3mock.store.StoreCleaner;
import com.adobe.testing.s3mock.store.StoreProperties;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import software.amazon.awssdk.regions.Region;

@Configuration
@EnableConfigurationProperties(value={StoreProperties.class, LegacyStoreProperties.class})
public class StoreConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(StoreConfiguration.class);
    static final DateTimeFormatter S3_OBJECT_DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").withZone(ZoneId.of("UTC"));

    @Bean
    ObjectStore objectStore(List<String> bucketNames, BucketStore bucketStore, ObjectMapper objectMapper) {
        ObjectStore objectStore = new ObjectStore(S3_OBJECT_DATE_FORMAT, objectMapper);
        for (String bucketName : bucketNames) {
            BucketMetadata bucketMetadata = bucketStore.getBucketMetadata(bucketName);
            objectStore.loadObjects(bucketMetadata, bucketMetadata.objects().values());
        }
        return objectStore;
    }

    @Bean
    BucketStore bucketStore(StoreProperties properties, LegacyStoreProperties legacyProperties, File rootFolder, List<String> bucketNames, ObjectMapper objectMapper, @Value(value="${com.adobe.testing.s3mock.region}") @Nullable Region region) {
        Region mockRegion = region == null ? properties.region() : region;
        BucketStore bucketStore = new BucketStore(rootFolder, S3_OBJECT_DATE_FORMAT, mockRegion.id(), objectMapper);
        bucketStore.loadBuckets(bucketNames);
        List<Object> initialBuckets = List.of();
        if (!legacyProperties.initialBuckets().isEmpty()) {
            initialBuckets = legacyProperties.initialBuckets();
        } else if (!properties.initialBuckets().isEmpty()) {
            initialBuckets = properties.initialBuckets();
        }
        initialBuckets.stream().filter(name -> {
            boolean partOfExistingBuckets = bucketNames.contains(name);
            if (partOfExistingBuckets) {
                LOG.info("Skip initial bucket {}, it's part of the existing buckets.", name);
            }
            return !partOfExistingBuckets;
        }).forEach(name -> {
            bucketStore.createBucket((String)name, false, ObjectOwnership.BUCKET_OWNER_ENFORCED, mockRegion.id(), null, null);
            LOG.info("Creating initial bucket {}.", name);
        });
        return bucketStore;
    }

    @Bean
    List<String> bucketNames(File rootFolder) {
        ArrayList<String> bucketNames = new ArrayList<String>();
        try (DirectoryStream<Path> paths = Files.newDirectoryStream(rootFolder.toPath());){
            paths.forEach(path -> {
                Path resolved = path.resolve("bucketMetadata.json");
                if (resolved.toFile().exists()) {
                    bucketNames.add(path.getFileName().toString());
                } else {
                    LOG.warn("Found bucket folder {} without {}", path, (Object)"bucketMetadata.json");
                }
            });
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not load buckets from data directory " + String.valueOf(rootFolder), e);
        }
        return bucketNames;
    }

    @Bean
    MultipartStore multipartStore(ObjectStore objectStore, ObjectMapper objectMapper) {
        return new MultipartStore(objectStore, objectMapper);
    }

    @Bean
    KmsKeyStore kmsKeyStore(StoreProperties properties, LegacyStoreProperties legacyProperties) {
        if (!properties.validKmsKeys().isEmpty()) {
            return new KmsKeyStore(properties.validKmsKeys());
        }
        if (!legacyProperties.validKmsKeys().isEmpty()) {
            return new KmsKeyStore(legacyProperties.validKmsKeys());
        }
        return new KmsKeyStore(new HashSet<String>());
    }

    @Bean
    File rootFolder(StoreProperties properties, LegacyStoreProperties legacyProperties) {
        File root;
        boolean createTempDir;
        String rootPath = null;
        if (legacyProperties.root() != null && !legacyProperties.root().isEmpty()) {
            rootPath = legacyProperties.root();
        } else if (properties.root() != null && !properties.root().isEmpty()) {
            rootPath = properties.root();
        }
        boolean bl = createTempDir = rootPath == null;
        if (createTempDir) {
            Path baseTempDir = FileUtils.getTempDirectory().toPath();
            try {
                root = Files.createTempDirectory(baseTempDir, "s3mockFileStore", new FileAttribute[0]).toFile();
            }
            catch (IOException e) {
                throw new IllegalStateException("Root folder could not be created. Base temp dir: " + String.valueOf(baseTempDir), e);
            }
            LOG.info("Successfully created \"{}\" as root folder. Will retain files on exit: {}", (Object)root.getAbsolutePath(), (Object)properties.retainFilesOnExit());
        } else {
            root = new File(rootPath);
            if (root.exists()) {
                LOG.info("Using existing folder \"{}\" as root folder. Will retain files on exit: {}", (Object)root.getAbsolutePath(), (Object)properties.retainFilesOnExit());
            } else {
                if (!root.mkdir()) {
                    throw new IllegalStateException("Root folder could not be created. Path: " + root.getAbsolutePath());
                }
                LOG.info("Successfully created \"{}\" as root folder. Will retain files on exit: {}", (Object)root.getAbsolutePath(), (Object)properties.retainFilesOnExit());
            }
        }
        return root;
    }

    @Bean
    StoreCleaner storeCleaner(File rootFolder, StoreProperties properties, LegacyStoreProperties legacyProperties) {
        if (legacyProperties.retainFilesOnExit() || properties.retainFilesOnExit()) {
            return new StoreCleaner(rootFolder, true);
        }
        return new StoreCleaner(rootFolder, false);
    }
}

