/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock.dto;

import com.adobe.testing.S3Verified;
import com.adobe.testing.s3mock.dto.ChecksumAlgorithm;
import com.adobe.testing.s3mock.dto.ChecksumType;
import com.adobe.testing.s3mock.dto.Owner;
import com.adobe.testing.s3mock.dto.RestoreStatus;
import com.adobe.testing.s3mock.dto.S3Object;
import com.adobe.testing.s3mock.dto.StorageClass;
import com.adobe.testing.s3mock.store.S3ObjectMetadata;
import com.adobe.testing.s3mock.util.EtagUtil;
import com.fasterxml.jackson.annotation.JsonProperty;

@S3Verified(year=2025)
public record ObjectVersion(@JsonProperty(value="ChecksumAlgorithm") ChecksumAlgorithm checksumAlgorithm, @JsonProperty(value="ChecksumType") ChecksumType checksumType, @JsonProperty(value="ETag") String etag, @JsonProperty(value="IsLatest") Boolean isLatest, @JsonProperty(value="Key") String key, @JsonProperty(value="LastModified") String lastModified, @JsonProperty(value="Owner") Owner owner, @JsonProperty(value="RestoreStatus") RestoreStatus restoreStatus, @JsonProperty(value="Size") String size, @JsonProperty(value="StorageClass") StorageClass storageClass, @JsonProperty(value="VersionId") String versionId) {
    public ObjectVersion {
        etag = EtagUtil.normalizeEtag(etag);
    }

    public static ObjectVersion from(S3ObjectMetadata s3ObjectMetadata, boolean isLatest) {
        return new ObjectVersion(s3ObjectMetadata.checksumAlgorithm(), s3ObjectMetadata.checksumType(), s3ObjectMetadata.etag(), isLatest, s3ObjectMetadata.key(), s3ObjectMetadata.modificationDate(), s3ObjectMetadata.owner(), null, s3ObjectMetadata.size(), s3ObjectMetadata.storageClass(), s3ObjectMetadata.versionId());
    }

    public static ObjectVersion from(S3Object s3Object) {
        return new ObjectVersion(s3Object.checksumAlgorithm(), s3Object.checksumType(), s3Object.etag(), true, s3Object.key(), s3Object.lastModified(), s3Object.owner(), s3Object.restoreStatus(), s3Object.size(), s3Object.storageClass(), "null");
    }
}

