/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock.dto;

import com.adobe.testing.S3Verified;
import com.adobe.testing.s3mock.dto.ChecksumAlgorithm;
import com.adobe.testing.s3mock.util.EtagUtil;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import java.util.Date;

@JsonRootName(value="CopyPartResult")
@S3Verified(year=2025)
public record CopyPartResult(@JsonProperty(value="ChecksumCRC32") String checksumCRC32, @JsonProperty(value="ChecksumCRC32C") String checksumCRC32C, @JsonProperty(value="ChecksumCRC64NVME") String checksumCRC64NVME, @JsonProperty(value="ChecksumSHA1") String checksumSHA1, @JsonProperty(value="ChecksumSHA256") String checksumSHA256, @JsonProperty(value="ETag") String etag, @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", timezone="UTC") @JsonProperty(value="LastModified") Date lastModified, @JacksonXmlProperty(isAttribute=true, localName="xmlns") String xmlns) {
    public CopyPartResult {
        etag = EtagUtil.normalizeEtag(etag);
        if (xmlns == null) {
            xmlns = "http://s3.amazonaws.com/doc/2006-03-01/";
        }
    }

    public CopyPartResult(Date date, String etag) {
        this(null, null, null, null, null, etag, date, null);
    }

    public CopyPartResult(ChecksumAlgorithm checksumAlgorithm, String checksum, String etag, Date lastModified) {
        this(checksumAlgorithm == ChecksumAlgorithm.CRC32 ? checksum : null, checksumAlgorithm == ChecksumAlgorithm.CRC32C ? checksum : null, checksumAlgorithm == ChecksumAlgorithm.CRC64NVME ? checksum : null, checksumAlgorithm == ChecksumAlgorithm.SHA1 ? checksum : null, checksumAlgorithm == ChecksumAlgorithm.SHA256 ? checksum : null, etag, lastModified, null);
    }

    public static CopyPartResult from(Date date, String etag) {
        return new CopyPartResult(date, etag);
    }
}

