/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock.service;

import com.adobe.testing.s3mock.S3Exception;
import com.adobe.testing.s3mock.dto.ChecksumAlgorithm;
import com.adobe.testing.s3mock.dto.CompleteMultipartUploadResult;
import com.adobe.testing.s3mock.dto.CompletedPart;
import com.adobe.testing.s3mock.dto.CopyPartResult;
import com.adobe.testing.s3mock.dto.InitiateMultipartUploadResult;
import com.adobe.testing.s3mock.dto.ListMultipartUploadsResult;
import com.adobe.testing.s3mock.dto.ListPartsResult;
import com.adobe.testing.s3mock.dto.MultipartUpload;
import com.adobe.testing.s3mock.dto.Owner;
import com.adobe.testing.s3mock.dto.Part;
import com.adobe.testing.s3mock.dto.StorageClass;
import com.adobe.testing.s3mock.service.ServiceBase;
import com.adobe.testing.s3mock.store.BucketMetadata;
import com.adobe.testing.s3mock.store.BucketStore;
import com.adobe.testing.s3mock.store.MultipartStore;
import com.adobe.testing.s3mock.store.MultipartUploadInfo;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpRange;

public class MultipartService
extends ServiceBase {
    private static final Logger LOG = LoggerFactory.getLogger(MultipartService.class);
    static final Long MINIMUM_PART_SIZE = 0x500000L;
    private final BucketStore bucketStore;
    private final MultipartStore multipartStore;

    public MultipartService(BucketStore bucketStore, MultipartStore multipartStore) {
        this.bucketStore = bucketStore;
        this.multipartStore = multipartStore;
    }

    public String putPart(String bucketName, String key, String uploadId, String partNumber, Path path, Map<String, String> encryptionHeaders) {
        BucketMetadata bucketMetadata = this.bucketStore.getBucketMetadata(bucketName);
        UUID uuid = bucketMetadata.getID(key);
        if (uuid == null) {
            return null;
        }
        return this.multipartStore.putPart(bucketMetadata, uuid, uploadId, partNumber, path, encryptionHeaders);
    }

    public CopyPartResult copyPart(String bucketName, String key, HttpRange copyRange, String partNumber, String destinationBucket, String destinationKey, String uploadId, Map<String, String> encryptionHeaders) {
        BucketMetadata sourceBucketMetadata = this.bucketStore.getBucketMetadata(bucketName);
        BucketMetadata destinationBucketMetadata = this.bucketStore.getBucketMetadata(destinationBucket);
        UUID sourceId = sourceBucketMetadata.getID(key);
        if (sourceId == null) {
            return null;
        }
        UUID destinationId = this.bucketStore.addKeyToBucket(destinationKey, destinationBucket);
        try {
            String partEtag = this.multipartStore.copyPart(sourceBucketMetadata, sourceId, copyRange, partNumber, destinationBucketMetadata, destinationId, uploadId, encryptionHeaders);
            return CopyPartResult.from(new Date(), "\"" + partEtag + "\"");
        }
        catch (Exception e) {
            this.bucketStore.removeFromBucket(destinationKey, destinationBucket);
            throw new IllegalStateException(String.format("Could not copy part. sourceBucket=%s, destinationBucket=%s, key=%s, sourceId=%s, destinationId=%s, uploadId=%s", sourceBucketMetadata, destinationBucketMetadata, key, sourceId, destinationId, uploadId), e);
        }
    }

    public ListPartsResult getMultipartUploadParts(String bucketName, String key, String uploadId) {
        BucketMetadata bucketMetadata = this.bucketStore.getBucketMetadata(bucketName);
        UUID id = bucketMetadata.getID(key);
        if (id == null) {
            return null;
        }
        List<Part> parts = this.multipartStore.getMultipartUploadParts(bucketMetadata, id, uploadId);
        return new ListPartsResult(bucketName, key, uploadId, parts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortMultipartUpload(String bucketName, String key, String uploadId) {
        BucketMetadata bucketMetadata = this.bucketStore.getBucketMetadata(bucketName);
        UUID id = bucketMetadata.getID(key);
        try {
            this.multipartStore.abortMultipartUpload(bucketMetadata, id, uploadId);
        }
        finally {
            this.bucketStore.removeFromBucket(key, bucketName);
        }
    }

    public CompleteMultipartUploadResult completeMultipartUpload(String bucketName, String key, String uploadId, List<CompletedPart> parts, Map<String, String> encryptionHeaders, String location) {
        BucketMetadata bucketMetadata = this.bucketStore.getBucketMetadata(bucketName);
        UUID id = bucketMetadata.getID(key);
        if (id == null) {
            return null;
        }
        MultipartUploadInfo multipartUploadInfo = this.multipartStore.getMultipartUploadInfo(bucketMetadata, uploadId);
        return this.multipartStore.completeMultipartUpload(bucketMetadata, key, id, uploadId, parts, encryptionHeaders, multipartUploadInfo, location);
    }

    public InitiateMultipartUploadResult createMultipartUpload(String bucketName, String key, String contentType, Map<String, String> storeHeaders, Owner owner, Owner initiator, Map<String, String> userMetadata, Map<String, String> encryptionHeaders, StorageClass storageClass, String checksum, ChecksumAlgorithm checksumAlgorithm) {
        BucketMetadata bucketMetadata = this.bucketStore.getBucketMetadata(bucketName);
        UUID id = this.bucketStore.addKeyToBucket(key, bucketName);
        try {
            MultipartUpload multipartUpload = this.multipartStore.createMultipartUpload(bucketMetadata, key, id, contentType, storeHeaders, owner, initiator, userMetadata, encryptionHeaders, storageClass, checksum, checksumAlgorithm);
            return new InitiateMultipartUploadResult(bucketName, key, multipartUpload.uploadId());
        }
        catch (Exception e) {
            this.bucketStore.removeFromBucket(key, bucketName);
            throw new IllegalStateException(String.format("Could prepare Multipart Upload. bucket=%s, key=%s, id=%s", bucketMetadata, key, id), e);
        }
    }

    public ListMultipartUploadsResult listMultipartUploads(String bucketName, String prefix) {
        BucketMetadata bucketMetadata = this.bucketStore.getBucketMetadata(bucketName);
        List<MultipartUpload> multipartUploads = this.multipartStore.listMultipartUploads(bucketMetadata, prefix);
        int maxUploads = Math.max(1000, multipartUploads.size());
        return new ListMultipartUploadsResult(bucketName, null, null, prefix, null, maxUploads, false, null, null, multipartUploads, Collections.emptyList());
    }

    public void verifyPartNumberLimits(String partNumberString) {
        try {
            int partNumber = Integer.parseInt(partNumberString);
            if (partNumber < 1 || partNumber > 10000) {
                LOG.error("Multipart part number invalid. partNumber={}", (Object)partNumberString);
                throw S3Exception.INVALID_PART_NUMBER;
            }
        }
        catch (NumberFormatException nfe) {
            LOG.error("Multipart part number invalid. partNumber={}", (Object)partNumberString, (Object)nfe);
            throw S3Exception.INVALID_PART_NUMBER;
        }
    }

    public void verifyMultipartParts(String bucketName, String key, String uploadId, List<CompletedPart> requestedParts) throws S3Exception {
        BucketMetadata bucketMetadata = this.bucketStore.getBucketMetadata(bucketName);
        UUID id = bucketMetadata.getID(key);
        if (id == null) {
            throw S3Exception.INVALID_PART;
        }
        this.verifyMultipartParts(bucketName, id, uploadId);
        List<Part> uploadedParts = this.multipartStore.getMultipartUploadParts(bucketMetadata, id, uploadId);
        Map<Integer, String> uploadedPartsMap = uploadedParts.stream().collect(Collectors.toMap(Part::partNumber, Part::etag));
        int prevPartNumber = 0;
        for (CompletedPart part : requestedParts) {
            if (!uploadedPartsMap.containsKey(part.partNumber()) || !uploadedPartsMap.get(part.partNumber()).equals(part.etag())) {
                LOG.error("Multipart part not valid. bucket={}, id={}, uploadId={}, partNumber={}", new Object[]{bucketMetadata, id, uploadId, part.partNumber()});
                throw S3Exception.INVALID_PART;
            }
            if (part.partNumber() < prevPartNumber) {
                LOG.error("Multipart parts order invalid. bucket={}, id={}, uploadId={}, partNumber={}", new Object[]{bucketMetadata, id, uploadId, part.partNumber()});
                throw S3Exception.INVALID_PART_ORDER;
            }
            prevPartNumber = part.partNumber();
        }
    }

    public void verifyMultipartParts(String bucketName, UUID id, String uploadId) throws S3Exception {
        this.verifyMultipartUploadExists(bucketName, uploadId);
        BucketMetadata bucketMetadata = this.bucketStore.getBucketMetadata(bucketName);
        List<Part> uploadedParts = this.multipartStore.getMultipartUploadParts(bucketMetadata, id, uploadId);
        if (!uploadedParts.isEmpty()) {
            for (int i = 0; i < uploadedParts.size() - 1; ++i) {
                Part part = uploadedParts.get(i);
                if (part.size() >= MINIMUM_PART_SIZE) continue;
                LOG.error("Multipart part size too small. bucket={}, id={}, uploadId={}, size={}", new Object[]{bucketMetadata, id, uploadId, part.size()});
                throw S3Exception.ENTITY_TOO_SMALL;
            }
        }
    }

    public void verifyMultipartUploadExists(String bucketName, String uploadId) throws S3Exception {
        try {
            BucketMetadata bucketMetadata = this.bucketStore.getBucketMetadata(bucketName);
            this.multipartStore.getMultipartUpload(bucketMetadata, uploadId);
        }
        catch (IllegalArgumentException e) {
            throw S3Exception.NO_SUCH_UPLOAD_MULTIPART;
        }
    }
}

