/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock.util;

import com.adobe.testing.s3mock.dto.ChecksumAlgorithm;
import com.adobe.testing.s3mock.util.AbstractAwsInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;

public class AwsChecksumInputStream
extends AbstractAwsInputStream {
    protected static final byte[] CHECKSUM_HEADER = "x-amz-checksum-".getBytes(StandardCharsets.UTF_8);
    protected String checksum;
    protected ChecksumAlgorithm algorithm;

    public AwsChecksumInputStream(InputStream source) {
        super(source);
    }

    @Override
    public int read() throws IOException {
        if (this.payloadLength == 0L) {
            byte[] hexLengthBytes = this.readUntil(CRLF);
            if (hexLengthBytes.length == 0) {
                return -1;
            }
            this.setPayloadLength(hexLengthBytes);
        }
        if (this.payloadLength > 0L) {
            --this.payloadLength;
            return this.source.read();
        }
        this.extractAlgorithmAndChecksum();
        return -1;
    }

    protected void extractAlgorithmAndChecksum() throws IOException {
        if (this.algorithm == null && this.checksum == null) {
            this.readUntil(CHECKSUM_HEADER);
            byte[] typeAndChecksum = this.readUntil(CRLF);
            String typeAndChecksumString = new String(typeAndChecksum);
            String[] split = typeAndChecksumString.split(":");
            String type = split[0];
            this.algorithm = ChecksumAlgorithm.fromString(type);
            this.checksum = split[1];
        }
    }

    public String getChecksum() {
        return this.checksum;
    }

    public ChecksumAlgorithm getAlgorithm() {
        return this.algorithm;
    }
}

