/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringEncoding {
    private static final Logger LOG = LoggerFactory.getLogger(StringEncoding.class);

    public static String encode(String toEncode) {
        try {
            return URLEncoder.encode(toEncode, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("Error encoding string {}", (Object)toEncode, (Object)e);
            throw new AssertionError((Object)(StandardCharsets.UTF_8.name() + " is unknown"));
        }
    }

    public static String decode(String toDecode) {
        try {
            return URLDecoder.decode(toDecode, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("Error decoding string {}", (Object)toDecode, (Object)e);
            throw new AssertionError((Object)(StandardCharsets.UTF_8.name() + " is unknown"));
        }
    }
}

