/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock.util;

import com.adobe.testing.s3mock.dto.Range;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.core.convert.converter.Converter;
import org.springframework.util.StringUtils;

public class RangeConverter
implements Converter<String, Range> {
    private static final String REQUESTED_RANGE_REGEXP = "^bytes=((\\d*)\\-(\\d*))((,\\d*-\\d*)*)";
    private static final Pattern REQUESTED_RANGE_PATTERN = Pattern.compile("^bytes=((\\d*)\\-(\\d*))((,\\d*-\\d*)*)");

    public Range convert(String rangeString) {
        Range range;
        Objects.requireNonNull(rangeString);
        rangeString = rangeString.trim();
        Matcher matcher = REQUESTED_RANGE_PATTERN.matcher(rangeString);
        if (matcher.matches()) {
            String rangeStart = matcher.group(2);
            String rangeEnd = matcher.group(3);
            range = new Range(rangeStart == null ? 0L : Long.parseLong(rangeStart), StringUtils.isEmpty((Object)rangeEnd) ? Long.MAX_VALUE : Long.parseLong(rangeEnd));
            if (matcher.groupCount() == 5 && !"".equals(matcher.group(4))) {
                throw new IllegalArgumentException("Unsupported range specification. Only single range specifications allowed");
            }
            if (range.getStart() < 0L) {
                throw new IllegalArgumentException("Unsupported range specification. A start byte must be supplied");
            }
            if (range.getEnd() != -1L && range.getEnd() < range.getStart()) {
                throw new IllegalArgumentException("Range header is malformed. End byte is smaller than start byte.");
            }
        } else {
            throw new IllegalArgumentException("Range header is malformed. Only bytes supported as range type.");
        }
        return range;
    }
}

