/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock.dto;

import com.adobe.testing.s3mock.dto.Owner;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import com.thoughtworks.xstream.converters.extended.ISO8601DateConverter;
import java.util.Date;
import java.util.Objects;

@XStreamAlias(value="Upload")
public class MultipartUpload {
    @XStreamAlias(value="Key")
    private final String key;
    @XStreamAlias(value="UploadId")
    private final String uploadId;
    @XStreamAlias(value="Owner")
    private final Owner owner;
    @XStreamAlias(value="Initiator")
    private final Owner initiator;
    @XStreamAlias(value="StorageClass")
    private final String storageClass = "STANDARD";
    @XStreamAlias(value="Initiated")
    @XStreamConverter(value=ISO8601DateConverter.class)
    private final Date initiated;

    public MultipartUpload(String key, String uploadId, Owner owner, Owner initiator, Date initiated) {
        this.key = key;
        this.uploadId = uploadId;
        this.owner = owner;
        this.initiator = initiator;
        this.initiated = initiated;
    }

    public String getKey() {
        return this.key;
    }

    public String getUploadId() {
        return this.uploadId;
    }

    public Owner getOwner() {
        return this.owner;
    }

    public Owner getInitiator() {
        return this.initiator;
    }

    public String getStorageClass() {
        return "STANDARD";
    }

    public Date getInitiated() {
        return this.initiated;
    }

    public String toString() {
        return "MultipartUpload{key='" + this.key + '\'' + ", uploadId='" + this.uploadId + '\'' + ", owner=" + this.owner + ", initiator=" + this.initiator + ", storageClass='" + "STANDARD" + '\'' + ", initiated=" + this.initiated + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultipartUpload that = (MultipartUpload)o;
        return Objects.equals(this.key, that.key) && Objects.equals(this.uploadId, that.uploadId) && Objects.equals(this.owner, that.owner) && Objects.equals(this.initiator, that.initiator) && Objects.equals("STANDARD", that.storageClass) && Objects.equals(this.initiated, that.initiated);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.uploadId, this.owner, this.initiator, "STANDARD", this.initiated);
    }
}

