/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.sign.utils.validator;

import com.adobe.sign.model.widgets.CounterSignerInfo;
import com.adobe.sign.model.widgets.CounterSignerSetInfo;
import com.adobe.sign.model.widgets.WidgetCreationInfo;
import com.adobe.sign.model.widgets.WidgetCreationRequest;
import com.adobe.sign.model.widgets.WidgetFileInfo;
import com.adobe.sign.model.widgets.WidgetPersonalizationInfo;
import com.adobe.sign.model.widgets.WidgetStatusUpdateInfo;
import com.adobe.sign.utils.ApiException;
import com.adobe.sign.utils.StringUtil;
import com.adobe.sign.utils.validator.ApiValidatorHelper;
import com.adobe.sign.utils.validator.SdkErrorCodes;
import java.util.List;

public class WidgetsApiValidator {
    private static final String WIDGET_CREATION_REQUEST = "widgetCreationRequest";
    private static final String WIDGET_CREATION_INFO = "widgetCreationInfo";
    private static final String NAME = "name";
    private static final String WIDGET_STATUS_UPDATE_INFO = "widgetStatusUpdateInfo";
    private static final String COUNTER_SINGER_SET_MEMBER_INFOS = "counterSignerSetMemberInfos";
    private static final String COUNTER_SINGER_SET_ROLE = "counterSignerSetRole";
    private static final String WIDGET_PERSONALIZATION_INFO = "widgetPersonalizationInfo";

    public static void getWidgetsValidator() throws ApiException {
    }

    public static void createWidgetValidator(WidgetCreationRequest widgetCreationRequest) throws ApiException {
        List<CounterSignerSetInfo> counterSignerSetInfo;
        ApiValidatorHelper.validateParameter(widgetCreationRequest, WIDGET_CREATION_REQUEST);
        WidgetCreationInfo widgetCreationInfo = widgetCreationRequest.getWidgetCreationInfo();
        ApiValidatorHelper.validateParameter(widgetCreationInfo, WIDGET_CREATION_INFO);
        List<WidgetFileInfo> fileInfos = widgetCreationInfo.getFileInfos();
        WidgetsApiValidator.validateFileInfo(fileInfos);
        ApiValidatorHelper.validateParameter(widgetCreationInfo.getName(), NAME);
        if (widgetCreationInfo.getSignatureFlow() != null) {
            ApiValidatorHelper.validateParameter(widgetCreationInfo.getSignatureFlow(), SdkErrorCodes.INVALID_SIGNATURE_FLOW);
        }
        if ((counterSignerSetInfo = widgetCreationInfo.getCounterSignerSetInfos()) != null) {
            WidgetsApiValidator.validateCounterSignerSetInfo(counterSignerSetInfo);
        }
    }

    public static void getWidgetInfoValidator(String widgetId) throws ApiException {
        ApiValidatorHelper.validateId(widgetId, SdkErrorCodes.INVALID_WIDGET_ID);
    }

    public static void getWidgetAgreementsValidator(String widgetId) throws ApiException {
        ApiValidatorHelper.validateId(widgetId, SdkErrorCodes.INVALID_WIDGET_ID);
    }

    public static void getWidgetAuditTrailValidator(String widgetId) throws ApiException {
        ApiValidatorHelper.validateId(widgetId, SdkErrorCodes.INVALID_WIDGET_ID);
    }

    public static void getWidgetCombinedDocumentValidator(String widgetId, String versionId, String participantEmail, Boolean auditReport) throws ApiException {
        ApiValidatorHelper.validateId(widgetId, SdkErrorCodes.INVALID_WIDGET_ID);
        ApiValidatorHelper.validateVersionIdAndParticipantEmail(versionId, participantEmail);
    }

    public static void getWidgetDocumentsValidator(String widgetId, String versionId, String participantEmail) throws ApiException {
        ApiValidatorHelper.validateId(widgetId, SdkErrorCodes.INVALID_WIDGET_ID);
        ApiValidatorHelper.validateVersionIdAndParticipantEmail(versionId, participantEmail);
    }

    public static void getWidgetDocumentInfoValidator(String widgetId, String documentId) throws ApiException {
        ApiValidatorHelper.validateId(widgetId, SdkErrorCodes.INVALID_WIDGET_ID);
        ApiValidatorHelper.validateId(documentId, SdkErrorCodes.INVALID_DOCUMENT_ID);
    }

    public static void getWidgetFormDataValidator(String widgetId) throws ApiException {
        ApiValidatorHelper.validateId(widgetId, SdkErrorCodes.INVALID_WIDGET_ID);
    }

    public static void updateWidgetPersonalizeValidator(String widgetId, WidgetPersonalizationInfo widgetPersonalizationInfo) throws ApiException {
        ApiValidatorHelper.validateId(widgetId, SdkErrorCodes.INVALID_WIDGET_ID);
        ApiValidatorHelper.validateParameter(widgetPersonalizationInfo, WIDGET_PERSONALIZATION_INFO);
        ApiValidatorHelper.validateEmailParamater(widgetPersonalizationInfo.getEmail());
    }

    public static void updateWidgetStatusValidator(String widgetId, WidgetStatusUpdateInfo widgetStatusUpdateInfo) throws ApiException {
        ApiValidatorHelper.validateId(widgetId, SdkErrorCodes.INVALID_WIDGET_ID);
        ApiValidatorHelper.validateParameter(widgetStatusUpdateInfo, WIDGET_STATUS_UPDATE_INFO);
        ApiValidatorHelper.validateParameter(widgetStatusUpdateInfo.getValue(), SdkErrorCodes.MUST_PROVIDE_VALID_WIDGET_STATUS);
        String message = widgetStatusUpdateInfo.getMessage();
        String redirectUrl = widgetStatusUpdateInfo.getRedirectUrl();
        if (!StringUtil.isEmpty(message) && !StringUtil.isEmpty(redirectUrl)) {
            throw new ApiException(SdkErrorCodes.TOO_MANY_ACTIONS_SPECIFIED);
        }
        if (StringUtil.isEmpty(message) && StringUtil.isEmpty(redirectUrl)) {
            throw new ApiException(SdkErrorCodes.NO_ACTION_SPECIFIED);
        }
        if (!StringUtil.isEmpty(redirectUrl)) {
            ApiValidatorHelper.validateUrlParameter(redirectUrl, SdkErrorCodes.INVALID_URL);
        }
    }

    private static void validateFileInfo(List<WidgetFileInfo> fileInfos) throws ApiException {
        if (fileInfos == null) {
            throw new ApiException(SdkErrorCodes.INVALID_FILE_INFO);
        }
        for (WidgetFileInfo fileInfo : fileInfos) {
            if (fileInfo == null) {
                throw new ApiException(SdkErrorCodes.INVALID_FILE_INFO);
            }
            String url = fileInfo.getDocumentURL() == null ? null : fileInfo.getDocumentURL().getUrl();
            ApiValidatorHelper.validateFileInfo(fileInfo.getDocumentURL(), fileInfo.getLibraryDocumentId(), fileInfo.getLibraryDocumentName(), fileInfo.getTransientDocumentId(), url);
        }
    }

    private static void validateCounterSignerSetInfo(List<CounterSignerSetInfo> counterSignerSetInfos) throws ApiException {
        for (CounterSignerSetInfo counterSignerSetInfo : counterSignerSetInfos) {
            ApiValidatorHelper.validateParameter(counterSignerSetInfo.getCounterSignerSetMemberInfos(), COUNTER_SINGER_SET_MEMBER_INFOS);
            List<CounterSignerInfo> counterSignerInfos = counterSignerSetInfo.getCounterSignerSetMemberInfos();
            int numberOfRecipients = counterSignerInfos.size();
            for (CounterSignerInfo counterSignerInfo : counterSignerInfos) {
                ApiValidatorHelper.validateRecipientSetInfos(counterSignerInfo.getEmail(), null, numberOfRecipients);
            }
            ApiValidatorHelper.validateParameter(counterSignerSetInfo.getCounterSignerSetRole(), COUNTER_SINGER_SET_ROLE);
        }
    }
}

