/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.sign.utils.validator;

import com.adobe.sign.model.views.AgreementAssetListRequest;
import com.adobe.sign.model.views.AgreementAssetRequest;
import com.adobe.sign.model.views.TargetViewRequest;
import com.adobe.sign.utils.ApiException;
import com.adobe.sign.utils.validator.ApiValidatorHelper;
import com.adobe.sign.utils.validator.SdkErrorCodes;

public class ViewsApiValidator {
    private static final String TARGET_VIEW_REQUEST = "targetViewRequest";
    private static final String AGREEMENT_ASSET_REQUEST = "agreementAssetRequest";

    public static void createAgreementAssetListUrlValidator(AgreementAssetListRequest agreementAssetListRequest) throws ApiException {
        if (agreementAssetListRequest != null && agreementAssetListRequest.getAgreementAssetId() != null) {
            ApiValidatorHelper.validateId(agreementAssetListRequest.getAgreementAssetId(), SdkErrorCodes.INVALID_AGREEMENT_ASSET_ID);
        }
    }

    public static void createAgreementAssetUrlValidator(AgreementAssetRequest agreementAssetRequest) throws ApiException {
        ApiValidatorHelper.validateParameter(agreementAssetRequest, AGREEMENT_ASSET_REQUEST);
        ApiValidatorHelper.validateId(agreementAssetRequest.getAgreementAssetId(), SdkErrorCodes.INVALID_AGREEMENT_ASSET_ID);
    }

    public static void createSettingsUrlValidator(TargetViewRequest targetViewRequest) throws ApiException {
        ApiValidatorHelper.validateParameter(targetViewRequest, TARGET_VIEW_REQUEST);
        ApiValidatorHelper.validateParameter(targetViewRequest.getTargetView(), SdkErrorCodes.INVALID_TARGET_VIEW);
    }
}

