/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.sign.utils.validator;

import com.adobe.sign.model.users.UserCreationInfo;
import com.adobe.sign.model.users.UserModificationInfo;
import com.adobe.sign.model.users.UserStatusUpdateInfo;
import com.adobe.sign.utils.ApiException;
import com.adobe.sign.utils.validator.ApiValidatorHelper;
import com.adobe.sign.utils.validator.SdkErrorCodes;
import java.util.HashMap;

public class UsersApiValidator {
    private static final String USER_CREATION_INFO = "userCreationInfo";
    private static final String USER_MODIFICATION_INFO = "userModificationInfo";
    private static final String USER_STATUS_UPDATE_INFO = "userStatusUpdateInfo";
    private static final String FIRST_NAME = "firstName";
    private static final String LAST_NAME = "lastName";
    private static final String ROLES = "roles";
    private static final String GROUP_ID = "groupId";
    private static final String EMAIL = "email";

    public static void getUsersValidator(String xUserEmail) throws ApiException {
    }

    public static void createUserValidator(UserCreationInfo userCreationInfo) throws ApiException {
        ApiValidatorHelper.validateParameter(userCreationInfo, USER_CREATION_INFO);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(FIRST_NAME, userCreationInfo.getFirstName());
        hashMap.put(LAST_NAME, userCreationInfo.getLastName());
        ApiValidatorHelper.validateRequiredParameters(hashMap);
        ApiValidatorHelper.validateParameter(userCreationInfo.getEmail(), SdkErrorCodes.MUST_PROVIDE_EMAIL);
        ApiValidatorHelper.validateEmailParamater(userCreationInfo.getEmail());
    }

    public static void getUserDetailValidator(String userId) throws ApiException {
        ApiValidatorHelper.validateId(userId, SdkErrorCodes.INVALID_USER_ID);
    }

    public static void modifyUserValidator(String userId, UserModificationInfo userModificationInfo) throws ApiException {
        ApiValidatorHelper.validateId(userId, SdkErrorCodes.INVALID_USER_ID);
        ApiValidatorHelper.validateParameter(userModificationInfo, USER_MODIFICATION_INFO);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(FIRST_NAME, userModificationInfo.getFirstName());
        hashMap.put(LAST_NAME, userModificationInfo.getLastName());
        hashMap.put(EMAIL, userModificationInfo.getEmail());
        hashMap.put(GROUP_ID, userModificationInfo.getGroupId());
        ApiValidatorHelper.validateRequiredParameters(hashMap);
        ApiValidatorHelper.validateId(userModificationInfo.getGroupId(), SdkErrorCodes.INVALID_GROUP_ID);
        ApiValidatorHelper.validateEmailParamater(userModificationInfo.getEmail());
        ApiValidatorHelper.validateParameter(userModificationInfo.getRoles(), ROLES);
    }

    public static void modifyUserStatusValidator(String userId, UserStatusUpdateInfo userStatusUpdateInfo) throws ApiException {
        ApiValidatorHelper.validateId(userId, SdkErrorCodes.INVALID_USER_ID);
        ApiValidatorHelper.validateParameter(userStatusUpdateInfo, USER_STATUS_UPDATE_INFO);
        ApiValidatorHelper.validateParameter(userStatusUpdateInfo.getUserStatus(), SdkErrorCodes.MUST_PROVIDE_VALID_USER_STATUS);
    }
}

