/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.sign.utils.validator;

import com.adobe.sign.model.oAuth.AccessTokenRefreshRequest;
import com.adobe.sign.model.oAuth.AccessTokenRequest;
import com.adobe.sign.model.oAuth.AuthorizationRequest;
import com.adobe.sign.model.oAuth.Token;
import com.adobe.sign.utils.ApiException;
import com.adobe.sign.utils.validator.ApiValidatorHelper;
import com.adobe.sign.utils.validator.SdkErrorCodes;
import java.util.HashMap;

public class OAuthApiValidator {
    private static final String TOKEN = "token";
    private static final String ACCESS_TOKEN_REQUEST = "accessTokenRequest";
    private static final String AUTHORIZATION_REQUEST = "authorizationRequest";
    private static final String ACESS_TOKEN_REFRESH_REQUEST = "accessTokenRefreshRequest";
    private static final String SCOPES = "scopes";
    private static final String CLIENT_ID = "clientId";
    private static final String CLIENT_SECRET = "clientSecret";
    private static final String REFRESH_TOKEN = "refreshToken";
    private static final String GRANT_TYPE = "grantType";
    private static final String CODE = "code";
    private static final String RESPONSE_TYPE = "responseType";
    private static final String REDIRECT_URI = "redirectUri";

    public static void getAuthorizationUrlValidator(AuthorizationRequest authorizationRequest) throws ApiException {
        ApiValidatorHelper.validateParameter(authorizationRequest, AUTHORIZATION_REQUEST);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(CLIENT_ID, authorizationRequest.getClientId());
        hashMap.put(REDIRECT_URI, authorizationRequest.getRedirectUri());
        hashMap.put(RESPONSE_TYPE, authorizationRequest.getResponseType());
        ApiValidatorHelper.validateRequiredParameters(hashMap);
        ApiValidatorHelper.validateParameter(authorizationRequest.getScopes(), SCOPES);
        OAuthApiValidator.validateRedirectUri(authorizationRequest.getRedirectUri());
    }

    public static void getAccessTokenValidator(AccessTokenRequest accessTokenRequest) throws ApiException {
        ApiValidatorHelper.validateParameter(accessTokenRequest, ACCESS_TOKEN_REQUEST);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(CLIENT_ID, accessTokenRequest.getClientId());
        hashMap.put(CLIENT_SECRET, accessTokenRequest.getClientSecret());
        hashMap.put(CODE, accessTokenRequest.getCode());
        hashMap.put(GRANT_TYPE, accessTokenRequest.getGrantType());
        ApiValidatorHelper.validateRequiredParameters(hashMap);
        OAuthApiValidator.validateRedirectUri(accessTokenRequest.getRedirectUri());
    }

    public static void refreshAccessTokenValidator(AccessTokenRefreshRequest accessTokenRefreshRequest) throws ApiException {
        ApiValidatorHelper.validateParameter(accessTokenRefreshRequest, ACESS_TOKEN_REFRESH_REQUEST);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(CLIENT_ID, accessTokenRefreshRequest.getClientId());
        hashMap.put(CLIENT_SECRET, accessTokenRefreshRequest.getClientSecret());
        hashMap.put(REFRESH_TOKEN, accessTokenRefreshRequest.getRefreshToken());
        hashMap.put(GRANT_TYPE, accessTokenRefreshRequest.getGrantType());
        ApiValidatorHelper.validateRequiredParameters(hashMap);
    }

    public static void revokeTokenValidator(Token token) throws ApiException {
        ApiValidatorHelper.validateParameter(token, TOKEN);
        ApiValidatorHelper.validateParameter(token.getToken(), SdkErrorCodes.MISSING_REQUIRED_PARAM);
    }

    private static void validateRedirectUri(String redirectUri) throws ApiException {
        ApiValidatorHelper.validateParameter(redirectUri, SdkErrorCodes.MISSING_REQUIRED_PARAM);
        ApiValidatorHelper.validateUrlParameter(redirectUri, SdkErrorCodes.INVALID_REQUEST);
    }
}

