/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.sign.utils.validator;

import com.adobe.sign.model.libraryDocuments.FileInfo;
import com.adobe.sign.model.libraryDocuments.LibraryCreationInfo;
import com.adobe.sign.model.libraryDocuments.LibraryDocumentCreationInfo;
import com.adobe.sign.utils.ApiException;
import com.adobe.sign.utils.validator.ApiValidatorHelper;
import com.adobe.sign.utils.validator.SdkErrorCodes;
import java.util.List;

public class LibraryDocumentsApiValidator {
    private static final String LIBRARY_CREATION_INFO = "libraryCreationInfo";
    private static final String LIBRARY_SHARING_MODE = "librarySharingMode";
    private static final String LIBRARY_TEMPLATE_TYPES = "libraryTemplateTypes";
    private static final String NAME = "name";

    public static void getLibraryDocumentsValidator() throws ApiException {
    }

    public static void createLibraryDocumentValidator(LibraryCreationInfo libraryCreationInfo) throws ApiException {
        ApiValidatorHelper.validateParameter(libraryCreationInfo, LIBRARY_CREATION_INFO);
        LibraryDocumentCreationInfo libraryDocumentCreationInfo = libraryCreationInfo.getLibraryDocumentCreationInfo();
        LibraryDocumentsApiValidator.validateFileInfo(libraryDocumentCreationInfo.getFileInfos());
        ApiValidatorHelper.validateParameter(libraryDocumentCreationInfo.getLibrarySharingMode(), LIBRARY_SHARING_MODE);
        ApiValidatorHelper.validateParameter(libraryDocumentCreationInfo.getLibraryTemplateTypes(), LIBRARY_TEMPLATE_TYPES);
        ApiValidatorHelper.validateParameter(libraryDocumentCreationInfo.getName(), NAME);
    }

    public static void getLibraryDocumentInfoValidator(String libraryDocumentId) throws ApiException {
        ApiValidatorHelper.validateId(libraryDocumentId, SdkErrorCodes.INVALID_LIBRARYDOCUMENT_ID);
    }

    public static void deleteLibraryDocumentValidator(String libraryDocumentId) throws ApiException {
        ApiValidatorHelper.validateId(libraryDocumentId, SdkErrorCodes.INVALID_LIBRARYDOCUMENT_ID);
    }

    public static void getLibraryDocumentAuditTrailValidator(String libraryDocumentId) throws ApiException {
        ApiValidatorHelper.validateId(libraryDocumentId, SdkErrorCodes.INVALID_LIBRARYDOCUMENT_ID);
    }

    public static void getCombinedDocumentValidator(String libraryDocumentId, Boolean auditReport) throws ApiException {
        ApiValidatorHelper.validateId(libraryDocumentId, SdkErrorCodes.INVALID_LIBRARYDOCUMENT_ID);
    }

    public static void getDocumentsValidator(String libraryDocumentId) throws ApiException {
        ApiValidatorHelper.validateId(libraryDocumentId, SdkErrorCodes.INVALID_LIBRARYDOCUMENT_ID);
    }

    public static void getLibraryDocumentValidator(String libraryDocumentId, String documentId) throws ApiException {
        ApiValidatorHelper.validateId(libraryDocumentId, SdkErrorCodes.INVALID_LIBRARYDOCUMENT_ID);
        ApiValidatorHelper.validateId(documentId, SdkErrorCodes.INVALID_DOCUMENT_ID);
    }

    private static void validateFileInfo(List<FileInfo> fileInfos) throws ApiException {
        if (fileInfos == null) {
            throw new ApiException(SdkErrorCodes.INVALID_FILE_INFO);
        }
        for (FileInfo fileInfo : fileInfos) {
            if (fileInfo == null) {
                throw new ApiException(SdkErrorCodes.INVALID_FILE_INFO);
            }
            String url = fileInfo.getDocumentURL() == null ? null : fileInfo.getDocumentURL().getUrl();
            ApiValidatorHelper.validateFileInfo(fileInfo.getDocumentURL(), fileInfo.getLibraryDocumentId(), fileInfo.getLibraryDocumentName(), fileInfo.getTransientDocumentId(), url);
        }
    }
}

