/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.sign.utils.validator;

import com.adobe.sign.model.groups.GroupCreationInfo;
import com.adobe.sign.model.groups.GroupModificationInfo;
import com.adobe.sign.utils.ApiException;
import com.adobe.sign.utils.validator.ApiValidatorHelper;
import com.adobe.sign.utils.validator.SdkErrorCodes;

public class GroupsApiValidator {
    private static final String GROUP_CREATION_INFO = "groupCreationInfo";
    private static final String GROUP_MODIFICATION_INFO = "groupModificationInfo";

    public static void getGroupsValidator() throws ApiException {
    }

    public static void createGroupValidator(GroupCreationInfo groupCreationInfo) throws ApiException {
        ApiValidatorHelper.validateParameter(groupCreationInfo, GROUP_CREATION_INFO);
        ApiValidatorHelper.validateParameter(groupCreationInfo.getGroupName(), SdkErrorCodes.INVALID_GROUP_NAME);
    }

    public static void getGroupDetailsValidator(String groupId) throws ApiException {
        ApiValidatorHelper.validateId(groupId, SdkErrorCodes.INVALID_GROUP_ID);
    }

    public static void modifyGroupValidator(String groupId, GroupModificationInfo groupModificationInfo) throws ApiException {
        ApiValidatorHelper.validateId(groupId, SdkErrorCodes.INVALID_GROUP_ID);
        ApiValidatorHelper.validateParameter(groupModificationInfo, GROUP_MODIFICATION_INFO);
        ApiValidatorHelper.validateParameter(groupModificationInfo.getGroupName(), SdkErrorCodes.INVALID_GROUP_NAME);
    }

    public static void deleteGroupValidator(String groupId) throws ApiException {
        ApiValidatorHelper.validateId(groupId, SdkErrorCodes.INVALID_GROUP_ID);
    }

    public static void getUsersInGroupValidator(String groupId) throws ApiException {
        ApiValidatorHelper.validateId(groupId, SdkErrorCodes.INVALID_GROUP_ID);
    }
}

