/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.sign.model.users;

import com.adobe.sign.utils.StringUtil;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import java.util.List;

@ApiModel(description="")
public class UserDetailsInfo {
    private String account = null;
    private AccountTypeEnum accountType = null;
    private List<CapabilityFlagsEnum> capabilityFlags = null;
    private String channel = null;
    private String company = null;
    private String email = null;
    private String firstName = null;
    private String group = null;
    private String groupId = null;
    private String initials = null;
    private String lastName = null;
    private String locale = null;
    private OptInEnum optIn = null;
    private Date passwordExpiration = null;
    private String phone = null;
    private List<RolesEnum> roles = null;
    private String title = null;
    private UserStatusEnum userStatus = null;

    @ApiModelProperty(value="Nickname of the account to which the user belongs")
    @JsonProperty(value="account")
    public String getAccount() {
        return this.account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    @ApiModelProperty(value="Type of account to which the user belongs (null if no account)")
    @JsonProperty(value="accountType")
    public AccountTypeEnum getAccountType() {
        return this.accountType;
    }

    public void setAccountType(AccountTypeEnum accountType) {
        this.accountType = accountType;
    }

    @ApiModelProperty(value="A set of capabilities applicable to the user")
    @JsonProperty(value="capabilityFlags")
    public List<CapabilityFlagsEnum> getCapabilityFlags() {
        return this.capabilityFlags;
    }

    public void setCapabilityFlags(List<CapabilityFlagsEnum> capabilityFlags) {
        this.capabilityFlags = capabilityFlags;
    }

    @ApiModelProperty(value="Name of the channel to which the user belongs")
    @JsonProperty(value="channel")
    public String getChannel() {
        return this.channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    @ApiModelProperty(value="The name of company of the user")
    @JsonProperty(value="company")
    public String getCompany() {
        return this.company;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    @ApiModelProperty(required=true, value="The email address of the user")
    @JsonProperty(value="email")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    @ApiModelProperty(value="The first name of the user")
    @JsonProperty(value="firstName")
    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    @ApiModelProperty(value="Name of the group to which the user belongs")
    @JsonProperty(value="group")
    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    @ApiModelProperty(required=true, value="The identifier that can be used in group management methods")
    @JsonProperty(value="groupId")
    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    @ApiModelProperty(value="The initials of the user")
    @JsonProperty(value="initials")
    public String getInitials() {
        return this.initials;
    }

    public void setInitials(String initials) {
        this.initials = initials;
    }

    @ApiModelProperty(value="The last name of the user")
    @JsonProperty(value="lastName")
    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    @ApiModelProperty(value="The UI locale of the user")
    @JsonProperty(value="locale")
    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    @ApiModelProperty(value="Whether or not the user has opted in to receive marketing information from Adobe Sign and its partners. Default value is UNKNOWN")
    @JsonProperty(value="optIn")
    public OptInEnum getOptIn() {
        return this.optIn;
    }

    public void setOptIn(OptInEnum optIn) {
        this.optIn = optIn;
    }

    @ApiModelProperty(value="The date of password expiration")
    @JsonProperty(value="passwordExpiration")
    public Date getPasswordExpiration() {
        return this.passwordExpiration;
    }

    public void setPasswordExpiration(Date passwordExpiration) {
        this.passwordExpiration = passwordExpiration;
    }

    @ApiModelProperty(value="The phone number of the user")
    @JsonProperty(value="phone")
    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    @ApiModelProperty(value="The current roles of the user")
    @JsonProperty(value="roles")
    public List<RolesEnum> getRoles() {
        return this.roles;
    }

    public void setRoles(List<RolesEnum> roles) {
        this.roles = roles;
    }

    @ApiModelProperty(value="The job title of the user")
    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @ApiModelProperty(required=true, value="Status of the user")
    @JsonProperty(value="userStatus")
    public UserStatusEnum getUserStatus() {
        return this.userStatus;
    }

    public void setUserStatus(UserStatusEnum userStatus) {
        this.userStatus = userStatus;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserDetailsInfo {\n");
        sb.append("    account: ").append(StringUtil.toIndentedString(this.account)).append("\n");
        sb.append("    accountType: ").append(StringUtil.toIndentedString((Object)this.accountType)).append("\n");
        sb.append("    capabilityFlags: ").append(StringUtil.toIndentedString(this.capabilityFlags)).append("\n");
        sb.append("    channel: ").append(StringUtil.toIndentedString(this.channel)).append("\n");
        sb.append("    company: ").append(StringUtil.toIndentedString(this.company)).append("\n");
        sb.append("    email: ").append(StringUtil.toIndentedString(this.email)).append("\n");
        sb.append("    firstName: ").append(StringUtil.toIndentedString(this.firstName)).append("\n");
        sb.append("    group: ").append(StringUtil.toIndentedString(this.group)).append("\n");
        sb.append("    groupId: ").append(StringUtil.toIndentedString(this.groupId)).append("\n");
        sb.append("    initials: ").append(StringUtil.toIndentedString(this.initials)).append("\n");
        sb.append("    lastName: ").append(StringUtil.toIndentedString(this.lastName)).append("\n");
        sb.append("    locale: ").append(StringUtil.toIndentedString(this.locale)).append("\n");
        sb.append("    optIn: ").append(StringUtil.toIndentedString((Object)this.optIn)).append("\n");
        sb.append("    passwordExpiration: ").append(StringUtil.toIndentedString(this.passwordExpiration)).append("\n");
        sb.append("    phone: ").append(StringUtil.toIndentedString(this.phone)).append("\n");
        sb.append("    roles: ").append(StringUtil.toIndentedString(this.roles)).append("\n");
        sb.append("    title: ").append(StringUtil.toIndentedString(this.title)).append("\n");
        sb.append("    userStatus: ").append(StringUtil.toIndentedString((Object)this.userStatus)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public static enum UserStatusEnum {
        ACTIVE("ACTIVE"),
        INACTIVE("INACTIVE"),
        CREATED("CREATED"),
        PENDING("PENDING"),
        UNVERIFIED("UNVERIFIED");

        private String value;

        private UserStatusEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum RolesEnum {
        API("API"),
        ACCOUNT_ADMIN("ACCOUNT_ADMIN"),
        GROUP_ADMIN("GROUP_ADMIN"),
        OTHER("OTHER");

        private String value;

        private RolesEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum OptInEnum {
        YES("YES"),
        NO("NO"),
        UNKNOWN("UNKNOWN");

        private String value;

        private OptInEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum CapabilityFlagsEnum {
        CAN_SEND("CAN_SEND"),
        CAN_SIGN("CAN_SIGN"),
        CAN_REPLACE_SIGNER("CAN_REPLACE_SIGNER"),
        VAULT_ENABLED("VAULT_ENABLED"),
        VAULT_PER_AGREEMENT("VAULT_PER_AGREEMENT"),
        OTHER("OTHER");

        private String value;

        private CapabilityFlagsEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum AccountTypeEnum {
        FREE("FREE"),
        PRO("PRO"),
        TEAM("TEAM"),
        TEAM_TRIAL("TEAM_TRIAL"),
        ENTERPRISE("ENTERPRISE"),
        ENTERPRISE_TRIAL("ENTERPRISE_TRIAL"),
        GLOBAL("GLOBAL"),
        GLOBAL_TRIAL("GLOBAL_TRIAL");

        private String value;

        private AccountTypeEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

