/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.sign.model.search;

import com.adobe.sign.utils.StringUtil;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import java.util.List;

@ApiModel(description="")
public class AgreementAssetEventRequest {
    private Date endDate = null;
    private List<FilterEventsEnum> filterEvents = null;
    private Boolean onlyShowLatestEvent = null;
    private Integer pageSize = null;
    private Date startDate = null;

    @ApiModelProperty(required=true, value="The end of the date range for which events will be returned. Date should be mentioned in YYYY-MM-DDTHH:MM:SS format")
    @JsonProperty(value="endDate")
    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    @ApiModelProperty(value="If filterEvents are specified, only those event types will be returned. If filterEvents are not specified, all event types will be returned.The Agreement Event type should be given in form of array like [\"ESIGNED\",\"SIGNED\"]")
    @JsonProperty(value="filterEvents")
    public List<FilterEventsEnum> getFilterEvents() {
        return this.filterEvents;
    }

    public void setFilterEvents(List<FilterEventsEnum> filterEvents) {
        this.filterEvents = filterEvents;
    }

    @ApiModelProperty(value="If true, only the latest event for any given agreement asset within the specified date range will be returned. If false, all events will be returned")
    @JsonProperty(value="onlyShowLatestEvent")
    public Boolean getOnlyShowLatestEvent() {
        return this.onlyShowLatestEvent;
    }

    public void setOnlyShowLatestEvent(Boolean onlyShowLatestEvent) {
        this.onlyShowLatestEvent = onlyShowLatestEvent;
    }

    @ApiModelProperty(value="Count of agreement asset events which will be returned in the response. Default page size for the response is 100. Maximum value of page size is 500")
    @JsonProperty(value="pageSize")
    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    @ApiModelProperty(required=true, value="The beginning of the date range for which events will be returned. Date should be mentioned in YYYY-MM-DDTHH:MM:SS format")
    @JsonProperty(value="startDate")
    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AgreementAssetEventRequest {\n");
        sb.append("    endDate: ").append(StringUtil.toIndentedString(this.endDate)).append("\n");
        sb.append("    filterEvents: ").append(StringUtil.toIndentedString(this.filterEvents)).append("\n");
        sb.append("    onlyShowLatestEvent: ").append(StringUtil.toIndentedString(this.onlyShowLatestEvent)).append("\n");
        sb.append("    pageSize: ").append(StringUtil.toIndentedString(this.pageSize)).append("\n");
        sb.append("    startDate: ").append(StringUtil.toIndentedString(this.startDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public static enum FilterEventsEnum {
        CREATED("CREATED"),
        UPLOADED_BY_SENDER("UPLOADED_BY_SENDER"),
        FAXED_BY_SENDER("FAXED_BY_SENDER"),
        AGREEMENT_MODIFIED("AGREEMENT_MODIFIED"),
        USER_ACK_AGREEMENT_MODIFIED("USER_ACK_AGREEMENT_MODIFIED"),
        PRESIGNED("PRESIGNED"),
        SIGNED("SIGNED"),
        ESIGNED("ESIGNED"),
        DIGSIGNED("DIGSIGNED"),
        APPROVED("APPROVED"),
        OFFLINE_SYNC("OFFLINE_SYNC"),
        FAXIN_RECEIVED("FAXIN_RECEIVED"),
        SIGNATURE_REQUESTED("SIGNATURE_REQUESTED"),
        APPROVAL_REQUESTED("APPROVAL_REQUESTED"),
        RECALLED("RECALLED"),
        REJECTED("REJECTED"),
        EXPIRED("EXPIRED"),
        EXPIRED_AUTOMATICALLY("EXPIRED_AUTOMATICALLY"),
        SHARED("SHARED"),
        EMAIL_VIEWED("EMAIL_VIEWED"),
        AUTO_CANCELLED_CONVERSION_PROBLEM("AUTO_CANCELLED_CONVERSION_PROBLEM"),
        SIGNER_SUGGESTED_CHANGES("SIGNER_SUGGESTED_CHANGES"),
        SENDER_CREATED_NEW_REVISION("SENDER_CREATED_NEW_REVISION"),
        PASSWORD_AUTHENTICATION_FAILED("PASSWORD_AUTHENTICATION_FAILED"),
        KBA_AUTHENTICATION_FAILED("KBA_AUTHENTICATION_FAILED"),
        KBA_AUTHENTICATED("KBA_AUTHENTICATED"),
        WEB_IDENTITY_AUTHENTICATED("WEB_IDENTITY_AUTHENTICATED"),
        WEB_IDENTITY_SPECIFIED("WEB_IDENTITY_SPECIFIED"),
        EMAIL_BOUNCED("EMAIL_BOUNCED"),
        WIDGET_ENABLED("WIDGET_ENABLED"),
        WIDGET_DISABLED("WIDGET_DISABLED"),
        DELEGATED("DELEGATED"),
        AUTO_DELEGATED("AUTO_DELEGATED"),
        REPLACED_SIGNER("REPLACED_SIGNER"),
        VAULTED("VAULTED"),
        DOCUMENTS_DELETED("DOCUMENTS_DELETED"),
        OTHER("OTHER");

        private String value;

        private FilterEventsEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

