/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.sign.model.megaSigns;

import com.adobe.sign.utils.StringUtil;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(description="")
public class SecurityOption {
    private String externalPassword = null;
    private String internalPassword = null;
    private KbaProtectionEnum kbaProtection = null;
    private String openPassword = null;
    private PasswordProtectionEnum passwordProtection = null;
    private Boolean protectOpen = null;
    private WebIdentityProtectionEnum webIdentityProtection = null;

    @ApiModelProperty(value="The secondary password that will be used to protect signing the document for external signers. Note that Adobe Sign will never show this password to anyone, so you will need to separately communicate it to any relevant parties. This password is applied only if password protection is specified for external signers or all signers")
    @JsonProperty(value="externalPassword")
    public String getExternalPassword() {
        return this.externalPassword;
    }

    public void setExternalPassword(String externalPassword) {
        this.externalPassword = externalPassword;
    }

    @ApiModelProperty(value="The secondary password that will be used to protect signing the document for internal signers. Note that Adobe Sign will never show this password to anyone, so you will need to separately communicate it to any relevant parties. This password is applied only if password protection is specified for internal signers or all signers")
    @JsonProperty(value="internalPassword")
    public String getInternalPassword() {
        return this.internalPassword;
    }

    public void setInternalPassword(String internalPassword) {
        this.internalPassword = internalPassword;
    }

    @ApiModelProperty(value="Signers need to pass Knowledge Based Authentication before they gain access to view and sign the document.")
    @JsonProperty(value="kbaProtection")
    public KbaProtectionEnum getKbaProtection() {
        return this.kbaProtection;
    }

    public void setKbaProtection(KbaProtectionEnum kbaProtection) {
        this.kbaProtection = kbaProtection;
    }

    @ApiModelProperty(value="The secondary password that will be used to secure the PDF document. Note that Adobe Sign will never show this password to anyone, so you will need to separately communicate it to any relevant parties. This password is used only if protectOpen field is set to true")
    @JsonProperty(value="openPassword")
    public String getOpenPassword() {
        return this.openPassword;
    }

    public void setOpenPassword(String openPassword) {
        this.openPassword = openPassword;
    }

    @ApiModelProperty(value="Specifies if signers are required to enter a password to have access to sign the document.")
    @JsonProperty(value="passwordProtection")
    public PasswordProtectionEnum getPasswordProtection() {
        return this.passwordProtection;
    }

    public void setPasswordProtection(PasswordProtectionEnum passwordProtection) {
        this.passwordProtection = passwordProtection;
    }

    @ApiModelProperty(value="If set to true, the document is always be encrypted with this password every time it is sent by email. Recipients need to provide the password to be able to view the PDF files")
    @JsonProperty(value="protectOpen")
    public Boolean getProtectOpen() {
        return this.protectOpen;
    }

    public void setProtectOpen(Boolean protectOpen) {
        this.protectOpen = protectOpen;
    }

    @ApiModelProperty(value="Specifies if signers are required to provide their web identity, before they gain access to view and sign the document.")
    @JsonProperty(value="webIdentityProtection")
    public WebIdentityProtectionEnum getWebIdentityProtection() {
        return this.webIdentityProtection;
    }

    public void setWebIdentityProtection(WebIdentityProtectionEnum webIdentityProtection) {
        this.webIdentityProtection = webIdentityProtection;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SecurityOption {\n");
        sb.append("    externalPassword: ").append(StringUtil.toIndentedString(this.externalPassword)).append("\n");
        sb.append("    internalPassword: ").append(StringUtil.toIndentedString(this.internalPassword)).append("\n");
        sb.append("    kbaProtection: ").append(StringUtil.toIndentedString((Object)this.kbaProtection)).append("\n");
        sb.append("    openPassword: ").append(StringUtil.toIndentedString(this.openPassword)).append("\n");
        sb.append("    passwordProtection: ").append(StringUtil.toIndentedString((Object)this.passwordProtection)).append("\n");
        sb.append("    protectOpen: ").append(StringUtil.toIndentedString(this.protectOpen)).append("\n");
        sb.append("    webIdentityProtection: ").append(StringUtil.toIndentedString((Object)this.webIdentityProtection)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public static enum WebIdentityProtectionEnum {
        NONE("NONE"),
        EXTERNAL_USERS("EXTERNAL_USERS"),
        INTERNAL_USERS("INTERNAL_USERS"),
        ALL_USERS("ALL_USERS");

        private String value;

        private WebIdentityProtectionEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum PasswordProtectionEnum {
        NONE("NONE"),
        EXTERNAL_USERS("EXTERNAL_USERS"),
        INTERNAL_USERS("INTERNAL_USERS"),
        ALL_USERS("ALL_USERS");

        private String value;

        private PasswordProtectionEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum KbaProtectionEnum {
        NONE("NONE"),
        EXTERNAL_USERS("EXTERNAL_USERS"),
        INTERNAL_USERS("INTERNAL_USERS"),
        ALL_USERS("ALL_USERS");

        private String value;

        private KbaProtectionEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

