/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.sign.model.agreements;

import com.adobe.sign.model.agreements.DisplayUserSetInfo;
import com.adobe.sign.utils.StringUtil;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import java.util.List;

@ApiModel(description="")
public class UserAgreement {
    private String agreementId = null;
    private Date displayDate = null;
    private List<DisplayUserSetInfo> displayUserSetInfos = null;
    private Boolean esign = null;
    private String latestVersionId = null;
    private String name = null;
    private StatusEnum status = null;

    @ApiModelProperty(required=true, value="The unique identifier of the agreement")
    @JsonProperty(value="agreementId")
    public String getAgreementId() {
        return this.agreementId;
    }

    public void setAgreementId(String agreementId) {
        this.agreementId = agreementId;
    }

    @ApiModelProperty(required=true, value="The display date for the agreement")
    @JsonProperty(value="displayDate")
    public Date getDisplayDate() {
        return this.displayDate;
    }

    public void setDisplayDate(Date displayDate) {
        this.displayDate = displayDate;
    }

    @ApiModelProperty(required=true, value="The most relevant current user set for the agreement. It is typically the next signer if the agreement is from the current user, or the sender if received from another user")
    @JsonProperty(value="displayUserSetInfos")
    public List<DisplayUserSetInfo> getDisplayUserSetInfos() {
        return this.displayUserSetInfos;
    }

    public void setDisplayUserSetInfos(List<DisplayUserSetInfo> displayUserSetInfos) {
        this.displayUserSetInfos = displayUserSetInfos;
    }

    @ApiModelProperty(required=true, value="True if this is an e-sign document")
    @JsonProperty(value="esign")
    public Boolean getEsign() {
        return this.esign;
    }

    public void setEsign(Boolean esign) {
        this.esign = esign;
    }

    @ApiModelProperty(required=true, value="A version ID which uniquely identifies the current version of the agreement")
    @JsonProperty(value="latestVersionId")
    public String getLatestVersionId() {
        return this.latestVersionId;
    }

    public void setLatestVersionId(String latestVersionId) {
        this.latestVersionId = latestVersionId;
    }

    @ApiModelProperty(required=true, value="Name of the Agreement")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ApiModelProperty(required=true, value="The current status of the document from the perspective of the user")
    @JsonProperty(value="status")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserAgreement {\n");
        sb.append("    agreementId: ").append(StringUtil.toIndentedString(this.agreementId)).append("\n");
        sb.append("    displayDate: ").append(StringUtil.toIndentedString(this.displayDate)).append("\n");
        sb.append("    displayUserSetInfos: ").append(StringUtil.toIndentedString(this.displayUserSetInfos)).append("\n");
        sb.append("    esign: ").append(StringUtil.toIndentedString(this.esign)).append("\n");
        sb.append("    latestVersionId: ").append(StringUtil.toIndentedString(this.latestVersionId)).append("\n");
        sb.append("    name: ").append(StringUtil.toIndentedString(this.name)).append("\n");
        sb.append("    status: ").append(StringUtil.toIndentedString((Object)this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public static enum StatusEnum {
        WAITING_FOR_MY_SIGNATURE("WAITING_FOR_MY_SIGNATURE"),
        WAITING_FOR_MY_APPROVAL("WAITING_FOR_MY_APPROVAL"),
        WAITING_FOR_MY_DELEGATION("WAITING_FOR_MY_DELEGATION"),
        OUT_FOR_SIGNATURE("OUT_FOR_SIGNATURE"),
        OUT_FOR_APPROVAL("OUT_FOR_APPROVAL"),
        SIGNED("SIGNED"),
        APPROVED("APPROVED"),
        RECALLED("RECALLED"),
        WAITING_FOR_FAXIN("WAITING_FOR_FAXIN"),
        ARCHIVED("ARCHIVED"),
        FORM("FORM"),
        EXPIRED("EXPIRED"),
        WIDGET("WIDGET"),
        WAITING_FOR_AUTHORING("WAITING_FOR_AUTHORING");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

