/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.sign.model.agreements;

import com.adobe.sign.model.agreements.RecipientInfo;
import com.adobe.sign.model.agreements.RecipientSecurityOption;
import com.adobe.sign.utils.StringUtil;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;

@ApiModel(description="")
public class RecipientSetInfo {
    private String privateMessage = null;
    private List<RecipientInfo> recipientSetMemberInfos = null;
    private String recipientSetName = null;
    private RecipientSetRoleEnum recipientSetRole = null;
    private List<RecipientSecurityOption> securityOptions = null;
    private Integer signingOrder = null;

    @ApiModelProperty(value="Private message for the recipients in the set")
    @JsonProperty(value="privateMessage")
    public String getPrivateMessage() {
        return this.privateMessage;
    }

    public void setPrivateMessage(String privateMessage) {
        this.privateMessage = privateMessage;
    }

    @ApiModelProperty(required=true, value="Information about the members of the recipient set")
    @JsonProperty(value="recipientSetMemberInfos")
    public List<RecipientInfo> getRecipientSetMemberInfos() {
        return this.recipientSetMemberInfos;
    }

    public void setRecipientSetMemberInfos(List<RecipientInfo> recipientSetMemberInfos) {
        this.recipientSetMemberInfos = recipientSetMemberInfos;
    }

    @ApiModelProperty(value="Specify the name of Recipient set. Maximum no of characters in recipient set name is restricted to 255.")
    @JsonProperty(value="recipientSetName")
    public String getRecipientSetName() {
        return this.recipientSetName;
    }

    public void setRecipientSetName(String recipientSetName) {
        this.recipientSetName = recipientSetName;
    }

    @ApiModelProperty(required=true, value="Specify the role of recipient set")
    @JsonProperty(value="recipientSetRole")
    public RecipientSetRoleEnum getRecipientSetRole() {
        return this.recipientSetRole;
    }

    public void setRecipientSetRole(RecipientSetRoleEnum recipientSetRole) {
        this.recipientSetRole = recipientSetRole;
    }

    @ApiModelProperty(value="Security options that apply to the recipient")
    @JsonProperty(value="securityOptions")
    public List<RecipientSecurityOption> getSecurityOptions() {
        return this.securityOptions;
    }

    public void setSecurityOptions(List<RecipientSecurityOption> securityOptions) {
        this.securityOptions = securityOptions;
    }

    @ApiModelProperty(value="Index indicating sequential signing group (specify for hybrid routing)")
    @JsonProperty(value="signingOrder")
    public Integer getSigningOrder() {
        return this.signingOrder;
    }

    public void setSigningOrder(Integer signingOrder) {
        this.signingOrder = signingOrder;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RecipientSetInfo {\n");
        sb.append("    privateMessage: ").append(StringUtil.toIndentedString(this.privateMessage)).append("\n");
        sb.append("    recipientSetMemberInfos: ").append(StringUtil.toIndentedString(this.recipientSetMemberInfos)).append("\n");
        sb.append("    recipientSetName: ").append(StringUtil.toIndentedString(this.recipientSetName)).append("\n");
        sb.append("    recipientSetRole: ").append(StringUtil.toIndentedString((Object)this.recipientSetRole)).append("\n");
        sb.append("    securityOptions: ").append(StringUtil.toIndentedString(this.securityOptions)).append("\n");
        sb.append("    signingOrder: ").append(StringUtil.toIndentedString(this.signingOrder)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public static enum RecipientSetRoleEnum {
        SIGNER("SIGNER"),
        APPROVER("APPROVER"),
        DELEGATE_TO_SIGNER("DELEGATE_TO_SIGNER"),
        DELEGATE_TO_APPROVER("DELEGATE_TO_APPROVER");

        private String value;

        private RecipientSetRoleEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

