/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.sign.model.agreements;

import com.adobe.sign.model.agreements.ExternalId;
import com.adobe.sign.model.agreements.FileInfo;
import com.adobe.sign.model.agreements.MergefieldInfo;
import com.adobe.sign.model.agreements.PostSignOptions;
import com.adobe.sign.model.agreements.RecipientSetInfo;
import com.adobe.sign.model.agreements.RequestFormField;
import com.adobe.sign.model.agreements.SecurityOption;
import com.adobe.sign.model.agreements.VaultingInfo;
import com.adobe.sign.utils.StringUtil;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;

@ApiModel(description="")
public class DocumentCreationInfo {
    private String callbackInfo = null;
    private List<String> ccs = null;
    private Integer daysUntilSigningDeadline = null;
    private ExternalId externalId = null;
    private List<FileInfo> fileInfos = null;
    private List<FileInfo> formFieldLayerTemplates = null;
    private List<RequestFormField> formFields = null;
    private String locale = null;
    private List<MergefieldInfo> mergeFieldInfo = null;
    private String message = null;
    private String name = null;
    private PostSignOptions postSignOptions = null;
    private List<RecipientSetInfo> recipientSetInfos = null;
    private ReminderFrequencyEnum reminderFrequency = null;
    private SecurityOption securityOptions = null;
    private SignatureFlowEnum signatureFlow = null;
    private SignatureTypeEnum signatureType = null;
    private VaultingInfo vaultingInfo = null;

    @ApiModelProperty(value="A publicly accessible url to which Adobe Sign will do an HTTP GET operation every time there is a new agreement event. HTTP authentication is supported using standard embedded syntax - i.e. http://username:password@your.server.com/path/to/file. Adobe Sign can also ping your system using HTTP PUT with the final signed PDF. Please contact support@echosign.com if you wish to use this option.")
    @JsonProperty(value="callbackInfo")
    public String getCallbackInfo() {
        return this.callbackInfo;
    }

    public void setCallbackInfo(String callbackInfo) {
        this.callbackInfo = callbackInfo;
    }

    @ApiModelProperty(value="A list of one or more email addresses that you want to copy on this transaction. The email addresses will each receive an email at the beginning of the transaction and also when the final document is signed. The email addresses will also receive a copy of the document, attached as a PDF file")
    @JsonProperty(value="ccs")
    public List<String> getCcs() {
        return this.ccs;
    }

    public void setCcs(List<String> ccs) {
        this.ccs = ccs;
    }

    @ApiModelProperty(value="The number of days that remain before the document expires. You cannot sign the document after it expires")
    @JsonProperty(value="daysUntilSigningDeadline")
    public Integer getDaysUntilSigningDeadline() {
        return this.daysUntilSigningDeadline;
    }

    public void setDaysUntilSigningDeadline(Integer daysUntilSigningDeadline) {
        this.daysUntilSigningDeadline = daysUntilSigningDeadline;
    }

    @ApiModelProperty(value="A unique identifier for your transaction from an external system. You can use the ExternalID to search for your transaction through API")
    @JsonProperty(value="externalId")
    public ExternalId getExternalId() {
        return this.externalId;
    }

    public void setExternalId(ExternalId externalId) {
        this.externalId = externalId;
    }

    @ApiModelProperty(required=true, value="A list of one or more files (or references to files) that will be sent out for signature. If more than one file is provided, they will be combined into one PDF before being sent out. Note: Only one of the four parameters in every FileInfo object must be specified")
    @JsonProperty(value="fileInfos")
    public List<FileInfo> getFileInfos() {
        return this.fileInfos;
    }

    public void setFileInfos(List<FileInfo> fileInfos) {
        this.fileInfos = fileInfos;
    }

    @ApiModelProperty(value="Specifies the form field layer template or source of form fields to apply on the files in this transaction. If specified, the FileInfo for this parameter must refer to a form field layer template via libraryDocumentId or libraryDocumentName, or if specified via transientDocumentId or documentURL, it must be of a supported file type. Note: Only one of the four parameters in every FileInfo object must be specified")
    @JsonProperty(value="formFieldLayerTemplates")
    public List<FileInfo> getFormFieldLayerTemplates() {
        return this.formFieldLayerTemplates;
    }

    public void setFormFieldLayerTemplates(List<FileInfo> formFieldLayerTemplates) {
        this.formFieldLayerTemplates = formFieldLayerTemplates;
    }

    @ApiModelProperty(value="Information of form fields of an agreement. PDF_SIGNATURE inputType field is currently not supported")
    @JsonProperty(value="formFields")
    public List<RequestFormField> getFormFields() {
        return this.formFields;
    }

    public void setFormFields(List<RequestFormField> formFields) {
        this.formFields = formFields;
    }

    @ApiModelProperty(value="The locale associated with this agreement - specifies the language for the signing page and emails, for example en_US or fr_FR. If none specified, defaults to the language configured for the agreement sender")
    @JsonProperty(value="locale")
    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    @ApiModelProperty(value="Optional default values for fields to merge into the document. The values will be presented to the signers for editable fields; for read-only fields the provided values will not be editable during the signing process. Merging data into fields is currently not supported when used with libraryDocumentId or libraryDocumentName. Only file and url are currently supported")
    @JsonProperty(value="mergeFieldInfo")
    public List<MergefieldInfo> getMergeFieldInfo() {
        return this.mergeFieldInfo;
    }

    public void setMergeFieldInfo(List<MergefieldInfo> mergeFieldInfo) {
        this.mergeFieldInfo = mergeFieldInfo;
    }

    @ApiModelProperty(value="An optional message to the recipients, describing what is being sent or why their signature is required")
    @JsonProperty(value="message")
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @ApiModelProperty(required=true, value="The name of the agreement that will be used to identify it, in emails and on the website")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ApiModelProperty(value="URL and associated properties for the success page the user will be taken to after completing the signing process")
    @JsonProperty(value="postSignOptions")
    public PostSignOptions getPostSignOptions() {
        return this.postSignOptions;
    }

    public void setPostSignOptions(PostSignOptions postSignOptions) {
        this.postSignOptions = postSignOptions;
    }

    @ApiModelProperty(required=true, value="A list of one or more recipient sets. A recipient set may have one or more recipients. If any member of the recipient set signs, the agreement is considered signed by the recipient set. For regular (non-MegaSign) documents, there is no limit on the number of electronic signatures in a single document. Written signatures are limited to four per document. This limit includes the sender if the signature of the sender is also required. Note: If signatureFlow is set to SENDER_SIGNS_ONLY, this parameter is optional")
    @JsonProperty(value="recipientSetInfos")
    public List<RecipientSetInfo> getRecipientSetInfos() {
        return this.recipientSetInfos;
    }

    public void setRecipientSetInfos(List<RecipientSetInfo> recipientSetInfos) {
        this.recipientSetInfos = recipientSetInfos;
    }

    @ApiModelProperty(value="Optional parameter that sets how often you want to send reminders to the recipients. The possible values are DAILY_UNTIL_SIGNED or WEEKLY_UNTIL_SIGNED")
    @JsonProperty(value="reminderFrequency")
    public ReminderFrequencyEnum getReminderFrequency() {
        return this.reminderFrequency;
    }

    public void setReminderFrequency(ReminderFrequencyEnum reminderFrequency) {
        this.reminderFrequency = reminderFrequency;
    }

    @ApiModelProperty(value="Sets optional secondary security parameters for your document")
    @JsonProperty(value="securityOptions")
    public SecurityOption getSecurityOptions() {
        return this.securityOptions;
    }

    public void setSecurityOptions(SecurityOption securityOptions) {
        this.securityOptions = securityOptions;
    }

    @ApiModelProperty(value="Selects the workflow you would like to use - whether the sender needs to sign only, before the recipient, after the recipient, or not at all. The possible values for this variable are SENDER_SIGNATURE_NOT_REQUIRED, SENDER_SIGNS_LAST, SENDER_SIGNS_FIRST, SEQUENTIAL, PARALLEL or SENDER_SIGNS_ONLY. Note: leave unspecified for hybrid routing")
    @JsonProperty(value="signatureFlow")
    public SignatureFlowEnum getSignatureFlow() {
        return this.signatureFlow;
    }

    public void setSignatureFlow(SignatureFlowEnum signatureFlow) {
        this.signatureFlow = signatureFlow;
    }

    @ApiModelProperty(required=true, value="Specifies the type of signature you would like to request - written or e-signature. The possible values are ESIGN or WRITTEN")
    @JsonProperty(value="signatureType")
    public SignatureTypeEnum getSignatureType() {
        return this.signatureType;
    }

    public void setSignatureType(SignatureTypeEnum signatureType) {
        this.signatureType = signatureType;
    }

    @ApiModelProperty(value="Sets the vaulting properties that allows Adobe Sign to securely store documents with a vault provider")
    @JsonProperty(value="vaultingInfo")
    public VaultingInfo getVaultingInfo() {
        return this.vaultingInfo;
    }

    public void setVaultingInfo(VaultingInfo vaultingInfo) {
        this.vaultingInfo = vaultingInfo;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DocumentCreationInfo {\n");
        sb.append("    callbackInfo: ").append(StringUtil.toIndentedString(this.callbackInfo)).append("\n");
        sb.append("    ccs: ").append(StringUtil.toIndentedString(this.ccs)).append("\n");
        sb.append("    daysUntilSigningDeadline: ").append(StringUtil.toIndentedString(this.daysUntilSigningDeadline)).append("\n");
        sb.append("    externalId: ").append(StringUtil.toIndentedString(this.externalId)).append("\n");
        sb.append("    fileInfos: ").append(StringUtil.toIndentedString(this.fileInfos)).append("\n");
        sb.append("    formFieldLayerTemplates: ").append(StringUtil.toIndentedString(this.formFieldLayerTemplates)).append("\n");
        sb.append("    formFields: ").append(StringUtil.toIndentedString(this.formFields)).append("\n");
        sb.append("    locale: ").append(StringUtil.toIndentedString(this.locale)).append("\n");
        sb.append("    mergeFieldInfo: ").append(StringUtil.toIndentedString(this.mergeFieldInfo)).append("\n");
        sb.append("    message: ").append(StringUtil.toIndentedString(this.message)).append("\n");
        sb.append("    name: ").append(StringUtil.toIndentedString(this.name)).append("\n");
        sb.append("    postSignOptions: ").append(StringUtil.toIndentedString(this.postSignOptions)).append("\n");
        sb.append("    recipientSetInfos: ").append(StringUtil.toIndentedString(this.recipientSetInfos)).append("\n");
        sb.append("    reminderFrequency: ").append(StringUtil.toIndentedString((Object)this.reminderFrequency)).append("\n");
        sb.append("    securityOptions: ").append(StringUtil.toIndentedString(this.securityOptions)).append("\n");
        sb.append("    signatureFlow: ").append(StringUtil.toIndentedString((Object)this.signatureFlow)).append("\n");
        sb.append("    signatureType: ").append(StringUtil.toIndentedString((Object)this.signatureType)).append("\n");
        sb.append("    vaultingInfo: ").append(StringUtil.toIndentedString(this.vaultingInfo)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public static enum SignatureTypeEnum {
        ESIGN("ESIGN"),
        WRITTEN("WRITTEN");

        private String value;

        private SignatureTypeEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum SignatureFlowEnum {
        SENDER_SIGNATURE_NOT_REQUIRED("SENDER_SIGNATURE_NOT_REQUIRED"),
        SENDER_SIGNS_LAST("SENDER_SIGNS_LAST"),
        SENDER_SIGNS_FIRST("SENDER_SIGNS_FIRST"),
        SEQUENTIAL("SEQUENTIAL"),
        PARALLEL("PARALLEL"),
        SENDER_SIGNS_ONLY("SENDER_SIGNS_ONLY");

        private String value;

        private SignatureFlowEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum ReminderFrequencyEnum {
        DAILY_UNTIL_SIGNED("DAILY_UNTIL_SIGNED"),
        WEEKLY_UNTIL_SIGNED("WEEKLY_UNTIL_SIGNED");

        private String value;

        private ReminderFrequencyEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

