/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.sign.model.agreements;

import com.adobe.sign.model.agreements.DocumentHistoryEvent;
import com.adobe.sign.model.agreements.NextParticipantSetInfo;
import com.adobe.sign.model.agreements.ParticipantSetInfo;
import com.adobe.sign.utils.StringUtil;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import java.util.List;

@ApiModel(description="")
public class AgreementInfo {
    private String agreementId = null;
    private List<DocumentHistoryEvent> events = null;
    private Date expiration = null;
    private String latestVersionId = null;
    private String locale = null;
    private String message = null;
    private Boolean modifiable = null;
    private String name = null;
    private List<NextParticipantSetInfo> nextParticipantSetInfos = null;
    private List<ParticipantSetInfo> participantSetInfos = null;
    private List<SecurityOptionsEnum> securityOptions = null;
    private StatusEnum status = null;
    private Boolean vaultingEnabled = null;

    @ApiModelProperty(required=true, value="A resource identifier that can be used to uniquely identify the agreement resource in other apis")
    @JsonProperty(value="agreementId")
    public String getAgreementId() {
        return this.agreementId;
    }

    public void setAgreementId(String agreementId) {
        this.agreementId = agreementId;
    }

    @ApiModelProperty(required=true, value="An ordered list of the events in the audit trail of this document")
    @JsonProperty(value="events")
    public List<DocumentHistoryEvent> getEvents() {
        return this.events;
    }

    public void setEvents(List<DocumentHistoryEvent> events) {
        this.events = events;
    }

    @ApiModelProperty(value="The date after which the document can no longer be signed, if an expiration date is configured. The value is nil if an expiration date is not set for the document")
    @JsonProperty(value="expiration")
    public Date getExpiration() {
        return this.expiration;
    }

    public void setExpiration(Date expiration) {
        this.expiration = expiration;
    }

    @ApiModelProperty(required=true, value="An ID which uniquely identifies the current version of the document")
    @JsonProperty(value="latestVersionId")
    public String getLatestVersionId() {
        return this.latestVersionId;
    }

    public void setLatestVersionId(String latestVersionId) {
        this.latestVersionId = latestVersionId;
    }

    @ApiModelProperty(required=true, value="The locale associated with this agreement - for example, en_US or fr_FR")
    @JsonProperty(value="locale")
    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    @ApiModelProperty(value="The message associated with the document that the sender has provided")
    @JsonProperty(value="message")
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @ApiModelProperty(required=true, value="Information about whether the agreement can be modified")
    @JsonProperty(value="modifiable")
    public Boolean getModifiable() {
        return this.modifiable;
    }

    public void setModifiable(Boolean modifiable) {
        this.modifiable = modifiable;
    }

    @ApiModelProperty(required=true, value="The name of the document, specified by the sender")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ApiModelProperty(required=true, value="Information about who needs to act next for this document - for example, if the agreement is in status OUT_FOR_SIGNATURE or OUT_FOR_APPROVAL, this will be the next signer or approver. If the AgreementStatus is a terminal state, this array is empty")
    @JsonProperty(value="nextParticipantSetInfos")
    public List<NextParticipantSetInfo> getNextParticipantSetInfos() {
        return this.nextParticipantSetInfos;
    }

    public void setNextParticipantSetInfos(List<NextParticipantSetInfo> nextParticipantSetInfos) {
        this.nextParticipantSetInfos = nextParticipantSetInfos;
    }

    @ApiModelProperty(required=true, value="Information about all the participant sets of this document")
    @JsonProperty(value="participantSetInfos")
    public List<ParticipantSetInfo> getParticipantSetInfos() {
        return this.participantSetInfos;
    }

    public void setParticipantSetInfos(List<ParticipantSetInfo> participantSetInfos) {
        this.participantSetInfos = participantSetInfos;
    }

    @ApiModelProperty(value="Security information about the document that specifies whether or not a password is required to view and sign the document")
    @JsonProperty(value="securityOptions")
    public List<SecurityOptionsEnum> getSecurityOptions() {
        return this.securityOptions;
    }

    public void setSecurityOptions(List<SecurityOptionsEnum> securityOptions) {
        this.securityOptions = securityOptions;
    }

    @ApiModelProperty(required=true, value="The current status of the document")
    @JsonProperty(value="status")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    @ApiModelProperty(required=true, value="Whether vaulting was enabled for the agreement")
    @JsonProperty(value="vaultingEnabled")
    public Boolean getVaultingEnabled() {
        return this.vaultingEnabled;
    }

    public void setVaultingEnabled(Boolean vaultingEnabled) {
        this.vaultingEnabled = vaultingEnabled;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AgreementInfo {\n");
        sb.append("    agreementId: ").append(StringUtil.toIndentedString(this.agreementId)).append("\n");
        sb.append("    events: ").append(StringUtil.toIndentedString(this.events)).append("\n");
        sb.append("    expiration: ").append(StringUtil.toIndentedString(this.expiration)).append("\n");
        sb.append("    latestVersionId: ").append(StringUtil.toIndentedString(this.latestVersionId)).append("\n");
        sb.append("    locale: ").append(StringUtil.toIndentedString(this.locale)).append("\n");
        sb.append("    message: ").append(StringUtil.toIndentedString(this.message)).append("\n");
        sb.append("    modifiable: ").append(StringUtil.toIndentedString(this.modifiable)).append("\n");
        sb.append("    name: ").append(StringUtil.toIndentedString(this.name)).append("\n");
        sb.append("    nextParticipantSetInfos: ").append(StringUtil.toIndentedString(this.nextParticipantSetInfos)).append("\n");
        sb.append("    participantSetInfos: ").append(StringUtil.toIndentedString(this.participantSetInfos)).append("\n");
        sb.append("    securityOptions: ").append(StringUtil.toIndentedString(this.securityOptions)).append("\n");
        sb.append("    status: ").append(StringUtil.toIndentedString((Object)this.status)).append("\n");
        sb.append("    vaultingEnabled: ").append(StringUtil.toIndentedString(this.vaultingEnabled)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public static enum StatusEnum {
        OUT_FOR_SIGNATURE("OUT_FOR_SIGNATURE"),
        WAITING_FOR_REVIEW("WAITING_FOR_REVIEW"),
        SIGNED("SIGNED"),
        APPROVED("APPROVED"),
        ABORTED("ABORTED"),
        DOCUMENT_LIBRARY("DOCUMENT_LIBRARY"),
        WIDGET("WIDGET"),
        EXPIRED("EXPIRED"),
        ARCHIVED("ARCHIVED"),
        PREFILL("PREFILL"),
        AUTHORING("AUTHORING"),
        WAITING_FOR_FAXIN("WAITING_FOR_FAXIN"),
        WAITING_FOR_VERIFICATION("WAITING_FOR_VERIFICATION"),
        WIDGET_WAITING_FOR_VERIFICATION("WIDGET_WAITING_FOR_VERIFICATION"),
        WAITING_FOR_PAYMENT("WAITING_FOR_PAYMENT"),
        OUT_FOR_APPROVAL("OUT_FOR_APPROVAL"),
        OTHER("OTHER");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum SecurityOptionsEnum {
        OPEN_PROTECTED("OPEN_PROTECTED"),
        OTHER("OTHER");

        private String value;

        private SecurityOptionsEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

