/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.sign.api;

import com.adobe.sign.model.transientDocuments.TransientDocumentResponse;
import com.adobe.sign.utils.ApiClient;
import com.adobe.sign.utils.ApiException;
import com.adobe.sign.utils.Context;
import com.adobe.sign.utils.Pair;
import com.adobe.sign.utils.TypeRef;
import com.adobe.sign.utils.validator.ApiValidatorHelper;
import com.adobe.sign.utils.validator.TransientDocumentsApiValidator;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import javax.ws.rs.core.MultivaluedMap;

public class TransientDocumentsApi {
    private ApiClient apiClient = Context.getDefaultApiClient();
    private final String CONTENT_TYPE = "Content-Type";
    private final String ACCEPT = "Accept";
    private final String ACCESS_TOKEN = "Access-Token";
    private final String X_API_USER = "x-api-user";

    public TransientDocumentResponse createTransientDocument(MultivaluedMap headers, String fileName, File file, String mimeType) throws ApiException {
        ApiValidatorHelper.validateHeaderParams(headers);
        TransientDocumentsApiValidator.createTransientDocumentValidator(fileName, mimeType, file);
        String path = "/transientDocuments".replaceAll("\\{format\\}", "json");
        Object postBody = null;
        byte[] postBinaryBody = null;
        HashMap<String, String> headerParams = new HashMap<String, String>();
        ArrayList<String> acceptsList = new ArrayList<String>();
        ArrayList<String> contentTypesList = new ArrayList<String>();
        acceptsList.add("application/json");
        contentTypesList.add("multipart/form-data");
        Set keys = headers.keySet();
        for (String key : keys) {
            String value = this.apiClient.parameterToString(headers.get((Object)key));
            if (key.equalsIgnoreCase("Content-Type")) {
                contentTypesList.add(value);
                continue;
            }
            if (key.equalsIgnoreCase("Accept")) {
                acceptsList.add(value);
                continue;
            }
            if (key.equalsIgnoreCase("Access-Token")) {
                headerParams.put("Access-Token", value);
                continue;
            }
            if (!key.equalsIgnoreCase("x-api-user")) continue;
            headerParams.put("x-api-user", value);
        }
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        if (fileName != null) {
            formParams.put("File-Name", fileName);
        }
        if (mimeType != null) {
            formParams.put("Mime-Type", mimeType);
        }
        if (file != null) {
            formParams.put("File", file);
        }
        String[] accepts = new String[acceptsList.size()];
        accepts = acceptsList.toArray(accepts);
        String[] contentTypes = new String[contentTypesList.size()];
        contentTypes = contentTypesList.toArray(contentTypes);
        String acceptHeader = this.apiClient.selectHeaderAccept(accepts);
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        TypeRef<TransientDocumentResponse> returnType = new TypeRef<TransientDocumentResponse>(){};
        return (TransientDocumentResponse)this.apiClient.invokeAPI(path, "POST", queryParams, postBody, postBinaryBody, headerParams, formParams, acceptHeader, contentType, returnType, true);
    }
}

