/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.sign.api;

import com.adobe.sign.model.agreements.AgreementCreationInfo;
import com.adobe.sign.model.agreements.AgreementCreationResponse;
import com.adobe.sign.model.agreements.AgreementDocuments;
import com.adobe.sign.model.agreements.AgreementInfo;
import com.adobe.sign.model.agreements.AgreementStatusUpdateInfo;
import com.adobe.sign.model.agreements.AgreementStatusUpdateResponse;
import com.adobe.sign.model.agreements.AlternateParticipantInfo;
import com.adobe.sign.model.agreements.AlternateParticipantResponse;
import com.adobe.sign.model.agreements.CombinedDocumentPagesInfo;
import com.adobe.sign.model.agreements.DocumentImageUrl;
import com.adobe.sign.model.agreements.DocumentImageUrls;
import com.adobe.sign.model.agreements.DocumentUrl;
import com.adobe.sign.model.agreements.SigningUrlResponse;
import com.adobe.sign.model.agreements.UserAgreements;
import com.adobe.sign.utils.ApiClient;
import com.adobe.sign.utils.ApiException;
import com.adobe.sign.utils.Context;
import com.adobe.sign.utils.Pair;
import com.adobe.sign.utils.TypeRef;
import com.adobe.sign.utils.validator.AgreementsApiValidator;
import com.adobe.sign.utils.validator.ApiValidatorHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import javax.ws.rs.core.MultivaluedMap;

public class AgreementsApi {
    private ApiClient apiClient = Context.getDefaultApiClient();
    private final String CONTENT_TYPE = "Content-Type";
    private final String ACCEPT = "Accept";
    private final String ACCESS_TOKEN = "Access-Token";
    private final String X_API_USER = "x-api-user";

    public UserAgreements getAgreements(MultivaluedMap headers, String query, String externalId, String externalGroup, String externalNamespace) throws ApiException {
        ApiValidatorHelper.validateHeaderParams(headers);
        AgreementsApiValidator.getAgreementsValidator(query, externalId, externalGroup, externalNamespace);
        String path = "/agreements".replaceAll("\\{format\\}", "json");
        Object postBody = null;
        byte[] postBinaryBody = null;
        HashMap<String, String> headerParams = new HashMap<String, String>();
        ArrayList<String> acceptsList = new ArrayList<String>();
        ArrayList<String> contentTypesList = new ArrayList<String>();
        acceptsList.add("application/json");
        Set keys = headers.keySet();
        for (String key : keys) {
            String value = this.apiClient.parameterToString(headers.get((Object)key));
            if (key.equalsIgnoreCase("Content-Type")) {
                contentTypesList.add(value);
                continue;
            }
            if (key.equalsIgnoreCase("Accept")) {
                acceptsList.add(value);
                continue;
            }
            if (key.equalsIgnoreCase("Access-Token")) {
                headerParams.put("Access-Token", value);
                continue;
            }
            if (!key.equalsIgnoreCase("x-api-user")) continue;
            headerParams.put("x-api-user", value);
        }
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        queryParams.addAll(this.apiClient.parameterToPairs("", "query", query));
        queryParams.addAll(this.apiClient.parameterToPairs("", "externalId", externalId));
        queryParams.addAll(this.apiClient.parameterToPairs("", "externalGroup", externalGroup));
        queryParams.addAll(this.apiClient.parameterToPairs("", "externalNamespace", externalNamespace));
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[acceptsList.size()];
        accepts = acceptsList.toArray(accepts);
        String[] contentTypes = new String[contentTypesList.size()];
        contentTypes = contentTypesList.toArray(contentTypes);
        String acceptHeader = this.apiClient.selectHeaderAccept(accepts);
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        TypeRef<UserAgreements> returnType = new TypeRef<UserAgreements>(){};
        return (UserAgreements)this.apiClient.invokeAPI(path, "GET", queryParams, postBody, postBinaryBody, headerParams, formParams, acceptHeader, contentType, returnType, true);
    }

    public AgreementCreationResponse createAgreement(MultivaluedMap headers, AgreementCreationInfo agreementCreationInfo) throws ApiException {
        ApiValidatorHelper.validateHeaderParams(headers);
        AgreementsApiValidator.createAgreementValidator(agreementCreationInfo);
        String path = "/agreements".replaceAll("\\{format\\}", "json");
        AgreementCreationInfo postBody = agreementCreationInfo;
        byte[] postBinaryBody = null;
        HashMap<String, String> headerParams = new HashMap<String, String>();
        ArrayList<String> acceptsList = new ArrayList<String>();
        ArrayList<String> contentTypesList = new ArrayList<String>();
        acceptsList.add("application/json");
        Set keys = headers.keySet();
        for (String key : keys) {
            String value = this.apiClient.parameterToString(headers.get((Object)key));
            if (key.equalsIgnoreCase("Content-Type")) {
                contentTypesList.add(value);
                continue;
            }
            if (key.equalsIgnoreCase("Accept")) {
                acceptsList.add(value);
                continue;
            }
            if (key.equalsIgnoreCase("Access-Token")) {
                headerParams.put("Access-Token", value);
                continue;
            }
            if (!key.equalsIgnoreCase("x-api-user")) continue;
            headerParams.put("x-api-user", value);
        }
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[acceptsList.size()];
        accepts = acceptsList.toArray(accepts);
        String[] contentTypes = new String[contentTypesList.size()];
        contentTypes = contentTypesList.toArray(contentTypes);
        String acceptHeader = this.apiClient.selectHeaderAccept(accepts);
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        TypeRef<AgreementCreationResponse> returnType = new TypeRef<AgreementCreationResponse>(){};
        return (AgreementCreationResponse)this.apiClient.invokeAPI(path, "POST", queryParams, postBody, postBinaryBody, headerParams, formParams, acceptHeader, contentType, returnType, true);
    }

    public AgreementInfo getAgreementInfo(MultivaluedMap headers, String agreementId) throws ApiException {
        ApiValidatorHelper.validateHeaderParams(headers);
        AgreementsApiValidator.getAgreementInfoValidator(agreementId);
        String path = "/agreements/{agreementId}".replaceAll("\\{format\\}", "json").replaceAll("\\{agreementId\\}", this.apiClient.escapeString(agreementId.toString()));
        Object postBody = null;
        byte[] postBinaryBody = null;
        HashMap<String, String> headerParams = new HashMap<String, String>();
        ArrayList<String> acceptsList = new ArrayList<String>();
        ArrayList<String> contentTypesList = new ArrayList<String>();
        acceptsList.add("application/json");
        Set keys = headers.keySet();
        for (String key : keys) {
            String value = this.apiClient.parameterToString(headers.get((Object)key));
            if (key.equalsIgnoreCase("Content-Type")) {
                contentTypesList.add(value);
                continue;
            }
            if (key.equalsIgnoreCase("Accept")) {
                acceptsList.add(value);
                continue;
            }
            if (key.equalsIgnoreCase("Access-Token")) {
                headerParams.put("Access-Token", value);
                continue;
            }
            if (!key.equalsIgnoreCase("x-api-user")) continue;
            headerParams.put("x-api-user", value);
        }
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[acceptsList.size()];
        accepts = acceptsList.toArray(accepts);
        String[] contentTypes = new String[contentTypesList.size()];
        contentTypes = contentTypesList.toArray(contentTypes);
        String acceptHeader = this.apiClient.selectHeaderAccept(accepts);
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        TypeRef<AgreementInfo> returnType = new TypeRef<AgreementInfo>(){};
        return (AgreementInfo)this.apiClient.invokeAPI(path, "GET", queryParams, postBody, postBinaryBody, headerParams, formParams, acceptHeader, contentType, returnType, true);
    }

    public void deleteAgreement(MultivaluedMap headers, String agreementId) throws ApiException {
        ApiValidatorHelper.validateHeaderParams(headers);
        AgreementsApiValidator.deleteAgreementValidator(agreementId);
        String path = "/agreements/{agreementId}".replaceAll("\\{format\\}", "json").replaceAll("\\{agreementId\\}", this.apiClient.escapeString(agreementId.toString()));
        Object postBody = null;
        byte[] postBinaryBody = null;
        HashMap<String, String> headerParams = new HashMap<String, String>();
        ArrayList<String> acceptsList = new ArrayList<String>();
        ArrayList<String> contentTypesList = new ArrayList<String>();
        acceptsList.add("application/json");
        Set keys = headers.keySet();
        for (String key : keys) {
            String value = this.apiClient.parameterToString(headers.get((Object)key));
            if (key.equalsIgnoreCase("Content-Type")) {
                contentTypesList.add(value);
                continue;
            }
            if (key.equalsIgnoreCase("Accept")) {
                acceptsList.add(value);
                continue;
            }
            if (key.equalsIgnoreCase("Access-Token")) {
                headerParams.put("Access-Token", value);
                continue;
            }
            if (!key.equalsIgnoreCase("x-api-user")) continue;
            headerParams.put("x-api-user", value);
        }
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[acceptsList.size()];
        accepts = acceptsList.toArray(accepts);
        String[] contentTypes = new String[contentTypesList.size()];
        contentTypes = contentTypesList.toArray(contentTypes);
        String acceptHeader = this.apiClient.selectHeaderAccept(accepts);
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        this.apiClient.invokeAPI(path, "DELETE", queryParams, postBody, postBinaryBody, headerParams, formParams, acceptHeader, contentType, null, true);
    }

    public byte[] getAuditTrail(MultivaluedMap headers, String agreementId) throws ApiException {
        ApiValidatorHelper.validateHeaderParams(headers);
        AgreementsApiValidator.getAuditTrailValidator(agreementId);
        String path = "/agreements/{agreementId}/auditTrail".replaceAll("\\{format\\}", "json").replaceAll("\\{agreementId\\}", this.apiClient.escapeString(agreementId.toString()));
        Object postBody = null;
        byte[] postBinaryBody = null;
        HashMap<String, String> headerParams = new HashMap<String, String>();
        ArrayList<String> acceptsList = new ArrayList<String>();
        ArrayList<String> contentTypesList = new ArrayList<String>();
        acceptsList.add(" */* ");
        Set keys = headers.keySet();
        for (String key : keys) {
            String value = this.apiClient.parameterToString(headers.get((Object)key));
            if (key.equalsIgnoreCase("Content-Type")) {
                contentTypesList.add(value);
                continue;
            }
            if (key.equalsIgnoreCase("Accept")) {
                acceptsList.add(value);
                continue;
            }
            if (key.equalsIgnoreCase("Access-Token")) {
                headerParams.put("Access-Token", value);
                continue;
            }
            if (!key.equalsIgnoreCase("x-api-user")) continue;
            headerParams.put("x-api-user", value);
        }
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[acceptsList.size()];
        accepts = acceptsList.toArray(accepts);
        String[] contentTypes = new String[contentTypesList.size()];
        contentTypes = contentTypesList.toArray(contentTypes);
        String acceptHeader = this.apiClient.selectHeaderAccept(accepts);
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        return this.apiClient.invokeBinaryAPI(path, "GET", queryParams, postBody, postBinaryBody, headerParams, formParams, acceptHeader, contentType, true);
    }

    public byte[] getCombinedDocument(MultivaluedMap headers, String agreementId, String versionId, String participantEmail, Boolean attachSupportingDocuments, Boolean auditReport) throws ApiException {
        ApiValidatorHelper.validateHeaderParams(headers);
        AgreementsApiValidator.getCombinedDocumentValidator(agreementId, versionId, participantEmail, attachSupportingDocuments, auditReport);
        String path = "/agreements/{agreementId}/combinedDocument".replaceAll("\\{format\\}", "json").replaceAll("\\{agreementId\\}", this.apiClient.escapeString(agreementId.toString()));
        Object postBody = null;
        byte[] postBinaryBody = null;
        HashMap<String, String> headerParams = new HashMap<String, String>();
        ArrayList<String> acceptsList = new ArrayList<String>();
        ArrayList<String> contentTypesList = new ArrayList<String>();
        acceptsList.add(" */* ");
        Set keys = headers.keySet();
        for (String key : keys) {
            String value = this.apiClient.parameterToString(headers.get((Object)key));
            if (key.equalsIgnoreCase("Content-Type")) {
                contentTypesList.add(value);
                continue;
            }
            if (key.equalsIgnoreCase("Accept")) {
                acceptsList.add(value);
                continue;
            }
            if (key.equalsIgnoreCase("Access-Token")) {
                headerParams.put("Access-Token", value);
                continue;
            }
            if (!key.equalsIgnoreCase("x-api-user")) continue;
            headerParams.put("x-api-user", value);
        }
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        queryParams.addAll(this.apiClient.parameterToPairs("", "versionId", versionId));
        queryParams.addAll(this.apiClient.parameterToPairs("", "participantEmail", participantEmail));
        queryParams.addAll(this.apiClient.parameterToPairs("", "attachSupportingDocuments", attachSupportingDocuments));
        queryParams.addAll(this.apiClient.parameterToPairs("", "auditReport", auditReport));
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[acceptsList.size()];
        accepts = acceptsList.toArray(accepts);
        String[] contentTypes = new String[contentTypesList.size()];
        contentTypes = contentTypesList.toArray(contentTypes);
        String acceptHeader = this.apiClient.selectHeaderAccept(accepts);
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        return this.apiClient.invokeBinaryAPI(path, "GET", queryParams, postBody, postBinaryBody, headerParams, formParams, acceptHeader, contentType, true);
    }

    public CombinedDocumentPagesInfo getCombinedDocumentPagesInfo(MultivaluedMap headers, String agreementId, Boolean includeSupportingDocumentsPagesInfo) throws ApiException {
        ApiValidatorHelper.validateHeaderParams(headers);
        AgreementsApiValidator.getCombinedDocumentPagesInfoValidator(agreementId, includeSupportingDocumentsPagesInfo);
        String path = "/agreements/{agreementId}/combinedDocument/pagesInfo".replaceAll("\\{format\\}", "json").replaceAll("\\{agreementId\\}", this.apiClient.escapeString(agreementId.toString()));
        Object postBody = null;
        byte[] postBinaryBody = null;
        HashMap<String, String> headerParams = new HashMap<String, String>();
        ArrayList<String> acceptsList = new ArrayList<String>();
        ArrayList<String> contentTypesList = new ArrayList<String>();
        acceptsList.add("application/json");
        Set keys = headers.keySet();
        for (String key : keys) {
            String value = this.apiClient.parameterToString(headers.get((Object)key));
            if (key.equalsIgnoreCase("Content-Type")) {
                contentTypesList.add(value);
                continue;
            }
            if (key.equalsIgnoreCase("Accept")) {
                acceptsList.add(value);
                continue;
            }
            if (key.equalsIgnoreCase("Access-Token")) {
                headerParams.put("Access-Token", value);
                continue;
            }
            if (!key.equalsIgnoreCase("x-api-user")) continue;
            headerParams.put("x-api-user", value);
        }
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        queryParams.addAll(this.apiClient.parameterToPairs("", "includeSupportingDocumentsPagesInfo", includeSupportingDocumentsPagesInfo));
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[acceptsList.size()];
        accepts = acceptsList.toArray(accepts);
        String[] contentTypes = new String[contentTypesList.size()];
        contentTypes = contentTypesList.toArray(contentTypes);
        String acceptHeader = this.apiClient.selectHeaderAccept(accepts);
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        TypeRef<CombinedDocumentPagesInfo> returnType = new TypeRef<CombinedDocumentPagesInfo>(){};
        return (CombinedDocumentPagesInfo)this.apiClient.invokeAPI(path, "GET", queryParams, postBody, postBinaryBody, headerParams, formParams, acceptHeader, contentType, returnType, true);
    }

    public DocumentUrl getCombinedDocumentUrl(MultivaluedMap headers, String agreementId, String versionId, String participantEmail, Boolean attachSupportingDocuments, Boolean auditReport) throws ApiException {
        ApiValidatorHelper.validateHeaderParams(headers);
        AgreementsApiValidator.getCombinedDocumentUrlValidator(agreementId, versionId, participantEmail, attachSupportingDocuments, auditReport);
        String path = "/agreements/{agreementId}/combinedDocument/url".replaceAll("\\{format\\}", "json").replaceAll("\\{agreementId\\}", this.apiClient.escapeString(agreementId.toString()));
        Object postBody = null;
        byte[] postBinaryBody = null;
        HashMap<String, String> headerParams = new HashMap<String, String>();
        ArrayList<String> acceptsList = new ArrayList<String>();
        ArrayList<String> contentTypesList = new ArrayList<String>();
        acceptsList.add("application/json");
        Set keys = headers.keySet();
        for (String key : keys) {
            String value = this.apiClient.parameterToString(headers.get((Object)key));
            if (key.equalsIgnoreCase("Content-Type")) {
                contentTypesList.add(value);
                continue;
            }
            if (key.equalsIgnoreCase("Accept")) {
                acceptsList.add(value);
                continue;
            }
            if (key.equalsIgnoreCase("Access-Token")) {
                headerParams.put("Access-Token", value);
                continue;
            }
            if (!key.equalsIgnoreCase("x-api-user")) continue;
            headerParams.put("x-api-user", value);
        }
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        queryParams.addAll(this.apiClient.parameterToPairs("", "versionId", versionId));
        queryParams.addAll(this.apiClient.parameterToPairs("", "participantEmail", participantEmail));
        queryParams.addAll(this.apiClient.parameterToPairs("", "attachSupportingDocuments", attachSupportingDocuments));
        queryParams.addAll(this.apiClient.parameterToPairs("", "auditReport", auditReport));
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[acceptsList.size()];
        accepts = acceptsList.toArray(accepts);
        String[] contentTypes = new String[contentTypesList.size()];
        contentTypes = contentTypesList.toArray(contentTypes);
        String acceptHeader = this.apiClient.selectHeaderAccept(accepts);
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        TypeRef<DocumentUrl> returnType = new TypeRef<DocumentUrl>(){};
        return (DocumentUrl)this.apiClient.invokeAPI(path, "GET", queryParams, postBody, postBinaryBody, headerParams, formParams, acceptHeader, contentType, returnType, true);
    }

    public AgreementDocuments getAllDocuments(MultivaluedMap headers, String agreementId, String versionId, String participantEmail, String supportingDocumentContentFormat) throws ApiException {
        ApiValidatorHelper.validateHeaderParams(headers);
        AgreementsApiValidator.getAllDocumentsValidator(agreementId, versionId, participantEmail, supportingDocumentContentFormat);
        String path = "/agreements/{agreementId}/documents".replaceAll("\\{format\\}", "json").replaceAll("\\{agreementId\\}", this.apiClient.escapeString(agreementId.toString()));
        Object postBody = null;
        byte[] postBinaryBody = null;
        HashMap<String, String> headerParams = new HashMap<String, String>();
        ArrayList<String> acceptsList = new ArrayList<String>();
        ArrayList<String> contentTypesList = new ArrayList<String>();
        acceptsList.add("application/json");
        Set keys = headers.keySet();
        for (String key : keys) {
            String value = this.apiClient.parameterToString(headers.get((Object)key));
            if (key.equalsIgnoreCase("Content-Type")) {
                contentTypesList.add(value);
                continue;
            }
            if (key.equalsIgnoreCase("Accept")) {
                acceptsList.add(value);
                continue;
            }
            if (key.equalsIgnoreCase("Access-Token")) {
                headerParams.put("Access-Token", value);
                continue;
            }
            if (!key.equalsIgnoreCase("x-api-user")) continue;
            headerParams.put("x-api-user", value);
        }
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        queryParams.addAll(this.apiClient.parameterToPairs("", "versionId", versionId));
        queryParams.addAll(this.apiClient.parameterToPairs("", "participantEmail", participantEmail));
        queryParams.addAll(this.apiClient.parameterToPairs("", "supportingDocumentContentFormat", supportingDocumentContentFormat));
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[acceptsList.size()];
        accepts = acceptsList.toArray(accepts);
        String[] contentTypes = new String[contentTypesList.size()];
        contentTypes = contentTypesList.toArray(contentTypes);
        String acceptHeader = this.apiClient.selectHeaderAccept(accepts);
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        TypeRef<AgreementDocuments> returnType = new TypeRef<AgreementDocuments>(){};
        return (AgreementDocuments)this.apiClient.invokeAPI(path, "GET", queryParams, postBody, postBinaryBody, headerParams, formParams, acceptHeader, contentType, returnType, true);
    }

    public void deleteDocuments(MultivaluedMap headers, String agreementId) throws ApiException {
        ApiValidatorHelper.validateHeaderParams(headers);
        AgreementsApiValidator.deleteDocumentsValidator(agreementId);
        String path = "/agreements/{agreementId}/documents".replaceAll("\\{format\\}", "json").replaceAll("\\{agreementId\\}", this.apiClient.escapeString(agreementId.toString()));
        Object postBody = null;
        byte[] postBinaryBody = null;
        HashMap<String, String> headerParams = new HashMap<String, String>();
        ArrayList<String> acceptsList = new ArrayList<String>();
        ArrayList<String> contentTypesList = new ArrayList<String>();
        acceptsList.add("application/json");
        Set keys = headers.keySet();
        for (String key : keys) {
            String value = this.apiClient.parameterToString(headers.get((Object)key));
            if (key.equalsIgnoreCase("Content-Type")) {
                contentTypesList.add(value);
                continue;
            }
            if (key.equalsIgnoreCase("Accept")) {
                acceptsList.add(value);
                continue;
            }
            if (key.equalsIgnoreCase("Access-Token")) {
                headerParams.put("Access-Token", value);
                continue;
            }
            if (!key.equalsIgnoreCase("x-api-user")) continue;
            headerParams.put("x-api-user", value);
        }
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[acceptsList.size()];
        accepts = acceptsList.toArray(accepts);
        String[] contentTypes = new String[contentTypesList.size()];
        contentTypes = contentTypesList.toArray(contentTypes);
        String acceptHeader = this.apiClient.selectHeaderAccept(accepts);
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        this.apiClient.invokeAPI(path, "DELETE", queryParams, postBody, postBinaryBody, headerParams, formParams, acceptHeader, contentType, null, true);
    }

    public DocumentImageUrls getCombinedDocumentImageUrls(MultivaluedMap headers, String agreementId, String versionId, String participantEmail, String imageSizes, Boolean includeSupportingDocumentsImageUrls, Boolean showImageAvailabilityOnly) throws ApiException {
        ApiValidatorHelper.validateHeaderParams(headers);
        AgreementsApiValidator.getCombinedDocumentImageUrlsValidator(agreementId, versionId, participantEmail, imageSizes, includeSupportingDocumentsImageUrls, showImageAvailabilityOnly);
        String path = "/agreements/{agreementId}/documents/imageUrls".replaceAll("\\{format\\}", "json").replaceAll("\\{agreementId\\}", this.apiClient.escapeString(agreementId.toString()));
        Object postBody = null;
        byte[] postBinaryBody = null;
        HashMap<String, String> headerParams = new HashMap<String, String>();
        ArrayList<String> acceptsList = new ArrayList<String>();
        ArrayList<String> contentTypesList = new ArrayList<String>();
        acceptsList.add("application/json");
        Set keys = headers.keySet();
        for (String key : keys) {
            String value = this.apiClient.parameterToString(headers.get((Object)key));
            if (key.equalsIgnoreCase("Content-Type")) {
                contentTypesList.add(value);
                continue;
            }
            if (key.equalsIgnoreCase("Accept")) {
                acceptsList.add(value);
                continue;
            }
            if (key.equalsIgnoreCase("Access-Token")) {
                headerParams.put("Access-Token", value);
                continue;
            }
            if (!key.equalsIgnoreCase("x-api-user")) continue;
            headerParams.put("x-api-user", value);
        }
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        queryParams.addAll(this.apiClient.parameterToPairs("", "versionId", versionId));
        queryParams.addAll(this.apiClient.parameterToPairs("", "participantEmail", participantEmail));
        queryParams.addAll(this.apiClient.parameterToPairs("", "imageSizes", imageSizes));
        queryParams.addAll(this.apiClient.parameterToPairs("", "includeSupportingDocumentsImageUrls", includeSupportingDocumentsImageUrls));
        queryParams.addAll(this.apiClient.parameterToPairs("", "showImageAvailabilityOnly", showImageAvailabilityOnly));
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[acceptsList.size()];
        accepts = acceptsList.toArray(accepts);
        String[] contentTypes = new String[contentTypesList.size()];
        contentTypes = contentTypesList.toArray(contentTypes);
        String acceptHeader = this.apiClient.selectHeaderAccept(accepts);
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        TypeRef<DocumentImageUrls> returnType = new TypeRef<DocumentImageUrls>(){};
        return (DocumentImageUrls)this.apiClient.invokeAPI(path, "GET", queryParams, postBody, postBinaryBody, headerParams, formParams, acceptHeader, contentType, returnType, true);
    }

    public byte[] getDocument(MultivaluedMap headers, String agreementId, String documentId) throws ApiException {
        ApiValidatorHelper.validateHeaderParams(headers);
        AgreementsApiValidator.getDocumentValidator(agreementId, documentId);
        String path = "/agreements/{agreementId}/documents/{documentId}".replaceAll("\\{format\\}", "json").replaceAll("\\{agreementId\\}", this.apiClient.escapeString(agreementId.toString())).replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString()));
        Object postBody = null;
        byte[] postBinaryBody = null;
        HashMap<String, String> headerParams = new HashMap<String, String>();
        ArrayList<String> acceptsList = new ArrayList<String>();
        ArrayList<String> contentTypesList = new ArrayList<String>();
        acceptsList.add(" */* ");
        Set keys = headers.keySet();
        for (String key : keys) {
            String value = this.apiClient.parameterToString(headers.get((Object)key));
            if (key.equalsIgnoreCase("Content-Type")) {
                contentTypesList.add(value);
                continue;
            }
            if (key.equalsIgnoreCase("Accept")) {
                acceptsList.add(value);
                continue;
            }
            if (key.equalsIgnoreCase("Access-Token")) {
                headerParams.put("Access-Token", value);
                continue;
            }
            if (!key.equalsIgnoreCase("x-api-user")) continue;
            headerParams.put("x-api-user", value);
        }
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[acceptsList.size()];
        accepts = acceptsList.toArray(accepts);
        String[] contentTypes = new String[contentTypesList.size()];
        contentTypes = contentTypesList.toArray(contentTypes);
        String acceptHeader = this.apiClient.selectHeaderAccept(accepts);
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        return this.apiClient.invokeBinaryAPI(path, "GET", queryParams, postBody, postBinaryBody, headerParams, formParams, acceptHeader, contentType, true);
    }

    public DocumentImageUrl getDocumentImageUrls(MultivaluedMap headers, String agreementId, String documentId, String versionId, String participantEmail, String imageSizes, Boolean showImageAvailabilityOnly, Integer startPage, Integer endPage) throws ApiException {
        ApiValidatorHelper.validateHeaderParams(headers);
        AgreementsApiValidator.getDocumentImageUrlsValidator(agreementId, documentId, versionId, participantEmail, imageSizes, showImageAvailabilityOnly, startPage, endPage);
        String path = "/agreements/{agreementId}/documents/{documentId}/imageUrls".replaceAll("\\{format\\}", "json").replaceAll("\\{agreementId\\}", this.apiClient.escapeString(agreementId.toString())).replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString()));
        Object postBody = null;
        byte[] postBinaryBody = null;
        HashMap<String, String> headerParams = new HashMap<String, String>();
        ArrayList<String> acceptsList = new ArrayList<String>();
        ArrayList<String> contentTypesList = new ArrayList<String>();
        acceptsList.add("application/json");
        Set keys = headers.keySet();
        for (String key : keys) {
            String value = this.apiClient.parameterToString(headers.get((Object)key));
            if (key.equalsIgnoreCase("Content-Type")) {
                contentTypesList.add(value);
                continue;
            }
            if (key.equalsIgnoreCase("Accept")) {
                acceptsList.add(value);
                continue;
            }
            if (key.equalsIgnoreCase("Access-Token")) {
                headerParams.put("Access-Token", value);
                continue;
            }
            if (!key.equalsIgnoreCase("x-api-user")) continue;
            headerParams.put("x-api-user", value);
        }
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        queryParams.addAll(this.apiClient.parameterToPairs("", "versionId", versionId));
        queryParams.addAll(this.apiClient.parameterToPairs("", "participantEmail", participantEmail));
        queryParams.addAll(this.apiClient.parameterToPairs("", "imageSizes", imageSizes));
        queryParams.addAll(this.apiClient.parameterToPairs("", "showImageAvailabilityOnly", showImageAvailabilityOnly));
        queryParams.addAll(this.apiClient.parameterToPairs("", "startPage", startPage));
        queryParams.addAll(this.apiClient.parameterToPairs("", "endPage", endPage));
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[acceptsList.size()];
        accepts = acceptsList.toArray(accepts);
        String[] contentTypes = new String[contentTypesList.size()];
        contentTypes = contentTypesList.toArray(contentTypes);
        String acceptHeader = this.apiClient.selectHeaderAccept(accepts);
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        TypeRef<DocumentImageUrl> returnType = new TypeRef<DocumentImageUrl>(){};
        return (DocumentImageUrl)this.apiClient.invokeAPI(path, "GET", queryParams, postBody, postBinaryBody, headerParams, formParams, acceptHeader, contentType, returnType, true);
    }

    public DocumentUrl getDocumentUrl(MultivaluedMap headers, String agreementId, String documentId, String versionId, String participantEmail) throws ApiException {
        ApiValidatorHelper.validateHeaderParams(headers);
        AgreementsApiValidator.getDocumentUrlValidator(agreementId, documentId, versionId, participantEmail);
        String path = "/agreements/{agreementId}/documents/{documentId}/url".replaceAll("\\{format\\}", "json").replaceAll("\\{agreementId\\}", this.apiClient.escapeString(agreementId.toString())).replaceAll("\\{documentId\\}", this.apiClient.escapeString(documentId.toString()));
        Object postBody = null;
        byte[] postBinaryBody = null;
        HashMap<String, String> headerParams = new HashMap<String, String>();
        ArrayList<String> acceptsList = new ArrayList<String>();
        ArrayList<String> contentTypesList = new ArrayList<String>();
        acceptsList.add("application/json");
        Set keys = headers.keySet();
        for (String key : keys) {
            String value = this.apiClient.parameterToString(headers.get((Object)key));
            if (key.equalsIgnoreCase("Content-Type")) {
                contentTypesList.add(value);
                continue;
            }
            if (key.equalsIgnoreCase("Accept")) {
                acceptsList.add(value);
                continue;
            }
            if (key.equalsIgnoreCase("Access-Token")) {
                headerParams.put("Access-Token", value);
                continue;
            }
            if (!key.equalsIgnoreCase("x-api-user")) continue;
            headerParams.put("x-api-user", value);
        }
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        queryParams.addAll(this.apiClient.parameterToPairs("", "versionId", versionId));
        queryParams.addAll(this.apiClient.parameterToPairs("", "participantEmail", participantEmail));
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[acceptsList.size()];
        accepts = acceptsList.toArray(accepts);
        String[] contentTypes = new String[contentTypesList.size()];
        contentTypes = contentTypesList.toArray(contentTypes);
        String acceptHeader = this.apiClient.selectHeaderAccept(accepts);
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        TypeRef<DocumentUrl> returnType = new TypeRef<DocumentUrl>(){};
        return (DocumentUrl)this.apiClient.invokeAPI(path, "GET", queryParams, postBody, postBinaryBody, headerParams, formParams, acceptHeader, contentType, returnType, true);
    }

    public byte[] getFormData(MultivaluedMap headers, String agreementId) throws ApiException {
        ApiValidatorHelper.validateHeaderParams(headers);
        AgreementsApiValidator.getFormDataValidator(agreementId);
        String path = "/agreements/{agreementId}/formData".replaceAll("\\{format\\}", "json").replaceAll("\\{agreementId\\}", this.apiClient.escapeString(agreementId.toString()));
        Object postBody = null;
        byte[] postBinaryBody = null;
        HashMap<String, String> headerParams = new HashMap<String, String>();
        ArrayList<String> acceptsList = new ArrayList<String>();
        ArrayList<String> contentTypesList = new ArrayList<String>();
        acceptsList.add("text/csv");
        Set keys = headers.keySet();
        for (String key : keys) {
            String value = this.apiClient.parameterToString(headers.get((Object)key));
            if (key.equalsIgnoreCase("Content-Type")) {
                contentTypesList.add(value);
                continue;
            }
            if (key.equalsIgnoreCase("Accept")) {
                acceptsList.add(value);
                continue;
            }
            if (key.equalsIgnoreCase("Access-Token")) {
                headerParams.put("Access-Token", value);
                continue;
            }
            if (!key.equalsIgnoreCase("x-api-user")) continue;
            headerParams.put("x-api-user", value);
        }
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[acceptsList.size()];
        accepts = acceptsList.toArray(accepts);
        String[] contentTypes = new String[contentTypesList.size()];
        contentTypes = contentTypesList.toArray(contentTypes);
        String acceptHeader = this.apiClient.selectHeaderAccept(accepts);
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        return this.apiClient.invokeBinaryAPI(path, "GET", queryParams, postBody, postBinaryBody, headerParams, formParams, acceptHeader, contentType, true);
    }

    public AlternateParticipantResponse createAlternateParticipant(MultivaluedMap headers, String agreementId, String participantSetId, String participantId, AlternateParticipantInfo alternateParticipantInfo) throws ApiException {
        ApiValidatorHelper.validateHeaderParams(headers);
        AgreementsApiValidator.createAlternateParticipantValidator(agreementId, participantSetId, participantId, alternateParticipantInfo);
        String path = "/agreements/{agreementId}/participantSets/{participantSetId}/participants/{participantId}/alternateParticipants".replaceAll("\\{format\\}", "json").replaceAll("\\{agreementId\\}", this.apiClient.escapeString(agreementId.toString())).replaceAll("\\{participantSetId\\}", this.apiClient.escapeString(participantSetId.toString())).replaceAll("\\{participantId\\}", this.apiClient.escapeString(participantId.toString()));
        AlternateParticipantInfo postBody = alternateParticipantInfo;
        byte[] postBinaryBody = null;
        HashMap<String, String> headerParams = new HashMap<String, String>();
        ArrayList<String> acceptsList = new ArrayList<String>();
        ArrayList<String> contentTypesList = new ArrayList<String>();
        acceptsList.add("application/json");
        Set keys = headers.keySet();
        for (String key : keys) {
            String value = this.apiClient.parameterToString(headers.get((Object)key));
            if (key.equalsIgnoreCase("Content-Type")) {
                contentTypesList.add(value);
                continue;
            }
            if (key.equalsIgnoreCase("Accept")) {
                acceptsList.add(value);
                continue;
            }
            if (key.equalsIgnoreCase("Access-Token")) {
                headerParams.put("Access-Token", value);
                continue;
            }
            if (!key.equalsIgnoreCase("x-api-user")) continue;
            headerParams.put("x-api-user", value);
        }
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[acceptsList.size()];
        accepts = acceptsList.toArray(accepts);
        String[] contentTypes = new String[contentTypesList.size()];
        contentTypes = contentTypesList.toArray(contentTypes);
        String acceptHeader = this.apiClient.selectHeaderAccept(accepts);
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        TypeRef<AlternateParticipantResponse> returnType = new TypeRef<AlternateParticipantResponse>(){};
        return (AlternateParticipantResponse)this.apiClient.invokeAPI(path, "POST", queryParams, postBody, postBinaryBody, headerParams, formParams, acceptHeader, contentType, returnType, true);
    }

    public SigningUrlResponse getSigningUrl(MultivaluedMap headers, String agreementId) throws ApiException {
        ApiValidatorHelper.validateHeaderParams(headers);
        AgreementsApiValidator.getSigningUrlValidator(agreementId);
        String path = "/agreements/{agreementId}/signingUrls".replaceAll("\\{format\\}", "json").replaceAll("\\{agreementId\\}", this.apiClient.escapeString(agreementId.toString()));
        Object postBody = null;
        byte[] postBinaryBody = null;
        HashMap<String, String> headerParams = new HashMap<String, String>();
        ArrayList<String> acceptsList = new ArrayList<String>();
        ArrayList<String> contentTypesList = new ArrayList<String>();
        acceptsList.add("application/json");
        Set keys = headers.keySet();
        for (String key : keys) {
            String value = this.apiClient.parameterToString(headers.get((Object)key));
            if (key.equalsIgnoreCase("Content-Type")) {
                contentTypesList.add(value);
                continue;
            }
            if (key.equalsIgnoreCase("Accept")) {
                acceptsList.add(value);
                continue;
            }
            if (key.equalsIgnoreCase("Access-Token")) {
                headerParams.put("Access-Token", value);
                continue;
            }
            if (!key.equalsIgnoreCase("x-api-user")) continue;
            headerParams.put("x-api-user", value);
        }
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[acceptsList.size()];
        accepts = acceptsList.toArray(accepts);
        String[] contentTypes = new String[contentTypesList.size()];
        contentTypes = contentTypesList.toArray(contentTypes);
        String acceptHeader = this.apiClient.selectHeaderAccept(accepts);
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        TypeRef<SigningUrlResponse> returnType = new TypeRef<SigningUrlResponse>(){};
        return (SigningUrlResponse)this.apiClient.invokeAPI(path, "GET", queryParams, postBody, postBinaryBody, headerParams, formParams, acceptHeader, contentType, returnType, true);
    }

    public AgreementStatusUpdateResponse updateStatus(MultivaluedMap headers, String agreementId, AgreementStatusUpdateInfo agreementStatusUpdateInfo) throws ApiException {
        ApiValidatorHelper.validateHeaderParams(headers);
        AgreementsApiValidator.updateStatusValidator(agreementId, agreementStatusUpdateInfo);
        String path = "/agreements/{agreementId}/status".replaceAll("\\{format\\}", "json").replaceAll("\\{agreementId\\}", this.apiClient.escapeString(agreementId.toString()));
        AgreementStatusUpdateInfo postBody = agreementStatusUpdateInfo;
        byte[] postBinaryBody = null;
        HashMap<String, String> headerParams = new HashMap<String, String>();
        ArrayList<String> acceptsList = new ArrayList<String>();
        ArrayList<String> contentTypesList = new ArrayList<String>();
        acceptsList.add("application/json");
        Set keys = headers.keySet();
        for (String key : keys) {
            String value = this.apiClient.parameterToString(headers.get((Object)key));
            if (key.equalsIgnoreCase("Content-Type")) {
                contentTypesList.add(value);
                continue;
            }
            if (key.equalsIgnoreCase("Accept")) {
                acceptsList.add(value);
                continue;
            }
            if (key.equalsIgnoreCase("Access-Token")) {
                headerParams.put("Access-Token", value);
                continue;
            }
            if (!key.equalsIgnoreCase("x-api-user")) continue;
            headerParams.put("x-api-user", value);
        }
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[acceptsList.size()];
        accepts = acceptsList.toArray(accepts);
        String[] contentTypes = new String[contentTypesList.size()];
        contentTypes = contentTypesList.toArray(contentTypes);
        String acceptHeader = this.apiClient.selectHeaderAccept(accepts);
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        TypeRef<AgreementStatusUpdateResponse> returnType = new TypeRef<AgreementStatusUpdateResponse>(){};
        return (AgreementStatusUpdateResponse)this.apiClient.invokeAPI(path, "PUT", queryParams, postBody, postBinaryBody, headerParams, formParams, acceptHeader, contentType, returnType, true);
    }
}

