/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.target;

import androidx.annotation.Nullable;
import com.adobe.marketing.mobile.services.HttpConnecting;
import com.adobe.marketing.mobile.services.Log;
import com.adobe.marketing.mobile.target.TargetJson;
import com.adobe.marketing.mobile.target.TargetUtils;
import com.adobe.marketing.mobile.util.JSONUtils;
import com.adobe.marketing.mobile.util.StreamUtils;
import com.adobe.marketing.mobile.util.StringUtils;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class TargetResponseParser {
    private static final String CLASS_NAME = "TargetResponseParser";

    TargetResponseParser() {
    }

    @Nullable
    JSONObject parseResponseToJson(HttpConnecting connection) {
        try {
            if (connection != null) {
                String responseString = StreamUtils.readAsString((InputStream)connection.getInputStream());
                if (StringUtils.isNullOrEmpty((String)responseString)) {
                    return null;
                }
                JSONObject responseJson = new JSONObject(responseString);
                Log.debug((String)"Target", (String)CLASS_NAME, (String)"Target Response was received : %s", (Object[])new Object[]{responseString});
                return responseJson;
            }
        }
        catch (JSONException e) {
            Log.error((String)"Target", (String)CLASS_NAME, (String)"Unable to parse Target Response, Error (%s)", (Object[])new Object[]{e});
        }
        return null;
    }

    private JSONArray getMboxesFromKey(JSONObject serverResponseJson, String key) {
        JSONObject containerJson = serverResponseJson.optJSONObject(key);
        if (containerJson == null) {
            Log.debug((String)"Target", (String)CLASS_NAME, (String)"getMboxesFromKey - Unable to retrieve mboxes from key, json is null", (Object[])new Object[0]);
            return null;
        }
        JSONArray mboxJSONArray = containerJson.optJSONArray("mboxes");
        if (mboxJSONArray == null) {
            Log.debug((String)"Target", (String)CLASS_NAME, (String)"getMboxesFromKey - Unable to retrieve mboxes from key, mboxes array is null", (Object[])new Object[0]);
            return null;
        }
        return mboxJSONArray;
    }

    @Nullable
    Map<String, JSONObject> extractBatchedMBoxes(JSONObject serverResponseJson) {
        JSONArray batchedMboxes = this.getMboxesFromKey(serverResponseJson, "execute");
        if (batchedMboxes == null) {
            return null;
        }
        HashMap<String, JSONObject> mboxResponses = new HashMap<String, JSONObject>();
        for (int i = 0; i < batchedMboxes.length(); ++i) {
            String mboxName;
            JSONObject mboxJson = batchedMboxes.optJSONObject(i);
            if (mboxJson == null || StringUtils.isNullOrEmpty((String)(mboxName = mboxJson.optString("name", "")))) continue;
            mboxResponses.put(mboxName, mboxJson);
        }
        return mboxResponses;
    }

    @Nullable
    Map<String, JSONObject> extractPrefetchedMboxes(JSONObject serverResponseJson) {
        JSONArray prefetchedMboxes = this.getMboxesFromKey(serverResponseJson, "prefetch");
        if (prefetchedMboxes == null) {
            return null;
        }
        HashMap<String, JSONObject> mboxResponses = new HashMap<String, JSONObject>();
        for (int i = 0; i < prefetchedMboxes.length(); ++i) {
            String mboxName;
            JSONObject mboxJson = prefetchedMboxes.optJSONObject(i);
            if (mboxJson == null || StringUtils.isNullOrEmpty((String)(mboxName = mboxJson.optString("name", "")))) continue;
            Iterator keyIterator = mboxJson.keys();
            ArrayList<String> keyCache = new ArrayList<String>();
            while (keyIterator.hasNext()) {
                keyCache.add((String)keyIterator.next());
            }
            for (String key : keyCache) {
                if (TargetJson.CACHED_MBOX_ACCEPTED_KEYS.contains(key)) continue;
                mboxJson.remove(key);
            }
            mboxResponses.put(mboxName, mboxJson);
        }
        return mboxResponses;
    }

    @Nullable
    String getTntId(JSONObject serverResponseJson) {
        JSONObject idJson = serverResponseJson.optJSONObject("id");
        if (idJson == null) {
            return null;
        }
        return idJson.optString("tntId", "");
    }

    String getEdgeHost(JSONObject serverResponseJson) {
        return serverResponseJson.optString("edgeHost", "");
    }

    @Nullable
    Map<String, String> getAnalyticsForTargetPayload(JSONObject mboxJson, String sessionId) {
        Map<String, String> payload = this.getAnalyticsForTargetPayload(mboxJson);
        return this.preprocessAnalyticsForTargetPayload(payload, sessionId);
    }

    @Nullable
    Map<String, String> preprocessAnalyticsForTargetPayload(Map<String, String> payload, String sessionId) {
        if (TargetUtils.isNullOrEmpty(payload)) {
            return null;
        }
        HashMap<String, String> modifiedPayload = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : payload.entrySet()) {
            modifiedPayload.put("&&" + entry.getKey(), entry.getValue());
        }
        if (!StringUtils.isNullOrEmpty((String)sessionId)) {
            modifiedPayload.put("a.target.sessionId", sessionId);
        }
        return modifiedPayload;
    }

    @Nullable
    Map<String, String> getAnalyticsForTargetPayload(JSONObject json) {
        if (json == null) {
            return null;
        }
        JSONObject analyticsJson = json.optJSONObject("analytics");
        if (analyticsJson == null) {
            return null;
        }
        JSONObject payloadJson = analyticsJson.optJSONObject("payload");
        if (payloadJson == null) {
            return null;
        }
        return TargetUtils.toStringMap(payloadJson);
    }

    Map<String, Object> getResponseTokens(JSONObject mboxJson) {
        if (mboxJson == null) {
            return null;
        }
        JSONArray optionsArray = mboxJson.optJSONArray("options");
        if (JSONUtils.isNullOrEmpty((JSONArray)optionsArray)) {
            return null;
        }
        JSONObject option = optionsArray.optJSONObject(0);
        if (option == null) {
            return null;
        }
        JSONObject responseTokens = option.optJSONObject("responseTokens");
        if (responseTokens == null) {
            return null;
        }
        Map responseTokensMap = null;
        try {
            responseTokensMap = JSONUtils.toMap((JSONObject)responseTokens);
        }
        catch (JSONException e) {
            Log.debug((String)"Target", (String)CLASS_NAME, (String)"Exception (%s) is thrown when parsing response tokens to create an object Map.", (Object[])new Object[]{e});
        }
        return responseTokensMap;
    }

    Map<String, String> extractClickMetricAnalyticsPayload(JSONObject mboxJson) {
        JSONObject clickMetric = this.getClickMetric(mboxJson);
        return this.getAnalyticsForTargetPayload(clickMetric);
    }

    JSONObject getClickMetric(JSONObject mboxJson) {
        if (mboxJson == null) {
            return null;
        }
        JSONArray metricsArray = mboxJson.optJSONArray("metrics");
        if (JSONUtils.isNullOrEmpty((JSONArray)metricsArray)) {
            return null;
        }
        JSONObject clickMetric = null;
        for (int i = 0; i < metricsArray.length(); ++i) {
            JSONObject metric = metricsArray.optJSONObject(i);
            if (metric == null || !"click".equals(metric.optString("type", null)) || StringUtils.isNullOrEmpty((String)metric.optString("eventToken", null))) continue;
            clickMetric = metric;
            break;
        }
        return clickMetric;
    }

    String getErrorMessage(JSONObject responseJson) {
        if (responseJson == null) {
            return null;
        }
        return responseJson.optString("message", null);
    }

    String extractMboxContent(JSONObject mboxJson) {
        if (mboxJson == null) {
            Log.debug((String)"Target", (String)CLASS_NAME, (String)"extractMboxContent - unable to extract mbox contents, mbox json is null", (Object[])new Object[0]);
            return null;
        }
        JSONArray optionsArray = mboxJson.optJSONArray("options");
        if (optionsArray == null) {
            Log.debug((String)"Target", (String)CLASS_NAME, (String)"extractMboxContent - unable to extract mbox contents, options array is null", (Object[])new Object[0]);
            return null;
        }
        StringBuilder contentBuilder = new StringBuilder();
        for (int i = 0; i < optionsArray.length(); ++i) {
            Object content;
            JSONObject option = optionsArray.optJSONObject(i);
            if (option == null || StringUtils.isNullOrEmpty((String)option.optString("content", ""))) continue;
            String optionType = option.optString("type", "");
            String optionContent = "";
            if (optionType.equals("html")) {
                optionContent = option.optString("content", "");
            } else if (optionType.equals("json") && (content = option.opt("content")) != null) {
                optionContent = content.toString();
            }
            contentBuilder.append(optionContent);
        }
        return contentBuilder.toString();
    }
}

