/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.target;

import com.adobe.marketing.mobile.services.Log;
import com.adobe.marketing.mobile.target.TargetUtils;
import com.adobe.marketing.mobile.util.DataReader;
import com.adobe.marketing.mobile.util.DataReaderException;
import com.adobe.marketing.mobile.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class TargetProduct {
    private static final String CLASS_NAME = "TargetProduct";
    private final String id;
    private final String categoryId;

    public TargetProduct(String id, String categoryId) {
        this.id = id;
        this.categoryId = categoryId;
    }

    public String getId() {
        return this.id;
    }

    public String getCategoryId() {
        return this.categoryId;
    }

    Map<String, String> toEventData() {
        HashMap<String, String> productMap = new HashMap<String, String>();
        productMap.put("id", this.id);
        productMap.put("categoryId", this.categoryId);
        return productMap;
    }

    static TargetProduct fromEventData(Map<String, String> data) {
        if (TargetUtils.isNullOrEmpty(data)) {
            Log.debug((String)"Target", (String)CLASS_NAME, (String)"Cannot create TargetProduct object, provided data Map is empty or null.", (Object[])new Object[0]);
            return null;
        }
        try {
            String id = DataReader.getString(data, (String)"id");
            if (StringUtils.isNullOrEmpty((String)id)) {
                Log.debug((String)"Target", (String)CLASS_NAME, (String)"Cannot create TargetProduct object, provided data Map doesn't contain valid product ID.", (Object[])new Object[0]);
                return null;
            }
            String categoryId = DataReader.getString(data, (String)"categoryId");
            return new TargetProduct(id, categoryId);
        }
        catch (DataReaderException e) {
            Log.warning((String)"Target", (String)CLASS_NAME, (String)"Cannot create TargetProduct object, provided data contains invalid fields.", (Object[])new Object[0]);
            return null;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TargetProduct that = (TargetProduct)o;
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        return this.categoryId != null ? this.categoryId.equals(that.categoryId) : that.categoryId == null;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.categoryId);
    }
}

