/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.places;

import android.location.Location;
import androidx.annotation.NonNull;
import com.adobe.marketing.mobile.Event;
import com.adobe.marketing.mobile.places.PlacesAuthorizationStatus;
import com.adobe.marketing.mobile.places.PlacesPOI;
import com.adobe.marketing.mobile.places.PlacesQueryResponse;
import com.adobe.marketing.mobile.places.PlacesRegion;
import com.adobe.marketing.mobile.places.PlacesUtil;
import com.adobe.marketing.mobile.services.DataStoring;
import com.adobe.marketing.mobile.services.Log;
import com.adobe.marketing.mobile.services.NamedCollection;
import com.adobe.marketing.mobile.util.DataReader;
import com.adobe.marketing.mobile.util.StringUtils;
import com.adobe.marketing.mobile.util.TimeUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

class PlacesState {
    private static final String CLASS_NAME = "PlacesState";
    private static final String PLACES_DATA_STORE = "placesdatastore";
    LinkedHashMap<String, PlacesPOI> cachedPOIs = new LinkedHashMap();
    PlacesPOI currentPOI;
    PlacesPOI lastEnteredPOI;
    PlacesPOI lastExitedPOI;
    String authStatus;
    NamedCollection placesDataStore;
    long membershipValidUntil;
    long membershipTtl;

    PlacesState(@NonNull DataStoring datastore) {
        this.placesDataStore = datastore.getNamedCollection(PLACES_DATA_STORE);
        this.loadPersistedPOIs();
    }

    void processNetworkResponse(PlacesQueryResponse response) {
        this.currentPOI = null;
        if (response.containsUserPOIs != null && !response.containsUserPOIs.isEmpty()) {
            this.currentPOI = new PlacesPOI(response.containsUserPOIs.get(0));
            this.lastEnteredPOI = new PlacesPOI(response.containsUserPOIs.get(0));
        }
        this.cachePOIs(response);
        this.updateMembershipValidUntilTimestamp();
        this.persistPOIs();
    }

    PlacesRegion processRegionEvent(Event event) {
        Map eventData = event.getEventData();
        String regionId = DataReader.optString((Map)eventData, (String)"regionid", null);
        String regionType = DataReader.optString((Map)eventData, (String)"regioneventtype", (String)"none");
        if (StringUtils.isNullOrEmpty((String)regionId)) {
            Log.warning((String)"Places", (String)"Invalid regionId, Ignoring to process geofence event", (String)regionId, (Object[])new Object[0]);
            return null;
        }
        PlacesPOI matchedPOI = this.cachedPOIs.get(regionId);
        if (matchedPOI == null) {
            Log.warning((String)"Places", (String)"Unable to find POI details for regionId : %s, Ignoring to process geofence event", (String)regionId, (Object[])new Object[0]);
            return null;
        }
        if (regionType.equals("entry")) {
            matchedPOI.setUserIsWithin(true);
            this.lastEnteredPOI = matchedPOI;
            this.currentPOI = matchedPOI.comparePriority(this.currentPOI) ? matchedPOI : this.currentPOI;
            this.updateMembershipValidUntilTimestamp();
            this.persistPOIs();
            return new PlacesRegion(matchedPOI, "entry", event.getTimestamp());
        }
        if (regionType.equals("exit")) {
            if (matchedPOI.equals(this.currentPOI)) {
                this.currentPOI = null;
            }
            matchedPOI.setUserIsWithin(false);
            this.currentPOI = this.calculateCurrentPOI();
            this.lastExitedPOI = new PlacesPOI(matchedPOI);
            this.updateMembershipValidUntilTimestamp();
            this.persistPOIs();
            return new PlacesRegion(matchedPOI, "exit", event.getTimestamp());
        }
        Log.warning((String)"Places", (String)CLASS_NAME, (String)"Unknown region type : %s, Ignoring process geofence event", (Object[])new Object[]{regionType});
        return null;
    }

    Map<String, Object> getPlacesSharedState() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        if (!this.isMembershipDataValid()) {
            this.clearMembershipData();
        }
        if (this.cachedPOIs != null && !this.cachedPOIs.isEmpty()) {
            data.put("nearbypois", PlacesUtil.convertPOIListToMap(new ArrayList<PlacesPOI>(this.cachedPOIs.values())));
        }
        if (this.authStatus != null) {
            data.put("authstatus", this.authStatus);
        }
        if (this.currentPOI != null) {
            data.put("currentpoi", this.currentPOI.toMap());
        }
        if (this.lastEnteredPOI != null) {
            data.put("lastenteredpoi", this.lastEnteredPOI.toMap());
        }
        if (this.lastExitedPOI != null) {
            data.put("lastexitedpoi", this.lastExitedPOI.toMap());
        }
        data.put("validuntil", this.membershipValidUntil);
        return data;
    }

    List<PlacesPOI> getUserWithInPOIs() {
        ArrayList<PlacesPOI> userWithInPOIs = new ArrayList<PlacesPOI>();
        for (PlacesPOI eachPOI : this.cachedPOIs.values()) {
            if (!eachPOI.containsUser()) continue;
            userWithInPOIs.add(eachPOI);
        }
        return userWithInPOIs;
    }

    void saveLastKnownLocation(double latitude, double longitude) {
        if (this.placesDataStore == null) {
            Log.warning((String)"Places", (String)CLASS_NAME, (String)"Unable to persist authorization status, PlacesDatastore not available.", (Object[])new Object[0]);
            return;
        }
        if (!PlacesUtil.isValidLat(latitude) || !PlacesUtil.isValidLon(longitude)) {
            this.placesDataStore.remove("lastknownlatitude");
            this.placesDataStore.remove("lastknownlongitude");
            return;
        }
        this.placesDataStore.setDouble("lastknownlatitude", latitude);
        this.placesDataStore.setDouble("lastknownlongitude", longitude);
    }

    Location loadLastKnownLocation() {
        if (this.placesDataStore == null) {
            Log.warning((String)"Places", (String)CLASS_NAME, (String)"Unable to persist authorization status, PlacesDataStore not available.", (Object[])new Object[0]);
            return null;
        }
        double latitude = this.placesDataStore.getDouble("lastknownlatitude", 999.999);
        double longitude = this.placesDataStore.getDouble("lastknownlongitude", 999.999);
        if (!PlacesUtil.isValidLat(latitude) || !PlacesUtil.isValidLon(longitude)) {
            return null;
        }
        Location lastKnownLocation = new Location("com.adobe.lastKnownLocation");
        lastKnownLocation.setLatitude(latitude);
        lastKnownLocation.setLongitude(longitude);
        return lastKnownLocation;
    }

    void setAuthorizationStatus(String status) {
        this.authStatus = status;
        if (this.authStatus == null) {
            this.authStatus = PlacesAuthorizationStatus.DEFAULT_VALUE;
        }
        if (this.placesDataStore == null) {
            Log.warning((String)"Places", (String)CLASS_NAME, (String)"localStorage services from mobile core is not available, unable to persist authorization status", (Object[])new Object[0]);
            return;
        }
        this.placesDataStore.setString("authstatus", this.authStatus);
        Log.trace((String)"Places", (String)CLASS_NAME, (String)String.format("Authorization status persisted, %s", this.authStatus), (Object[])new Object[0]);
    }

    void setMembershiptTtl(long membershipTtl) {
        this.membershipTtl = membershipTtl;
    }

    void clearData() {
        this.cachedPOIs.clear();
        this.lastExitedPOI = null;
        this.lastEnteredPOI = null;
        this.currentPOI = null;
        this.membershipValidUntil = 0L;
        this.persistPOIs();
        this.saveLastKnownLocation(999.999, 999.999);
        this.setAuthorizationStatus(PlacesAuthorizationStatus.DEFAULT_VALUE);
    }

    private void cachePOIs(PlacesQueryResponse response) {
        this.cachedPOIs.clear();
        if (response.containsUserPOIs != null && !response.containsUserPOIs.isEmpty()) {
            for (PlacesPOI eachPOI : response.containsUserPOIs) {
                this.cachedPOIs.put(eachPOI.getIdentifier(), eachPOI);
            }
        }
        if (response.nearByPOIs != null && !response.nearByPOIs.isEmpty()) {
            for (PlacesPOI eachPOI : response.nearByPOIs) {
                this.cachedPOIs.put(eachPOI.getIdentifier(), eachPOI);
            }
        }
    }

    private void loadPersistedPOIs() {
        String lastExitedString;
        String lastEnteredString;
        String currentPOIString;
        if (this.placesDataStore == null) {
            Log.warning((String)"Places", (String)CLASS_NAME, (String)"Unable to load POI's from persistence, placesDataStore not available.", (Object[])new Object[0]);
            return;
        }
        this.cachedPOIs = new LinkedHashMap();
        String nearbyString = this.placesDataStore.getString("nearbypois", "");
        if (!StringUtils.isNullOrEmpty((String)nearbyString)) {
            try {
                JSONObject nearbyJSON = new JSONObject(nearbyString);
                Iterator keys = nearbyJSON.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    this.cachedPOIs.put(key, new PlacesPOI(nearbyJSON.getJSONObject(key)));
                }
            }
            catch (JSONException exception) {
                Log.warning((String)"Places", (String)"Unable to load cached POI from JSON String : %s", (String)nearbyString, (Object[])new Object[0]);
            }
        }
        if (!StringUtils.isNullOrEmpty((String)(currentPOIString = this.placesDataStore.getString("currentpoi", "")))) {
            try {
                this.currentPOI = new PlacesPOI(currentPOIString);
                Log.debug((String)"Places", (String)CLASS_NAME, (String)"CurrentPOI is loaded from persistence : %s", (Object[])new Object[]{this.currentPOI});
            }
            catch (JSONException exp) {
                Log.warning((String)"Places", (String)CLASS_NAME, (String)"Unable to load currentPOI from persistence : Exception - %s", (Object[])new Object[]{exp});
            }
        }
        if (!StringUtils.isNullOrEmpty((String)(lastEnteredString = this.placesDataStore.getString("lastenteredpoi", "")))) {
            try {
                this.lastEnteredPOI = new PlacesPOI(lastEnteredString);
                Log.debug((String)"Places", (String)CLASS_NAME, (String)"Last Entered POI is loaded from persistence : %s", (Object[])new Object[]{this.lastEnteredPOI});
            }
            catch (JSONException exp) {
                Log.warning((String)"Places", (String)CLASS_NAME, (String)"Unable to load last entered POI from persistence : Exception - %s ", (Object[])new Object[]{exp});
            }
        }
        if (!StringUtils.isNullOrEmpty((String)(lastExitedString = this.placesDataStore.getString("lastexitedpoi", "")))) {
            try {
                this.lastExitedPOI = new PlacesPOI(lastExitedString);
            }
            catch (JSONException exp) {
                Log.warning((String)"Places", (String)CLASS_NAME, (String)"Unable to load last exited POI from persistence : Exception - %s", (Object[])new Object[]{exp});
            }
        }
        this.authStatus = this.placesDataStore.getString("authstatus", PlacesAuthorizationStatus.DEFAULT_VALUE);
        this.membershipValidUntil = this.placesDataStore.getLong("places_membership_valid_until", 0L);
    }

    private void persistPOIs() {
        String jsonString;
        if (this.placesDataStore == null) {
            Log.error((String)"Places", (String)CLASS_NAME, (String)"Unable to persist POI's in persistence, placesDataStore not available.", (Object[])new Object[0]);
            return;
        }
        if (this.cachedPOIs != null && !this.cachedPOIs.isEmpty()) {
            try {
                JSONObject nearbyPOIsJSON = new JSONObject();
                for (String poiID : this.cachedPOIs.keySet()) {
                    nearbyPOIsJSON.put(poiID, (Object)new JSONObject(this.cachedPOIs.get(poiID).toMap()));
                }
                String jsonString2 = nearbyPOIsJSON.toString();
                this.placesDataStore.setString("nearbypois", jsonString2);
                Log.trace((String)"Places", (String)CLASS_NAME, (String)"nearbyPOIs persisted, %s", (Object[])new Object[]{jsonString2});
            }
            catch (Exception e) {
                Log.warning((String)"Places", (String)CLASS_NAME, (String)String.format("Unable to persist nearByPOIs in persistence, Exception: %s", e.getLocalizedMessage()), (Object[])new Object[0]);
            }
        } else {
            this.placesDataStore.remove("nearbypois");
        }
        if (this.currentPOI != null) {
            jsonString = this.currentPOI.toJsonString();
            this.placesDataStore.setString("currentpoi", jsonString);
            Log.trace((String)"Places", (String)CLASS_NAME, (String)"currentPOI persisted, %s", (Object[])new Object[]{jsonString});
        } else {
            this.placesDataStore.remove("currentpoi");
        }
        if (this.lastEnteredPOI != null) {
            jsonString = this.lastEnteredPOI.toJsonString();
            this.placesDataStore.setString("lastenteredpoi", jsonString);
            Log.trace((String)"Places", (String)CLASS_NAME, (String)"lastEnteredPOI persisted, %s", (Object[])new Object[]{jsonString});
        } else {
            this.placesDataStore.remove("lastenteredpoi");
        }
        if (this.lastExitedPOI != null) {
            jsonString = this.lastExitedPOI.toJsonString();
            this.placesDataStore.setString("lastexitedpoi", jsonString);
            Log.trace((String)"Places", (String)"lastExitedPOI persisted, %s", (String)jsonString, (Object[])new Object[0]);
        } else {
            this.placesDataStore.remove("lastexitedpoi");
        }
        this.placesDataStore.setLong("places_membership_valid_until", this.membershipValidUntil);
    }

    private PlacesPOI calculateCurrentPOI() {
        if (this.cachedPOIs == null) {
            return null;
        }
        PlacesPOI nextCurrentPOI = null;
        for (PlacesPOI poi : this.cachedPOIs.values()) {
            if (!poi.containsUser()) continue;
            nextCurrentPOI = poi.comparePriority(nextCurrentPOI) ? poi : nextCurrentPOI;
        }
        return nextCurrentPOI;
    }

    void clearMembershipData() {
        this.currentPOI = null;
        this.lastEnteredPOI = null;
        this.lastExitedPOI = null;
        this.membershipValidUntil = 0L;
        if (this.placesDataStore == null) {
            Log.warning((String)"Places", (String)CLASS_NAME, (String)"Unable to clear membership data, placesDataStore not available.", (Object[])new Object[0]);
            return;
        }
        this.placesDataStore.remove("currentpoi");
        this.placesDataStore.remove("lastenteredpoi");
        this.placesDataStore.remove("lastexitedpoi");
        this.placesDataStore.remove("places_membership_valid_until");
    }

    private boolean isMembershipDataValid() {
        return TimeUtils.getUnixTimeInSeconds() < this.membershipValidUntil;
    }

    private void updateMembershipValidUntilTimestamp() {
        this.membershipValidUntil = TimeUtils.getUnixTimeInSeconds() + this.membershipTtl;
    }
}

