/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.places;

import androidx.annotation.NonNull;
import com.adobe.marketing.mobile.places.PlacesPOI;
import java.util.HashMap;
import java.util.Map;

final class PlacesRegion
extends PlacesPOI {
    private final String placeEventType;
    private final long timestamp;
    private final PlacesPOI poi;
    static final String PLACE_EVENT_NONE = "none";
    static final String PLACE_EVENT_ENTRY = "entry";
    static final String PLACE_EVENT_EXIT = "exit";

    long getTimestamp() {
        return this.timestamp;
    }

    Map<String, Object> getRegionEventData() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("triggeringregion", this.poi.toMap());
        data.put("regioneventtype", this.getPlaceEventType());
        data.put("timestamp", this.getTimestamp());
        return data;
    }

    PlacesRegion(@NonNull PlacesPOI placesPOI, @NonNull String placeEventType, long timestamp) {
        super(placesPOI);
        this.poi = placesPOI;
        this.placeEventType = placeEventType;
        this.timestamp = timestamp;
    }

    PlacesPOI getPoi() {
        return this.poi;
    }

    String getPlaceEventType() {
        return this.placeEventType;
    }

    String getExperienceEventType() {
        switch (this.placeEventType) {
            case "entry": {
                return "location.entry";
            }
            case "exit": {
                return "location.exit";
            }
        }
        return "";
    }
}

