/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.places;

import com.adobe.marketing.mobile.places.PlacesConfiguration;
import com.adobe.marketing.mobile.places.PlacesPOI;
import com.adobe.marketing.mobile.places.PlacesQueryResponse;
import com.adobe.marketing.mobile.places.PlacesQueryResponseCallback;
import com.adobe.marketing.mobile.places.PlacesRequestError;
import com.adobe.marketing.mobile.places.PlacesUtil;
import com.adobe.marketing.mobile.services.HttpMethod;
import com.adobe.marketing.mobile.services.Log;
import com.adobe.marketing.mobile.services.NetworkRequest;
import com.adobe.marketing.mobile.services.Networking;
import com.adobe.marketing.mobile.util.DataReader;
import com.adobe.marketing.mobile.util.StreamUtils;
import com.adobe.marketing.mobile.util.StringUtils;
import com.adobe.marketing.mobile.util.URLBuilder;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class PlacesQueryService {
    private static final String CLASS_NAME = "PlacesQueryService";
    private static final int POI_DETAIL_MIN_ARRAY_LENGTH = 7;
    private static final int DEFAULT_POI_RADIUS = 100;
    private static final int DEFAULT_POI_WEIGHT = 1000;
    private static final int POI_INDEX_IDENTIFIER = 0;
    private static final int POI_INDEX_NAME = 1;
    private static final int POI_INDEX_LATITUDE = 2;
    private static final int POI_INDEX_LONGITUDE = 3;
    private static final int POI_INDEX_RADIUS = 4;
    private static final int POI_INDEX_LIBRARY = 5;
    private static final int POI_INDEX_WEIGHT = 6;
    private final Networking networking;

    PlacesQueryService(Networking networking) {
        this.networking = networking;
    }

    void getNearbyPlaces(Map<String, Object> eventData, PlacesConfiguration placesConfig, PlacesQueryResponseCallback responseCallback) {
        PlacesQueryResponse placesResponse = new PlacesQueryResponse();
        if (this.networking == null) {
            placesResponse.fetchFailed("Ignoring the get nearby places event, Networking services not available.", PlacesRequestError.INVALID_LATLONG_ERROR);
            responseCallback.call(placesResponse);
            return;
        }
        String queryURL = this.getQueryURL(eventData, placesConfig);
        if (queryURL == null) {
            placesResponse.fetchFailed("Ignoring the get nearby places event, unable to form query URL", PlacesRequestError.INVALID_LATLONG_ERROR);
            responseCallback.call(placesResponse);
            return;
        }
        queryURL = queryURL + placesConfig.getLibrariesQueryString();
        Log.debug((String)"Places", (String)CLASS_NAME, (String)"Getting nearby places:  %s", (Object[])new Object[]{queryURL});
        NetworkRequest request = new NetworkRequest(queryURL, HttpMethod.GET, null, null, 2, 2);
        this.networking.connectAsync(request, connection -> {
            if (connection == null) {
                placesResponse.fetchFailed("Unable to get nearby places, connection is null", PlacesRequestError.CONNECTIVITY_ERROR);
                responseCallback.call(placesResponse);
                return;
            }
            if (connection.getResponseCode() != 200) {
                connection.close();
                String message = String.format("Unable to get nearby places, connection failed with status %s, message %s", connection.getResponseCode(), connection.getResponseMessage());
                placesResponse.fetchFailed(message, PlacesRequestError.CONNECTIVITY_ERROR);
                responseCallback.call(placesResponse);
                return;
            }
            try {
                String serverResponse = StreamUtils.readAsString((InputStream)connection.getInputStream());
                if (StringUtils.isNullOrEmpty((String)serverResponse)) {
                    placesResponse.fetchFailed("Unable to get nearby places, server response is empty", PlacesRequestError.SERVER_RESPONSE_ERROR);
                    responseCallback.call(placesResponse);
                    return;
                }
                Log.debug((String)"Places", (String)CLASS_NAME, (String)"Received Places Query Response : %s", (Object[])new Object[]{serverResponse});
                JSONObject responseJson = new JSONObject(serverResponse);
                JSONObject placesJson = responseJson.getJSONObject("places");
                placesResponse.nearByPOIs = this.getNearbyPOIs(placesJson);
                placesResponse.containsUserPOIs = this.getContainsUserPOIs(placesJson);
                placesResponse.isSuccess = true;
                placesResponse.resultStatus = PlacesRequestError.OK;
                responseCallback.call(placesResponse);
            }
            catch (Exception exception) {
                String message = String.format("Unable to get nearby places, Failed with exception: %s", exception);
                placesResponse.fetchFailed(message, PlacesRequestError.SERVER_RESPONSE_ERROR);
                responseCallback.call(placesResponse);
            }
            finally {
                connection.close();
            }
        });
    }

    private String getQueryURL(Map<String, Object> eventData, PlacesConfiguration placesConfig) {
        double latitude = DataReader.optDouble(eventData, (String)"latitude", (double)999.999);
        double longitude = DataReader.optDouble(eventData, (String)"longitude", (double)999.999);
        int count = DataReader.optInt(eventData, (String)"count", (int)20);
        if (!PlacesUtil.isValidLat(latitude) || !PlacesUtil.isValidLon(longitude)) {
            Log.debug((String)"Places", (String)CLASS_NAME, (String)"Unable to get nearby places, invalid latitude/longitude", (Object[])new Object[0]);
            return null;
        }
        return new URLBuilder().enableSSL(true).setServer(placesConfig.getEndpoint()).addPath("placesedgequery").addQueryParameter("latitude", Double.toString(latitude)).addQueryParameter("longitude", Double.toString(longitude)).addQueryParameter("limit", Integer.toString(count)).build();
    }

    private List<PlacesPOI> getContainsUserPOIs(JSONObject placesJson) throws JSONException {
        ArrayList<PlacesPOI> containsUserPOIList = new ArrayList<PlacesPOI>();
        JSONArray containsUserPOIArray = placesJson.optJSONArray("userWithin");
        if (containsUserPOIArray == null || containsUserPOIArray.length() == 0) {
            return containsUserPOIList;
        }
        for (int i = 0; i < containsUserPOIArray.length(); ++i) {
            JSONObject poiJson = containsUserPOIArray.getJSONObject(i);
            PlacesPOI poi = this.createPlacesPOIFromJson(poiJson);
            if (poi == null) continue;
            poi.setUserIsWithin(true);
            containsUserPOIList.add(poi);
        }
        return containsUserPOIList;
    }

    private List<PlacesPOI> getNearbyPOIs(JSONObject placesJson) throws JSONException {
        ArrayList<PlacesPOI> nearByPOIList = new ArrayList<PlacesPOI>();
        JSONArray nearByPOIArray = placesJson.optJSONArray("pois");
        if (nearByPOIArray == null || nearByPOIArray.length() == 0) {
            return nearByPOIList;
        }
        for (int i = 0; i < nearByPOIArray.length(); ++i) {
            JSONObject poiJson = nearByPOIArray.getJSONObject(i);
            PlacesPOI poi = this.createPlacesPOIFromJson(poiJson);
            if (poi == null) continue;
            poi.setUserIsWithin(false);
            nearByPOIList.add(poi);
        }
        return nearByPOIList;
    }

    private PlacesPOI createPlacesPOIFromJson(JSONObject poiJson) {
        try {
            double longitude;
            double latitude;
            JSONArray poiDetails = poiJson.getJSONArray("p");
            if (poiDetails.length() != 7) {
                Log.debug((String)"Places", (String)CLASS_NAME, (String)"poiJson does not have the expected format", (Object[])new Object[0]);
                return null;
            }
            String identifier = poiDetails.optString(0, null);
            if (identifier == null) {
                Log.debug((String)"Places", (String)CLASS_NAME, (String)"Ignoring a POI, invalid identifier", (Object[])new Object[0]);
                return null;
            }
            String name = poiDetails.optString(1, "unnamed");
            try {
                latitude = Double.parseDouble(poiDetails.optString(2, String.valueOf(999.999)));
                longitude = Double.parseDouble(poiDetails.optString(3, String.valueOf(999.999)));
            }
            catch (Exception exp) {
                Log.warning((String)"Places", (String)CLASS_NAME, (String)"Ignoring POI with identifier %s, exception occurred while reading latitude/ longitude", (Object[])new Object[]{identifier});
                return null;
            }
            if (!PlacesUtil.isValidLat(latitude) || !PlacesUtil.isValidLon(longitude)) {
                Log.warning((String)"Places", (String)CLASS_NAME, (String)"Ignoring POI with identifier %s, invalid latitude/ longitude", (Object[])new Object[]{identifier});
                return null;
            }
            int radius = poiDetails.optInt(4, 100);
            String library = poiDetails.optString(5, "");
            int weight = poiDetails.optInt(6, 1000);
            PlacesPOI placesPOI = new PlacesPOI(identifier, name, latitude, longitude, radius, library, weight);
            JSONObject poiMetadata = poiJson.optJSONObject("x");
            if (poiMetadata != null) {
                Map<String, String> metadata = PlacesUtil.convertPOIMetadataToStringMap(poiMetadata);
                placesPOI.setMetadata(metadata);
            }
            return placesPOI;
        }
        catch (JSONException exception) {
            Log.warning((String)"Places", (String)CLASS_NAME, (String)String.format("Unable to create a PlacesPOI object with json %s. JSONException: %s", poiJson, exception.getLocalizedMessage()), (Object[])new Object[0]);
            return null;
        }
    }
}

