/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.places;

import com.adobe.marketing.mobile.places.PlacesUtil;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class PlacesPOI {
    private String identifier;
    private String name;
    private double latitude;
    private double longitude;
    private int radius;
    private boolean userIsWithin;
    private String library;
    private int weight;
    private Map<String, String> metadata;

    public String getIdentifier() {
        return this.identifier;
    }

    public String getName() {
        return this.name;
    }

    public boolean containsUser() {
        return this.userIsWithin;
    }

    public void setUserIsWithin(boolean userIsWithin) {
        this.userIsWithin = userIsWithin;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public int getRadius() {
        return this.radius;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public int getWeight() {
        return this.weight;
    }

    public String getLibrary() {
        return this.library;
    }

    protected PlacesPOI(PlacesPOI placesPOI) {
        if (placesPOI == null) {
            return;
        }
        this.identifier = placesPOI.identifier;
        this.name = placesPOI.name;
        this.latitude = placesPOI.latitude;
        this.longitude = placesPOI.longitude;
        this.radius = placesPOI.radius;
        this.userIsWithin = placesPOI.userIsWithin;
        this.weight = placesPOI.weight;
        this.library = placesPOI.library;
        this.metadata = placesPOI.metadata;
    }

    protected PlacesPOI(String jsonString) throws JSONException {
        JSONObject poiJson = new JSONObject(jsonString);
        if (poiJson == null) {
            throw new JSONException("Cannot convert json string into json object");
        }
        this.jsonObjectToPlacesPOI(poiJson);
    }

    protected PlacesPOI(JSONObject poiJson) throws JSONException {
        this.jsonObjectToPlacesPOI(poiJson);
    }

    private void jsonObjectToPlacesPOI(JSONObject poiJson) throws JSONException {
        this.identifier = poiJson.getString("regionid");
        this.name = poiJson.getString("regionname");
        this.latitude = poiJson.getDouble("latitude");
        this.longitude = poiJson.getDouble("longitude");
        this.radius = poiJson.getInt("radius");
        this.userIsWithin = poiJson.getBoolean("useriswithin");
        this.weight = poiJson.getInt("weight");
        this.library = poiJson.optString("libraryid", "");
        JSONObject metadataJSON = poiJson.optJSONObject("regionmetadata");
        if (metadataJSON != null) {
            this.metadata = PlacesUtil.convertPOIMetadataToStringMap(metadataJSON);
        }
    }

    protected PlacesPOI(String identifier, String name, double latitude, double longitude, int radius, String library, int weight, Map<String, String> metadata) {
        this.identifier = identifier;
        this.name = name;
        this.latitude = latitude;
        this.longitude = longitude;
        this.radius = radius;
        this.library = library;
        this.weight = weight;
        this.metadata = metadata;
    }

    protected PlacesPOI(String identifier, String name, double latitude, double longitude, int radius, String library, int weight) {
        this(identifier, name, latitude, longitude, radius, library, weight, null);
    }

    protected void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    protected void setName(String name) {
        this.name = name;
    }

    protected void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    protected void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    protected void setRadius(int radius) {
        this.radius = radius;
    }

    protected void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    void setWeight(int weight) {
        this.weight = weight;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        PlacesPOI placesPOI = (PlacesPOI)o;
        if (!this.equalsWithOutMetaData(placesPOI)) {
            return false;
        }
        return this.metadata != null ? this.metadata.equals(placesPOI.metadata) : placesPOI.metadata == null;
    }

    boolean equalsWithOutMetaData(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlacesPOI placesPOI = (PlacesPOI)o;
        if (Double.compare(placesPOI.latitude, this.latitude) != 0) {
            return false;
        }
        if (Double.compare(placesPOI.longitude, this.longitude) != 0) {
            return false;
        }
        if (Double.compare(placesPOI.radius, this.radius) != 0) {
            return false;
        }
        if (!this.identifier.equals(placesPOI.identifier)) {
            return false;
        }
        if (!this.name.equals(placesPOI.name)) {
            return false;
        }
        if (this.weight != placesPOI.weight) {
            return false;
        }
        if (!this.library.equals(placesPOI.library)) {
            return false;
        }
        return this.userIsWithin == placesPOI.userIsWithin;
    }

    public boolean comparePriority(PlacesPOI otherPOI) {
        if (otherPOI != null) {
            if (otherPOI.weight < this.weight) {
                return false;
            }
            if (otherPOI.weight == this.weight) {
                return otherPOI.radius >= this.radius;
            }
        }
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int numBits = 32;
        int result = this.identifier.hashCode();
        result = 31 * result + this.name.hashCode();
        long temp = Double.doubleToLongBits(this.latitude);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.longitude);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.radius);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.metadata != null ? this.metadata.hashCode() : 0);
        return result;
    }

    Map<String, Object> toMap() {
        HashMap<String, Object> poiMap = new HashMap<String, Object>();
        poiMap.put("regionid", this.identifier);
        poiMap.put("regionname", this.name);
        poiMap.put("latitude", this.latitude);
        poiMap.put("longitude", this.longitude);
        poiMap.put("radius", this.radius);
        poiMap.put("regionmetadata", this.metadata);
        poiMap.put("useriswithin", this.userIsWithin);
        poiMap.put("libraryid", this.library);
        poiMap.put("weight", this.weight);
        return poiMap;
    }

    String toJsonString() {
        JSONObject jsonObject = new JSONObject(this.toMap());
        return jsonObject.toString();
    }
}

