/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.places;

import com.adobe.marketing.mobile.places.PlacesLibrary;
import com.adobe.marketing.mobile.services.Log;
import com.adobe.marketing.mobile.util.DataReader;
import com.adobe.marketing.mobile.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

class PlacesConfiguration {
    private static final String CLASS_NAME = "PlacesConfiguration";
    private List<PlacesLibrary> libraries;
    private String endpoint;
    private long membershipTtl;
    private boolean isValid;

    PlacesConfiguration(Map<String, Object> configData) {
        this();
        if (configData == null) {
            this.isValid = false;
            Log.warning((String)"Places", (String)CLASS_NAME, (String)"Constructor - Places Configuration : Configuration eventData is null", (Object[])new Object[0]);
            return;
        }
        this.libraries = new ArrayList<PlacesLibrary>();
        List libraryList = DataReader.optTypedList(Map.class, configData, (String)"places.libraries", null);
        if (libraryList == null) {
            this.isValid = false;
            Log.warning((String)"Places", (String)CLASS_NAME, (String)"Constructor - No places libraries found in configuration", (Object[])new Object[0]);
            return;
        }
        for (Map eachLibrary : libraryList) {
            if (eachLibrary == null || eachLibrary.isEmpty()) continue;
            String libraryId = DataReader.optString((Map)eachLibrary, (String)"id", (String)"");
            if (!StringUtils.isNullOrEmpty((String)libraryId)) {
                this.libraries.add(new PlacesLibrary(libraryId));
                continue;
            }
            Log.warning((String)"Places", (String)CLASS_NAME, (String)"Constructor - Invalid places library Id.", (Object[])new Object[0]);
        }
        if (this.libraries.isEmpty()) {
            this.isValid = false;
            Log.warning((String)"Places", (String)CLASS_NAME, (String)"Constructor - Places Configuration : No valid libraries found in configuration", (Object[])new Object[0]);
            return;
        }
        this.endpoint = DataReader.optString(configData, (String)"places.endpoint", (String)"");
        if (StringUtils.isNullOrEmpty((String)this.endpoint)) {
            this.isValid = false;
            Log.warning((String)"Places", (String)CLASS_NAME, (String)"Constructor - Places Configuration : No valid endpoint found in configuration", (Object[])new Object[0]);
            return;
        }
        this.membershipTtl = DataReader.optLong(configData, (String)"places.membershipttl", (long)3600L);
        this.isValid = true;
    }

    String getLibrariesQueryString() {
        StringBuilder builder = new StringBuilder();
        for (PlacesLibrary library : this.libraries) {
            builder.append("&library=");
            builder.append(library.getLibraryId());
        }
        return builder.toString();
    }

    String getEndpoint() {
        return this.endpoint;
    }

    boolean isValid() {
        return this.isValid;
    }

    long getMembershipTtl() {
        return this.membershipTtl;
    }

    private PlacesConfiguration() {
    }
}

