/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile;

import android.location.Location;
import androidx.annotation.NonNull;
import com.adobe.marketing.mobile.AdobeCallback;
import com.adobe.marketing.mobile.AdobeCallbackWithError;
import com.adobe.marketing.mobile.AdobeError;
import com.adobe.marketing.mobile.Event;
import com.adobe.marketing.mobile.Extension;
import com.adobe.marketing.mobile.MobileCore;
import com.adobe.marketing.mobile.places.PlacesAuthorizationStatus;
import com.adobe.marketing.mobile.places.PlacesExtension;
import com.adobe.marketing.mobile.places.PlacesPOI;
import com.adobe.marketing.mobile.places.PlacesRequestError;
import com.adobe.marketing.mobile.places.PlacesUtil;
import com.adobe.marketing.mobile.services.Log;
import com.adobe.marketing.mobile.util.DataReader;
import com.adobe.marketing.mobile.util.DataReaderException;
import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.GeofencingEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Places {
    public static final Class<? extends Extension> EXTENSION = PlacesExtension.class;
    private static final String CLASS_NAME = "Places";
    private static final long EVENT_RESPONSE_TIMEOUT = 5000L;
    public static final String EXTENSION_VERSION = "3.0.2";
    static final String LOG_TAG = "Places";

    private Places() {
    }

    @NonNull
    public static String extensionVersion() {
        return EXTENSION_VERSION;
    }

    public static void getNearbyPointsOfInterest(@NonNull Location location, int limit, @NonNull AdobeCallback<List<PlacesPOI>> successCallback, @NonNull AdobeCallback<PlacesRequestError> errorCallback) {
        Places.getNearbyPointsOfInterestInternal(location, limit, successCallback, errorCallback);
    }

    public static void processGeofenceEvent(@NonNull GeofencingEvent geofencingEvent) {
        if (geofencingEvent.hasError()) {
            Log.warning((String)"Places", (String)"Places", (String)"Ignoring call to processGeofenceEvent. Provided GeofencingEvent has an error. ErrorCode: %d ", (Object[])new Object[]{geofencingEvent.getErrorCode()});
            return;
        }
        String regionEventType = Places.getRegionTransitionType(geofencingEvent.getGeofenceTransition());
        if ("none".equals(regionEventType)) {
            Log.warning((String)"Places", (String)"Places", (String)"Ignoring call to processGeofenceEvent. Transition type of GeofencingEvent is not recognized.", (Object[])new Object[0]);
            return;
        }
        List<Map<String, Object>> regions = Places.createRegionsEventData(geofencingEvent.getTriggeringGeofences(), regionEventType);
        if (regions == null) {
            Log.warning((String)"Places", (String)"Places", (String)"Ignoring call to processGeofenceEvent. No valid Places region found for the provided GeofencingEvent.", (Object[])new Object[0]);
            return;
        }
        Places.sendGeofenceEvents(regions);
    }

    public static void processGeofence(@NonNull Geofence geofence, int transitionType) {
        String regionEventType;
        if (geofence == null) {
            Log.warning((String)"Places", (String)"Places", (String)"Ignoring call to processGeofence. Geofence object is null.", (Object[])new Object[0]);
        }
        if ("none".equals(regionEventType = Places.getRegionTransitionType(transitionType))) {
            Log.warning((String)"Places", (String)"Places", (String)"Ignoring call to processGeofence. TransitionType of the Geofence is not recognized.", (Object[])new Object[0]);
            return;
        }
        ArrayList<Geofence> geofences = new ArrayList<Geofence>();
        geofences.add(geofence);
        List<Map<String, Object>> regions = Places.createRegionsEventData(geofences, regionEventType);
        if (regions == null) {
            Log.debug((String)"Places", (String)"Places", (String)"Ignoring call to processGeofence. No valid Places region found for the provided Geofence", (Object[])new Object[0]);
            return;
        }
        Places.sendGeofenceEvents(regions);
    }

    public static void getCurrentPointsOfInterest(final @NonNull AdobeCallback<List<PlacesPOI>> callback) {
        if (callback == null) {
            Log.debug((String)"Places", (String)"Places", (String)"Ignoring call to getCurrentPointsOfInterest. Callback provided with getCurrentPointsOfInterest API is null.", (Object[])new Object[0]);
            return;
        }
        HashMap<String, String> eventDataMap = new HashMap<String, String>();
        eventDataMap.put("requesttype", "requestgetuserwithinplaces");
        Event event = new Event.Builder("requestgetuserwithinplaces", "com.adobe.eventType.places", "com.adobe.eventSource.requestContent").setEventData(eventDataMap).build();
        MobileCore.dispatchEventWithResponseCallback((Event)event, (long)5000L, (AdobeCallbackWithError)new AdobeCallbackWithError<Event>(){
            final AdobeCallbackWithError userCallbackWithError;
            {
                this.userCallbackWithError = callback instanceof AdobeCallbackWithError ? (AdobeCallbackWithError)callback : null;
            }

            public void fail(AdobeError adobeError) {
                this.executeCallbackWithError(adobeError);
            }

            public void call(Event event) {
                Map responseEventData = event.getEventData();
                if (responseEventData == null) {
                    callback.call(new ArrayList());
                    return;
                }
                try {
                    List poisMap = DataReader.getTypedList(Map.class, (Map)responseEventData, (String)"userwithinpois");
                    callback.call(PlacesUtil.convertMapToPOIList(poisMap));
                }
                catch (DataReaderException e) {
                    Log.warning((String)"Places", (String)"Places", (String)String.format("Exception while reading POI from eventData. Returning empty POI list. Exception : %s", e.getLocalizedMessage()), (Object[])new Object[0]);
                    callback.call(new ArrayList());
                }
            }

            private void executeCallbackWithError(AdobeError adobeError) {
                if (this.userCallbackWithError != null) {
                    this.userCallbackWithError.fail(adobeError);
                } else {
                    callback.call(new ArrayList());
                }
            }
        });
    }

    public static void getLastKnownLocation(final @NonNull AdobeCallback<Location> callback) {
        if (callback == null) {
            Log.debug((String)"Places", (String)"Places", (String)"Ignoring call to getLastKnownLocation. Callback is null.", (Object[])new Object[0]);
            return;
        }
        HashMap<String, String> eventDataMap = new HashMap<String, String>();
        eventDataMap.put("requesttype", "requestgetlastknownlocation");
        Event event = new Event.Builder("requestgetlastknownlocation", "com.adobe.eventType.places", "com.adobe.eventSource.requestContent").setEventData(eventDataMap).build();
        MobileCore.dispatchEventWithResponseCallback((Event)event, (long)5000L, (AdobeCallbackWithError)new AdobeCallbackWithError<Event>(){
            final AdobeCallbackWithError userCallbackWithError;
            {
                this.userCallbackWithError = callback instanceof AdobeCallbackWithError ? (AdobeCallbackWithError)callback : null;
            }

            public void fail(AdobeError adobeError) {
                this.executeCallbackWithError(adobeError);
            }

            public void call(Event event) {
                Map eventDataMap = event.getEventData();
                if (eventDataMap == null || eventDataMap.isEmpty()) {
                    Log.warning((String)"Places", (String)"Places", (String)"Places response event have empty event data, returning null to getLastKnownLocation API call.", (Object[])new Object[0]);
                    callback.call(null);
                    return;
                }
                try {
                    double latitude = DataReader.getDouble((Map)eventDataMap, (String)"lastknownlatitude");
                    double longitude = DataReader.getDouble((Map)eventDataMap, (String)"lastknownlongitude");
                    if (!PlacesUtil.isValidLat(latitude) || !PlacesUtil.isValidLon(longitude)) {
                        Log.warning((String)"Places", (String)"Places", (String)"Unable to read valid latitude and longitude from Places response event, returning null to getLastKnownLocation API call.", (Object[])new Object[0]);
                        callback.call(null);
                        return;
                    }
                    Location lastKnownLocation = new Location("com.adobe.places.lastknownlocation");
                    lastKnownLocation.setLatitude(latitude);
                    lastKnownLocation.setLongitude(longitude);
                    callback.call((Object)lastKnownLocation);
                }
                catch (DataReaderException exp) {
                    Log.error((String)"Places", (String)"Places", (String)"Unable to read latitude and longitude from Places response event", (Object[])new Object[0]);
                    this.userCallbackWithError.fail(AdobeError.UNEXPECTED_ERROR);
                }
            }

            private void executeCallbackWithError(AdobeError adobeError) {
                if (this.userCallbackWithError != null) {
                    this.userCallbackWithError.fail(adobeError);
                } else {
                    callback.call(null);
                }
            }
        });
    }

    public static void clear() {
        HashMap<String, String> eventDataMap = new HashMap<String, String>();
        eventDataMap.put("requesttype", "requestreset");
        Event event = new Event.Builder("requestreset", "com.adobe.eventType.places", "com.adobe.eventSource.requestContent").setEventData(eventDataMap).build();
        MobileCore.dispatchEvent((Event)event);
    }

    public static void setAuthorizationStatus(@NonNull PlacesAuthorizationStatus status) {
        if (status == null) {
            Log.warning((String)"Places", (String)"Places", (String)"Ignoring call to setAuthorizationStatus. PlacesAuthorizationStatus cannot be set to null. Provide a valid value.", (Object[])new Object[0]);
            return;
        }
        HashMap<String, String> eventDataMap = new HashMap<String, String>();
        eventDataMap.put("requesttype", "requestsetauthorizationstatus");
        eventDataMap.put("authstatus", status.stringValue());
        Event event = new Event.Builder("requestsetauthorizationstatus", "com.adobe.eventType.places", "com.adobe.eventSource.requestContent").setEventData(eventDataMap).build();
        MobileCore.dispatchEvent((Event)event);
    }

    private static List<Map<String, Object>> createRegionsEventData(List<Geofence> geofences, String regionEventType) {
        ArrayList<Map<String, Object>> placesRegions = new ArrayList<Map<String, Object>>();
        if (geofences == null) {
            return placesRegions;
        }
        for (Geofence geofence : geofences) {
            if (geofence == null) continue;
            HashMap<String, String> eventDataMap = new HashMap<String, String>();
            eventDataMap.put("regionid", geofence.getRequestId());
            eventDataMap.put("regioneventtype", regionEventType);
            placesRegions.add(eventDataMap);
        }
        return placesRegions;
    }

    private static void sendGeofenceEvents(List<Map<String, Object>> placesRegions) {
        for (Map<String, Object> placesRegion : placesRegions) {
            placesRegion.put("requesttype", "requestprocessregionevent");
            Event event = new Event.Builder("requestprocessregionevent", "com.adobe.eventType.places", "com.adobe.eventSource.requestContent").setEventData(placesRegion).build();
            MobileCore.dispatchEvent((Event)event);
        }
    }

    private static String getRegionTransitionType(int geofenceTransitionType) {
        switch (geofenceTransitionType) {
            case 1: {
                return "entry";
            }
            case 2: {
                return "exit";
            }
        }
        return "none";
    }

    private static void getNearbyPointsOfInterestInternal(@NonNull Location location, int placesCount, final @NonNull AdobeCallback<List<PlacesPOI>> successCallback, final AdobeCallback<PlacesRequestError> errorCallback) {
        HashMap<String, Object> eventDataMap = new HashMap<String, Object>();
        eventDataMap.put("latitude", location.getLatitude());
        eventDataMap.put("longitude", location.getLongitude());
        eventDataMap.put("count", placesCount);
        eventDataMap.put("requesttype", "requestgetnearbyplaces");
        Event event = new Event.Builder("requestgetnearbyplaces", "com.adobe.eventType.places", "com.adobe.eventSource.requestContent").setEventData(eventDataMap).build();
        MobileCore.dispatchEventWithResponseCallback((Event)event, (long)5000L, (AdobeCallbackWithError)new AdobeCallbackWithError<Event>(){

            public void fail(AdobeError adobeError) {
                Log.debug((String)"Places", (String)"Places", (String)"Error occurred while retrieving nearbyPOIs, Adobe Error: %s.", (Object[])new Object[]{adobeError.getErrorName()});
                this.callErrorCallback(PlacesRequestError.UNKNOWN_ERROR);
            }

            public void call(Event event) {
                Map responseEventData = event.getEventData();
                if (responseEventData == null) {
                    this.callErrorCallback(PlacesRequestError.UNKNOWN_ERROR);
                    return;
                }
                try {
                    List poiMap = DataReader.getTypedList(Map.class, (Map)responseEventData, (String)"nearbypois");
                    int resultStatusInteger = DataReader.getInt((Map)responseEventData, (String)"status");
                    PlacesRequestError status = PlacesRequestError.fromInt(resultStatusInteger);
                    if (status == PlacesRequestError.OK) {
                        this.callSuccessCallback(PlacesUtil.convertMapToPOIList(poiMap));
                        return;
                    }
                    this.callErrorCallback(status);
                }
                catch (DataReaderException exp) {
                    this.callErrorCallback(PlacesRequestError.UNKNOWN_ERROR);
                }
            }

            private void callErrorCallback(PlacesRequestError requestError) {
                Log.debug((String)"Places", (String)"Places", (String)"Error occurred while retrieving nearbyPOIs, Error code: %s.", (Object[])new Object[]{requestError});
                if (errorCallback != null) {
                    errorCallback.call((Object)requestError);
                }
            }

            private void callSuccessCallback(List<PlacesPOI> pois) {
                if (successCallback != null) {
                    successCallback.call(pois);
                }
            }
        });
    }

    private static final class EventDataKeys {
        static final String STATE_OWNER = "stateowner";
        private static final String MODULE_NAME = "com.adobe.module.places";
        private static final String PLACES_COUNT = "count";
        private static final String LATITUDE = "latitude";
        private static final String LONGITUDE = "longitude";
        private static final String NEAR_BY_PLACES_LIST = "nearbypois";
        private static final String RESULT_STATUS = "status";
        static final String USER_WITHIN_POIS = "userwithinpois";
        static final String TRIGGERING_REGION = "triggeringregion";
        static final String REQUEST_TYPE = "requesttype";
        static final String REQUEST_TYPE_GET_NEARBY_PLACES = "requestgetnearbyplaces";
        static final String REQUEST_TYPE_PROCESS_REGION_EVENT = "requestprocessregionevent";
        static final String REQUEST_TYPE_GET_USER_WITHIN_PLACES = "requestgetuserwithinplaces";
        static final String REQUEST_TYPE_GET_LAST_KNOWN_LOCATION = "requestgetlastknownlocation";
        static final String REQUEST_TYPE_RESET = "requestreset";
        static final String REQUEST_TYPE_SET_AUTHORIZATION_STATUS = "requestsetauthorizationstatus";
        static final String REGION_NAME = "regionname";
        static final String REGION_ID = "regionid";
        static final String REGION_EVENT_TYPE = "regioneventtype";
        static final String REGION_METADATA = "regionmetadata";
        static final String REGION_TIMESTAMP = "timestamp";
        static final String LAST_KNOWN_LATITUDE = "lastknownlatitude";
        static final String LAST_KNOWN_LONGITUDE = "lastknownlongitude";
        static final String AUTH_STATUS = "authstatus";

        private EventDataKeys() {
        }
    }

    private static final class PlacesRegion {
        static final String PLACE_EVENT_NONE = "none";
        static final String PLACE_EVENT_ENTRY = "entry";
        static final String PLACE_EVENT_EXIT = "exit";

        private PlacesRegion() {
        }
    }

    private static final class EventName {
        static final String REQUEST_GETUSERWITHINPLACES = "requestgetuserwithinplaces";
        static final String REQUEST_GETLASTKNOWNLOCATION = "requestgetlastknownlocation";
        static final String REQUEST_GETNEARBYPLACES = "requestgetnearbyplaces";
        static final String REQUEST_PROCESSREGIONEVENT = "requestprocessregionevent";
        static final String REQUEST_RESET = "requestreset";
        static final String REQUEST_SETAUTHORIZATIONSTATUS = "requestsetauthorizationstatus";

        private EventName() {
        }
    }
}

