/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.lifecycle;

import com.adobe.marketing.mobile.services.DeviceInforming;
import com.adobe.marketing.mobile.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

final class LifecycleUtil {
    private static final String DATE_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";

    private LifecycleUtil() {
    }

    static String dateTimeISO8601String(Date timestamp) {
        return LifecycleUtil.dateToISO8601String(timestamp, DATE_TIME_FORMAT);
    }

    private static String dateToISO8601String(Date timestamp, String timestampFormat) {
        if (timestamp == null) {
            return "";
        }
        String timePattern = StringUtils.isNullOrEmpty((String)timestampFormat) ? DATE_TIME_FORMAT : timestampFormat;
        Locale posixLocale = new Locale(Locale.US.getLanguage(), Locale.US.getCountry(), "POSIX");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(timePattern, posixLocale);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return simpleDateFormat.format(timestamp);
    }

    static String formatLocale(Locale locale) {
        return locale == null ? null : locale.toString().replace('_', '-');
    }

    static String formatLocaleXDM(Locale locale) {
        if (locale == null) {
            return null;
        }
        return locale.toLanguageTag();
    }

    static String getV2AppVersion(DeviceInforming deviceInfoService) {
        if (deviceInfoService == null) {
            return null;
        }
        String applicationVersion = deviceInfoService.getApplicationVersion();
        String applicationVersionCode = deviceInfoService.getApplicationVersionCode();
        return String.format("%s%s", !StringUtils.isNullOrEmpty((String)applicationVersion) ? String.format("%s", applicationVersion) : "", !StringUtils.isNullOrEmpty((String)applicationVersionCode) ? String.format(" (%s)", applicationVersionCode) : "");
    }
}

