/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.identity;

import androidx.annotation.NonNull;
import com.adobe.marketing.mobile.identity.IdentityExtension;
import com.adobe.marketing.mobile.identity.IdentityHit;
import com.adobe.marketing.mobile.identity.IdentityResponseObject;
import com.adobe.marketing.mobile.identity.NetworkConnectionUtil;
import com.adobe.marketing.mobile.services.DataEntity;
import com.adobe.marketing.mobile.services.HitProcessing;
import com.adobe.marketing.mobile.services.HitProcessingResult;
import com.adobe.marketing.mobile.services.HttpMethod;
import com.adobe.marketing.mobile.services.Log;
import com.adobe.marketing.mobile.services.NetworkRequest;
import com.adobe.marketing.mobile.services.ServiceProvider;
import com.adobe.marketing.mobile.util.StreamUtils;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class IdentityHitsProcessing
implements HitProcessing {
    private static final String LOG_SOURCE = "IdentityHitsProcessing";
    private final IdentityExtension identityExtension;
    private final int RETRY_INTERVAL = 30;

    IdentityHitsProcessing(IdentityExtension identityExtension) {
        this.identityExtension = identityExtension;
    }

    public int retryInterval(DataEntity entity) {
        return 30;
    }

    public void processHit(@NonNull DataEntity entity, @NonNull int networkTimeoutInSeconds, @NonNull HitProcessingResult processingResult) {
        IdentityHit hit = IdentityHit.fromDataEntity(entity);
        if (hit == null) {
            processingResult.complete(true);
            return;
        }
        if (hit.getUrl() == null || hit.getEvent() == null) {
            Log.debug((String)"Identity", (String)LOG_SOURCE, (String)"IdentityHitsDatabase.process : Unable to process IdentityExtension hit because it does not contain a url or the trigger event.", (Object[])new Object[0]);
            processingResult.complete(true);
            return;
        }
        Log.debug((String)"Identity", (String)LOG_SOURCE, (String)"IdentityHitsDatabase.process : Sending request: (%s).", (Object[])new Object[]{hit.getUrl()});
        Map<String, String> requestPropertyMap = NetworkConnectionUtil.getHeaders(true);
        NetworkRequest networkRequest = new NetworkRequest(hit.getUrl(), HttpMethod.GET, null, requestPropertyMap, networkTimeoutInSeconds, networkTimeoutInSeconds);
        ServiceProvider.getInstance().getNetworkService().connectAsync(networkRequest, connection -> {
            if (connection == null) {
                Log.debug((String)"Identity", (String)LOG_SOURCE, (String)"IdentityHitsDatabase.process : network connection is null. Will retry later.", (Object[])new Object[0]);
                processingResult.complete(false);
                return;
            }
            if (connection.getResponseCode() == 200) {
                try {
                    String networkInputStreamJSONString = StreamUtils.readAsString((InputStream)connection.getInputStream());
                    JSONObject jsonObject = new JSONObject(networkInputStreamJSONString);
                    IdentityResponseObject result = this.createIdentityObjectFromResponseJsonObject(jsonObject);
                    Log.trace((String)"Identity", (String)LOG_SOURCE, (String)"IdentityHitsDatabase.process : ECID Service response data was parsed successfully.", (Object[])new Object[0]);
                    this.identityExtension.networkResponseLoaded(result, hit.getEvent());
                    processingResult.complete(true);
                }
                catch (JSONException e) {
                    Log.debug((String)"Identity", (String)LOG_SOURCE, (String)"IdentityHitsDatabase.process : An unknown exception occurred while trying to process the response from the ECID Service: (%s).", (Object[])new Object[]{e});
                    processingResult.complete(false);
                }
            } else if (!NetworkConnectionUtil.recoverableNetworkErrorCodes.contains(connection.getResponseCode())) {
                Log.debug((String)"Identity", (String)LOG_SOURCE, (String)"IdentityHitsDatabase.process : Discarding ECID Service request because of an un-recoverable network error with response code %d occurred while processing it.", (Object[])new Object[]{connection.getResponseCode()});
                this.identityExtension.networkResponseLoaded(null, hit.getEvent());
                processingResult.complete(true);
            } else {
                Log.debug((String)"Identity", (String)LOG_SOURCE, (String)"IdentityHitsDatabase.process : A recoverable network error occurred with response code %d while processing ECID Service requests.  Will retry in 30 seconds.", (Object[])new Object[]{connection.getResponseCode()});
                processingResult.complete(false);
            }
            connection.close();
        });
    }

    public void processHit(@NonNull DataEntity entity, @NonNull HitProcessingResult processingResult) {
        this.processHit(entity, 2, processingResult);
    }

    IdentityResponseObject createIdentityObjectFromResponseJsonObject(JSONObject jsonObject) {
        if (jsonObject == null) {
            Log.debug((String)"Identity", (String)LOG_SOURCE, (String)"createIdentityObjectFromResponseJsonObject: Unable to parse identity network response because the JSON object created was null.", (Object[])new Object[0]);
            return null;
        }
        IdentityResponseObject result = new IdentityResponseObject();
        result.blob = jsonObject.optString("d_blob", null);
        result.error = jsonObject.optString("error_msg", null);
        result.mid = jsonObject.optString("d_mid", null);
        int hintValue = jsonObject.optInt("dcs_region", -1);
        result.hint = hintValue == -1 ? null : Integer.toString(hintValue);
        result.ttl = jsonObject.optLong("id_sync_ttl", 600L);
        JSONArray optOutJsonArray = jsonObject.optJSONArray("d_optout");
        if (optOutJsonArray != null) {
            ArrayList<String> optOutVector = new ArrayList<String>();
            for (int i = 0; i < optOutJsonArray.length(); ++i) {
                try {
                    optOutVector.add(optOutJsonArray.getString(i));
                    continue;
                }
                catch (JSONException e) {
                    Log.debug((String)"Identity", (String)LOG_SOURCE, (String)"createIdentityObjectFromResponseJsonObject : Unable to read opt-out JSON array due to an exception: (%s).", (Object[])new Object[]{e});
                }
            }
            result.optOutList = optOutVector;
        }
        return result;
    }
}

