/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.identity;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.adobe.marketing.mobile.Event;
import com.adobe.marketing.mobile.Extension;
import com.adobe.marketing.mobile.ExtensionApi;
import com.adobe.marketing.mobile.Identity;
import com.adobe.marketing.mobile.MobilePrivacyStatus;
import com.adobe.marketing.mobile.SharedStateResolution;
import com.adobe.marketing.mobile.SharedStateResult;
import com.adobe.marketing.mobile.SharedStateStatus;
import com.adobe.marketing.mobile.VisitorID;
import com.adobe.marketing.mobile.identity.ConfigurationSharedStateIdentity;
import com.adobe.marketing.mobile.identity.IdentityConstants;
import com.adobe.marketing.mobile.identity.IdentityGenericPair;
import com.adobe.marketing.mobile.identity.IdentityHit;
import com.adobe.marketing.mobile.identity.IdentityHitsProcessing;
import com.adobe.marketing.mobile.identity.IdentityResponseObject;
import com.adobe.marketing.mobile.internal.util.VisitorIDSerializer;
import com.adobe.marketing.mobile.services.DataQueue;
import com.adobe.marketing.mobile.services.HitProcessing;
import com.adobe.marketing.mobile.services.HitQueuing;
import com.adobe.marketing.mobile.services.HttpMethod;
import com.adobe.marketing.mobile.services.Log;
import com.adobe.marketing.mobile.services.NamedCollection;
import com.adobe.marketing.mobile.services.NetworkRequest;
import com.adobe.marketing.mobile.services.Networking;
import com.adobe.marketing.mobile.services.PersistentHitQueue;
import com.adobe.marketing.mobile.services.ServiceProvider;
import com.adobe.marketing.mobile.util.DataReader;
import com.adobe.marketing.mobile.util.MapUtils;
import com.adobe.marketing.mobile.util.SQLiteUtils;
import com.adobe.marketing.mobile.util.StringUtils;
import com.adobe.marketing.mobile.util.TimeUtils;
import com.adobe.marketing.mobile.util.URLBuilder;
import com.adobe.marketing.mobile.util.UrlUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;

public final class IdentityExtension
extends Extension {
    private static final String LOG_SOURCE = "IdentityExtension";
    private HitQueuing hitQueue;
    private static final Object pushEnabledMutex = new Object();
    @VisibleForTesting
    ConfigurationSharedStateIdentity latestValidConfig;
    private final NamedCollection namedCollection;
    private String mid;
    private String advertisingIdentifier;
    private String pushIdentifier;
    private String blob;
    private String locationHint;
    private long lastSync;
    private long ttl;
    private List<VisitorID> customerIds;
    private MobilePrivacyStatus privacyStatus = IdentityConstants.Defaults.DEFAULT_MOBILE_PRIVACY;
    private boolean hasSynced = false;
    private boolean didCreateInitialSharedState = false;

    IdentityExtension(@NonNull ExtensionApi extensionApi) {
        this(extensionApi, ServiceProvider.getInstance().getDataStoreService().getNamedCollection("visitorIDServiceDataStore"), null);
    }

    @VisibleForTesting
    IdentityExtension(@NonNull ExtensionApi extensionApi, @Nullable NamedCollection namedCollection, @Nullable HitQueuing hitQueue) {
        super(extensionApi);
        this.namedCollection = namedCollection;
        this.hitQueue = hitQueue;
    }

    @NonNull
    protected String getName() {
        return "com.adobe.module.identity";
    }

    @NonNull
    protected String getFriendlyName() {
        return "Identity";
    }

    @NonNull
    protected String getVersion() {
        return Identity.extensionVersion();
    }

    protected void onRegistered() {
        this.getApi().registerEventListener("com.adobe.eventType.identity", "com.adobe.eventSource.requestIdentity", this::processIdentityRequest);
        this.getApi().registerEventListener("com.adobe.eventType.generic.identity", "com.adobe.eventSource.requestContent", this::processIdentityRequest);
        this.getApi().registerEventListener("com.adobe.eventType.generic.identity", "com.adobe.eventSource.requestReset", this::handleIdentityRequestReset);
        this.getApi().registerEventListener("com.adobe.eventType.identity", "com.adobe.eventSource.responseIdentity", this::handleIdentityResponseIdentityForSharedState);
        this.getApi().registerEventListener("com.adobe.eventType.analytics", "com.adobe.eventSource.responseIdentity", this::handleAnalyticsResponseIdentity);
        this.getApi().registerEventListener("com.adobe.eventType.audienceManager", "com.adobe.eventSource.responseContent", this::processAudienceResponse);
        this.getApi().registerEventListener("com.adobe.eventType.configuration", "com.adobe.eventSource.responseContent", this::handleConfiguration);
        this.boot();
    }

    protected void onUnregistered() {
        this.hitQueue.close();
    }

    public boolean readyForEvent(@NonNull Event event) {
        SharedStateResult sharedStateResult;
        if (!this.forceSyncIdentifiers(event)) {
            return false;
        }
        if (event.getType().equals("com.adobe.eventType.identity") && event.getSource().equals("com.adobe.eventSource.requestIdentity") && (event.getEventData() == null || event.getEventData().isEmpty())) {
            return true;
        }
        if (this.isSyncEvent(event) || "com.adobe.eventType.generic.identity".equals(event.getType())) {
            SharedStateResult configState = this.getApi().getSharedState("com.adobe.module.configuration", event, false, SharedStateResolution.LAST_SET);
            if (configState == null || configState.getStatus() != SharedStateStatus.SET) {
                Log.trace((String)"Identity", (String)LOG_SOURCE, (String)"Waiting for the Configuration shared state to be set before processing [event: %s].", (Object[])new Object[]{event.getName()});
                return false;
            }
            return this.readyForSyncIdentifiers(configState.getValue());
        }
        if ((this.isAppendUrlEvent(event) || this.isGetUrlVarsEvent(event)) && (sharedStateResult = this.getApi().getSharedState("com.adobe.module.analytics", event, false, SharedStateResolution.LAST_SET)) != null && sharedStateResult.getStatus() != SharedStateStatus.SET) {
            Log.trace((String)"Identity", (String)LOG_SOURCE, (String)"Waiting for the Analytics shared state to be set before processing [event: %s].", (Object[])new Object[]{event.getName()});
            return false;
        }
        if (!this.hasValidSharedState("com.adobe.module.configuration", event)) {
            Log.trace((String)"Identity", (String)LOG_SOURCE, (String)"Waiting for the Configuration shared state to get required configuration fields before processing [event: %s].", (Object[])new Object[]{event.getName()});
            return false;
        }
        return true;
    }

    @VisibleForTesting
    boolean readyForSyncIdentifiers(Map<String, Object> configurationSharedState) {
        this.updateLatestValidConfiguration(configurationSharedState);
        if (this.latestValidConfig == null || StringUtils.isNullOrEmpty((String)this.latestValidConfig.getOrgID())) {
            Log.debug((String)"Identity", (String)LOG_SOURCE, (String)"Cannot sync identifiers, waiting for configuration with valid 'experienceCloud.org' value.", (Object[])new Object[0]);
            return false;
        }
        return true;
    }

    @VisibleForTesting
    boolean forceSyncIdentifiers(@NonNull Event event) {
        if (this.hasSynced) {
            return true;
        }
        SharedStateResult configState = this.getApi().getSharedState("com.adobe.module.configuration", null, false, SharedStateResolution.LAST_SET);
        if (configState == null || configState.getStatus() != SharedStateStatus.SET) {
            Log.trace((String)"Identity", (String)LOG_SOURCE, (String)"Waiting for Configuration shared state before processing event [name: %s, id: %s]", (Object[])new Object[]{event.getName(), event.getUniqueIdentifier()});
            return false;
        }
        if (!this.readyForSyncIdentifiers(configState.getValue())) {
            return false;
        }
        this.loadPrivacyStatusFromConfigurationState(configState.getValue());
        this.hitQueue.handlePrivacyChange(this.privacyStatus);
        boolean bl = this.hasSynced = this.handleSyncIdentifiers(event, true) || MobilePrivacyStatus.OPT_OUT.equals((Object)this.privacyStatus);
        if (this.hasSynced && !this.didCreateInitialSharedState) {
            this.getApi().createSharedState(this.packageEventData(), event);
            this.didCreateInitialSharedState = true;
        }
        return this.hasSynced;
    }

    private boolean hasValidSharedState(String extensionName, Event event) {
        SharedStateResult sharedStateResult = this.getApi().getSharedState(extensionName, event, false, SharedStateResolution.LAST_SET);
        if (sharedStateResult == null || sharedStateResult.getStatus() != SharedStateStatus.SET) {
            return false;
        }
        Map sharedStateValue = sharedStateResult.getValue();
        return !MapUtils.isNullOrEmpty((Map)sharedStateValue);
    }

    private void boot() {
        this.loadVariablesFromPersistentData();
        this.deleteDeprecatedV5HitDatabase();
        this.initializeHitQueueDatabase();
        if (!StringUtils.isNullOrEmpty((String)this.mid)) {
            this.getApi().createSharedState(this.packageEventData(), null);
            this.didCreateInitialSharedState = true;
        }
    }

    private void deleteDeprecatedV5HitDatabase() {
        SQLiteUtils.deleteDBFromCacheDir((String)"ADBMobileIdentity.sqlite");
    }

    private void initializeHitQueueDatabase() {
        if (this.hitQueue == null) {
            DataQueue dataQueue = ServiceProvider.getInstance().getDataQueueService().getDataQueue("com.adobe.module.identity");
            this.hitQueue = new PersistentHitQueue(dataQueue, (HitProcessing)new IdentityHitsProcessing(this));
        }
    }

    void handleConfiguration(Event configurationEvent) {
        if (configurationEvent == null) {
            return;
        }
        Map configuration = configurationEvent.getEventData();
        if (configuration == null) {
            return;
        }
        this.updateLatestValidConfiguration(configuration);
        MobilePrivacyStatus mobilePrivacyStatus = MobilePrivacyStatus.fromString((String)DataReader.optString((Map)configuration, (String)"global.privacy", (String)IdentityConstants.Defaults.DEFAULT_MOBILE_PRIVACY.getValue()));
        this.hitQueue.handlePrivacyChange(mobilePrivacyStatus);
        if (mobilePrivacyStatus.equals((Object)MobilePrivacyStatus.OPT_OUT)) {
            this.handleOptOut(configuration);
        }
        this.processPrivacyChange(configurationEvent, configuration);
    }

    void handleAnalyticsResponseIdentity(Event event) {
        if (event == null) {
            return;
        }
        Map data = event.getEventData();
        if (data == null) {
            return;
        }
        String aid = DataReader.optString((Map)data, (String)"aid", null);
        if (StringUtils.isNullOrEmpty((String)aid)) {
            return;
        }
        if (this.namedCollection == null) {
            return;
        }
        if (this.namedCollection.contains("ADOBEMOBILE_AID_SYNCED")) {
            return;
        }
        this.namedCollection.setBoolean("ADOBEMOBILE_AID_SYNCED", true);
        HashMap<String, String> identifiers = new HashMap<String, String>();
        identifiers.put("AVID", aid);
        HashMap<String, Serializable> syncData = new HashMap<String, Serializable>();
        syncData.put("visitoridentifiers", identifiers);
        syncData.put("authenticationstate", Integer.valueOf(VisitorID.AuthenticationState.UNKNOWN.getValue()));
        syncData.put("forcesync", Boolean.valueOf(false));
        syncData.put("issyncevent", Boolean.valueOf(true));
        Event avidEvent = new Event.Builder("AVID Sync", "com.adobe.eventType.identity", "com.adobe.eventSource.requestIdentity").setEventData(syncData).build();
        this.getApi().dispatch(avidEvent);
    }

    void handleIdentityResponseIdentityForSharedState(Event event) {
        if (event == null) {
            return;
        }
        Map data = event.getEventData();
        if (data == null || !DataReader.optBoolean((Map)data, (String)"updatesharedstate", (boolean)false)) {
            return;
        }
        this.getApi().createSharedState(this.packageEventData(), event);
    }

    void updateLatestValidConfiguration(Map<String, Object> data) {
        String orgId = DataReader.optString(data, (String)"experienceCloud.org", null);
        if (!StringUtils.isNullOrEmpty((String)orgId)) {
            this.latestValidConfig = new ConfigurationSharedStateIdentity(data);
        }
    }

    void handleIdentityRequestReset(@NonNull Event event) {
        if (this.privacyStatus == MobilePrivacyStatus.OPT_OUT) {
            Log.debug((String)"Identity", (String)LOG_SOURCE, (String)"handleIdentityRequestReset: Privacy is opt-out, ignoring event.", (Object[])new Object[0]);
            return;
        }
        this.clearIdentifiers();
        this.savePersistently();
        if (this.handleSyncIdentifiers(event, false)) {
            this.getApi().createSharedState(this.packageEventData(), event);
        }
    }

    void processAudienceResponse(Event audienceEvent) {
        if (audienceEvent == null) {
            return;
        }
        Map data = audienceEvent.getEventData();
        if (data == null) {
            return;
        }
        if (data.containsKey("optedouthitsent")) {
            boolean optOutHitSent = DataReader.optBoolean((Map)data, (String)"optedouthitsent", (boolean)false);
            if (optOutHitSent) {
                return;
            }
            SharedStateResult identitySharedState = this.getApi().getSharedState("com.adobe.module.configuration", audienceEvent, false, SharedStateResolution.ANY);
            if (identitySharedState == null || identitySharedState.getStatus() != SharedStateStatus.SET) {
                Log.trace((String)"Identity", (String)LOG_SOURCE, (String)"processAudienceResponse : Unable to process the Identity events in the event queue because the configuration shared state is pending.", (Object[])new Object[0]);
                return;
            }
            ConfigurationSharedStateIdentity configSharedState = new ConfigurationSharedStateIdentity(identitySharedState.getValue());
            if (configSharedState.getPrivacyStatus().equals((Object)MobilePrivacyStatus.OPT_OUT)) {
                this.sendOptOutHit(configSharedState);
            }
        }
    }

    @VisibleForTesting
    void sendOptOutHit(ConfigurationSharedStateIdentity configSharedState) {
        String optOutUrl = this.buildOptOutURLString(configSharedState);
        if (StringUtils.isNullOrEmpty((String)optOutUrl)) {
            Log.debug((String)"Identity", (String)LOG_SOURCE, (String)"sendOptOutHit : Unable to send network hit because the opt-out URL was null.", (Object[])new Object[0]);
            return;
        }
        Networking networkService = ServiceProvider.getInstance().getNetworkService();
        if (networkService == null) {
            Log.debug((String)"Identity", (String)LOG_SOURCE, (String)"sendOptOutHit : Unable to send network request to the opt-out URL (%s) because NetworkService is unavailable.", (Object[])new Object[]{optOutUrl});
            return;
        }
        Log.debug((String)"Identity", (String)LOG_SOURCE, (String)"sendOptOutHit : Sending network request to the opt-out URL: (%s).", (Object[])new Object[]{optOutUrl});
        NetworkRequest networkRequest = new NetworkRequest(optOutUrl, HttpMethod.GET, null, null, 2, 2);
        networkService.connectAsync(networkRequest, connection -> {
            if (connection == null) {
                Log.trace((String)"Identity", (String)LOG_SOURCE, (String)"sendOptOutHit - Failed to send the opt-out hit because the connection  is null(device is offline).", (Object[])new Object[0]);
                return;
            }
            if (connection.getResponseCode() == 200) {
                Log.trace((String)"Identity", (String)LOG_SOURCE, (String)"sendOptOutHit - Successfully sent the opt-out hit.", (Object[])new Object[0]);
            } else {
                Log.trace((String)"Identity", (String)LOG_SOURCE, (String)"sendOptOutHit - Failed to send the opt-out hit with connection status (%s).", (Object[])new Object[]{connection.getResponseCode()});
            }
            connection.close();
        });
    }

    @VisibleForTesting
    void loadVariablesFromPersistentData() {
        if (this.namedCollection == null) {
            Log.debug((String)"Identity", (String)LOG_SOURCE, (String)"loadVariablesFromPersistentData : Unable to load the Identity data from persistence because the LocalStorageService was null.", (Object[])new Object[0]);
            return;
        }
        this.mid = this.namedCollection.getString("ADOBEMOBILE_PERSISTED_MID", null);
        List<VisitorID> newCustomerIDs = IdentityExtension.convertVisitorIdsStringToVisitorIDObjects(this.namedCollection.getString("ADOBEMOBILE_VISITORID_IDS", null));
        this.customerIds = newCustomerIDs == null || newCustomerIDs.isEmpty() ? null : newCustomerIDs;
        int customerIdsSize = newCustomerIDs == null || newCustomerIDs.isEmpty() ? 0 : this.customerIds.size();
        this.locationHint = this.namedCollection.getString("ADOBEMOBILE_PERSISTED_MID_HINT", null);
        this.blob = this.namedCollection.getString("ADOBEMOBILE_PERSISTED_MID_BLOB", null);
        this.ttl = this.namedCollection.getLong("ADOBEMOBILE_VISITORID_TTL", 600L);
        this.lastSync = this.namedCollection.getLong("ADOBEMOBILE_VISITORID_SYNC", 0L);
        this.advertisingIdentifier = this.namedCollection.getString("ADOBEMOBILE_ADVERTISING_IDENTIFIER", null);
        this.pushIdentifier = this.namedCollection.getString("ADOBEMOBILE_PUSH_IDENTIFIER", null);
        Log.trace((String)"Identity", (String)LOG_SOURCE, (String)"loadVariablesFromPersistentData : Successfully loaded the Identity data from persistence. Loaded %d VisitorIds. ECID is set to %s. ", (Object[])new Object[]{customerIdsSize, this.mid});
    }

    @VisibleForTesting
    boolean isSyncEvent(@NonNull Event event) {
        return DataReader.optBoolean((Map)event.getEventData(), (String)"issyncevent", (boolean)false) || event.getType().equals("com.adobe.eventType.generic.identity");
    }

    private boolean isResetIdentityEvent(@NonNull Event event) {
        return event.getType().equals("com.adobe.eventType.generic.identity") && event.getSource().equals("com.adobe.eventSource.requestReset");
    }

    @VisibleForTesting
    boolean isAppendUrlEvent(@NonNull Event event) {
        return event.getEventData() != null && event.getEventData().containsKey("baseurl");
    }

    @VisibleForTesting
    boolean isGetUrlVarsEvent(@NonNull Event event) {
        return DataReader.optBoolean((Map)event.getEventData(), (String)"urlvariables", (boolean)false);
    }

    void processIdentityRequest(@NonNull Event event) {
        if (event.getType().equals("com.adobe.eventType.identity") && event.getSource().equals("com.adobe.eventSource.requestIdentity") && (event.getEventData() == null || event.getEventData().isEmpty())) {
            this.handleIdentityResponseEvent("IDENTITY_RESPONSE_CONTENT_ONE_TIME", this.packageEventData(), event);
            return;
        }
        SharedStateResult result = this.getApi().getSharedState("com.adobe.module.configuration", event, false, SharedStateResolution.LAST_SET);
        if (result == null) {
            return;
        }
        Map configuration = result.getValue();
        ConfigurationSharedStateIdentity configSharedState = new ConfigurationSharedStateIdentity(configuration);
        Log.trace((String)"Identity", (String)LOG_SOURCE, (String)"processEvent : Processing the Identity event: %s", (Object[])new Object[]{event});
        if (this.isSyncEvent(event) || "com.adobe.eventType.generic.identity".equals(event.getType())) {
            if (this.handleSyncIdentifiers(event, false)) {
                this.getApi().createSharedState(this.packageEventData(), event);
            }
        } else if (this.isAppendUrlEvent(event)) {
            SharedStateResult sharedStateResult = this.getApi().getSharedState("com.adobe.module.analytics", event, false, SharedStateResolution.LAST_SET);
            Map analyticsSharedState = null;
            if (sharedStateResult != null) {
                analyticsSharedState = sharedStateResult.getValue();
            }
            this.handleAppendURL(event, configSharedState, analyticsSharedState);
        } else if (this.isGetUrlVarsEvent(event)) {
            SharedStateResult sharedStateResult = this.getApi().getSharedState("com.adobe.module.analytics", event, false, SharedStateResolution.LAST_SET);
            Map analyticsSharedState = null;
            if (sharedStateResult != null) {
                analyticsSharedState = sharedStateResult.getValue();
            }
            this.handleGetUrlVariables(event, configSharedState, analyticsSharedState);
        }
    }

    void handleOptOut(Map<String, Object> configuration) {
        ConfigurationSharedStateIdentity configSharedState;
        if (!configuration.containsKey("audience.server") && (configSharedState = new ConfigurationSharedStateIdentity(configuration)).getPrivacyStatus().equals((Object)MobilePrivacyStatus.OPT_OUT)) {
            this.sendOptOutHit(configSharedState);
        }
    }

    @VisibleForTesting
    boolean handleSyncIdentifiers(Event event, boolean forceSync) {
        if (this.latestValidConfig == null) {
            Log.debug((String)"Identity", (String)LOG_SOURCE, (String)"handleSyncIdentifiers : Unable to process sync identifiers request as the configuration did not contain a valid Experience Cloud organization ID.", (Object[])new Object[0]);
            return false;
        }
        if (this.latestValidConfig.getPrivacyStatus() == MobilePrivacyStatus.OPT_OUT) {
            Log.debug((String)"Identity", (String)LOG_SOURCE, (String)"handleSyncIdentifiers : Ignored the Sync Identifiers call because the privacy status was opt-out.", (Object[])new Object[0]);
            return false;
        }
        if (event == null) {
            Log.debug((String)"Identity", (String)LOG_SOURCE, (String)"handleSyncIdentifiers : Ignoring the Sync Identifiers call because the event sent was null.", (Object[])new Object[0]);
            return false;
        }
        Map eventData = event.getEventData();
        Map<String, String> dpids = this.extractDPID(eventData);
        Map<String, String> identifiers = this.extractIdentifiers(eventData);
        VisitorID.AuthenticationState idState = VisitorID.AuthenticationState.fromInteger((int)DataReader.optInt((Map)eventData, (String)"authenticationstate", (int)0));
        boolean shouldForceSync = forceSync || DataReader.optBoolean((Map)eventData, (String)"forcesync", (boolean)false);
        List<VisitorID> currentCustomerIds = this.generateCustomerIds(identifiers, idState);
        IdentityGenericPair<VisitorID, Boolean> adidPair = this.extractAndUpdateAdid(eventData);
        boolean didAdidConsentChange = adidPair.getSecond();
        VisitorID adidIdentifier = adidPair.getFirst();
        if (adidIdentifier != null) {
            currentCustomerIds.add(adidIdentifier);
        }
        this.customerIds = this.mergeCustomerIds(currentCustomerIds);
        this.customerIds = this.cleanupVisitorIdentifiers(this.customerIds);
        if (this.shouldSync(currentCustomerIds = this.cleanupVisitorIdentifiers(currentCustomerIds), dpids, shouldForceSync || didAdidConsentChange, this.latestValidConfig)) {
            String urlString = this.buildURLString(currentCustomerIds, dpids, this.latestValidConfig, didAdidConsentChange);
            if (urlString != null) {
                IdentityHit hit = new IdentityHit(urlString, event);
                this.hitQueue.queue(hit.toDataEntity());
            } else {
                Log.warning((String)"Identity", (String)LOG_SOURCE, (String)"handleSyncIdentifiers : Ignoring ID sync because the URL is invalid.", (Object[])new Object[0]);
            }
        } else {
            Log.debug((String)"Identity", (String)LOG_SOURCE, (String)"handleSyncIdentifiers : Ignoring ID sync because nothing new to sync after the last sync.", (Object[])new Object[0]);
        }
        this.savePersistently();
        return true;
    }

    @VisibleForTesting
    Map<String, String> extractIdentifiers(Map<String, Object> eventData) {
        HashMap<String, String> identifiers = new HashMap<String, String>();
        if (eventData == null || !eventData.containsKey("visitoridentifiers")) {
            return identifiers;
        }
        Map identifiersMap = DataReader.optTypedMap(String.class, eventData, (String)"visitoridentifiers", null);
        if (identifiersMap != null) {
            return identifiersMap;
        }
        return identifiers;
    }

    IdentityGenericPair<VisitorID, Boolean> extractAndUpdateAdid(Map<String, Object> eventData) {
        VisitorID adidAsVisitorId = null;
        boolean didConsentChange = false;
        if (eventData == null || !eventData.containsKey("advertisingidentifier")) {
            return new IdentityGenericPair<Object, Boolean>(adidAsVisitorId, didConsentChange);
        }
        try {
            String newAdid = DataReader.optString(eventData, (String)"advertisingidentifier", (String)"");
            if ("00000000-0000-0000-0000-000000000000".equals(newAdid)) {
                newAdid = "";
            }
            if (!newAdid.isEmpty() && !newAdid.equals(this.advertisingIdentifier) || newAdid.isEmpty() && !StringUtils.isNullOrEmpty((String)this.advertisingIdentifier)) {
                if (newAdid.isEmpty() || StringUtils.isNullOrEmpty((String)this.advertisingIdentifier) || "00000000-0000-0000-0000-000000000000".equals(this.advertisingIdentifier)) {
                    didConsentChange = true;
                }
                adidAsVisitorId = new VisitorID("d_cid_ic", "DSID_20914", newAdid, VisitorID.AuthenticationState.AUTHENTICATED);
                this.updateAdvertisingIdentifier(newAdid);
                Log.trace((String)"Identity", (String)LOG_SOURCE, (String)"extractAndUpdateAdid : The advertising identifier was set to: (%s).", (Object[])new Object[]{newAdid});
            }
        }
        catch (Exception e) {
            Log.error((String)"Identity", (String)LOG_SOURCE, (String)"extractAndUpdateAdid : Unable to update the advertising identifier due to: (%s)", (Object[])new Object[]{e});
        }
        return new IdentityGenericPair<Object, Boolean>(adidAsVisitorId, didConsentChange);
    }

    void handleAppendURL(Event event, ConfigurationSharedStateIdentity configSharedState, Map<String, Object> analyticsSharedState) {
        Map eventData = event.getEventData();
        String urlString = DataReader.optString((Map)eventData, (String)"baseurl", null);
        this.appendVisitorInfoForURL(urlString, event, configSharedState, analyticsSharedState, null);
    }

    void handleGetUrlVariables(Event event, ConfigurationSharedStateIdentity configSharedState, @Nullable Map<String, Object> analyticsSharedState) {
        StringBuilder idStringBuilder = this.generateVisitorIDURLPayload(configSharedState, analyticsSharedState);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("urlvariables", idStringBuilder.toString());
        this.handleIdentityResponseEvent("IDENTITY_URL_VARIABLES", params, event);
    }

    void updatePushIdentifier(String pushId) {
        this.pushIdentifier = pushId;
        if (!this.processNewPushToken(pushId)) {
            Log.debug((String)"Identity", (String)LOG_SOURCE, (String)"updatePushIdentifier : Ignored a push token (%s) as it matches with an existing token, and the push notification status will not be re-sent to Analytics.", (Object[])new Object[]{pushId});
            return;
        }
        boolean pushEnabled = this.isPushEnabled();
        if (pushId == null && !pushEnabled) {
            this.changePushStatusAndHitAnalytics(false);
            Log.debug((String)"Identity", (String)LOG_SOURCE, (String)"updatePushIdentifier : First time sending a.push.optin false", (Object[])new Object[0]);
        } else if (pushId == null) {
            this.changePushStatusAndHitAnalytics(false);
        } else if (!pushEnabled) {
            this.changePushStatusAndHitAnalytics(true);
        }
    }

    boolean processNewPushToken(String pushToken) {
        boolean areTokensEqual;
        if (this.namedCollection == null) {
            Log.trace((String)"Identity", (String)LOG_SOURCE, (String)"processNewPushToken : Unable to update push settings because the LocalStorageService was not available.", (Object[])new Object[0]);
            return false;
        }
        String existingPushToken = this.namedCollection.getString("ADOBEMOBILE_PUSH_IDENTIFIER", null);
        boolean analyticsSynced = this.namedCollection.getBoolean("ADOBEMOBILE_ANALYTICS_PUSH_SYNC", false);
        boolean bl = areTokensEqual = StringUtils.isNullOrEmpty((String)pushToken) && existingPushToken == null || existingPushToken != null && existingPushToken.equals(pushToken);
        if (areTokensEqual && !StringUtils.isNullOrEmpty((String)pushToken) || areTokensEqual && analyticsSynced) {
            return false;
        }
        if (!analyticsSynced) {
            this.namedCollection.setBoolean("ADOBEMOBILE_ANALYTICS_PUSH_SYNC", true);
        }
        if (!StringUtils.isNullOrEmpty((String)pushToken)) {
            this.namedCollection.setString("ADOBEMOBILE_PUSH_IDENTIFIER", pushToken);
        } else {
            this.namedCollection.remove("ADOBEMOBILE_PUSH_IDENTIFIER");
        }
        return true;
    }

    void appendVisitorInfoForURL(String baseURL, Event event, ConfigurationSharedStateIdentity configSharedState, Map<String, Object> analyticsSharedState, StringBuilder idStringBuilderForTesting) {
        StringBuilder idStringBuilder;
        if (StringUtils.isNullOrEmpty((String)baseURL)) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("updatedurl", baseURL);
            this.handleIdentityResponseEvent("IDENTITY_APPENDED_URL", params, event);
            return;
        }
        StringBuilder modifiedURL = new StringBuilder(baseURL);
        StringBuilder stringBuilder = idStringBuilder = idStringBuilderForTesting != null ? idStringBuilderForTesting : this.generateVisitorIDURLPayload(configSharedState, analyticsSharedState);
        if (!StringUtils.isNullOrEmpty((String)idStringBuilder.toString())) {
            boolean isQueryAfterAnchor;
            int queryIndex = modifiedURL.indexOf("?");
            int anchorIndex = modifiedURL.indexOf("#");
            int insertIndex = anchorIndex > 0 ? anchorIndex : modifiedURL.length();
            boolean bl = isQueryAfterAnchor = anchorIndex > 0 && anchorIndex < queryIndex;
            if (queryIndex > 0 && queryIndex != modifiedURL.length() - 1 && !isQueryAfterAnchor) {
                idStringBuilder.insert(0, "&");
            } else if (queryIndex < 0 || isQueryAfterAnchor) {
                idStringBuilder.insert(0, "?");
            }
            modifiedURL.insert(insertIndex, idStringBuilder.toString());
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("updatedurl", modifiedURL.toString());
        this.handleIdentityResponseEvent("IDENTITY_APPENDED_URL", params, event);
    }

    String generateMID() {
        UUID uuid = UUID.randomUUID();
        long most = uuid.getMostSignificantBits();
        long least = uuid.getLeastSignificantBits();
        String ecid = String.format(Locale.US, "%019d%019d", most < 0L ? -most : most, least < 0L ? -least : least);
        Log.trace((String)"Identity", (String)LOG_SOURCE, (String)"generateMID : Generating new ECID %s", (Object[])new Object[]{ecid});
        return ecid;
    }

    String generateURLEncodedValuesCustomerIdString(List<VisitorID> visitorIDs) {
        if (visitorIDs == null || visitorIDs.isEmpty()) {
            Log.debug((String)"Identity", (String)LOG_SOURCE, (String)"generateURLEncodedValuesCustomerIdString : No Visitor ID exists in the provided list to generate for URL.", (Object[])new Object[0]);
            return null;
        }
        StringBuilder customerIdString = new StringBuilder();
        for (VisitorID newVisitorID : visitorIDs) {
            customerIdString.append("&");
            customerIdString.append("d_cid_ic");
            customerIdString.append("=");
            customerIdString.append(UrlUtils.urlEncode((String)newVisitorID.getIdType()));
            customerIdString.append("%01");
            String urlEncodedID = UrlUtils.urlEncode((String)newVisitorID.getId());
            if (urlEncodedID != null) {
                customerIdString.append(urlEncodedID);
            }
            customerIdString.append("%01");
            customerIdString.append(newVisitorID.getAuthenticationState().getValue());
        }
        if (customerIdString.charAt(0) == '&') {
            customerIdString.deleteCharAt(0);
        }
        return customerIdString.toString();
    }

    List<VisitorID> generateCustomerIds(Map<String, String> identifiers, VisitorID.AuthenticationState authenticationState) {
        if (identifiers == null) {
            return Collections.emptyList();
        }
        ArrayList<VisitorID> tempIds = new ArrayList<VisitorID>();
        for (Map.Entry<String, String> newID : identifiers.entrySet()) {
            try {
                VisitorID tempId = new VisitorID("d_cid_ic", newID.getKey(), newID.getValue(), authenticationState);
                tempIds.add(tempId);
            }
            catch (IllegalStateException ex) {
                Log.debug((String)"Identity", (String)LOG_SOURCE, (String)"generateCustomerIds : Unable to create Visitor IDs after encoding the provided list due to: (%s).", (Object[])new Object[]{ex});
            }
        }
        return tempIds;
    }

    Map<String, Object> packageEventData() {
        HashMap<String, Object> eventData = new HashMap<String, Object>();
        if (!StringUtils.isNullOrEmpty((String)this.mid)) {
            eventData.put("mid", this.mid);
        }
        if (!StringUtils.isNullOrEmpty((String)this.advertisingIdentifier)) {
            eventData.put("advertisingidentifier", this.advertisingIdentifier);
        }
        if (!StringUtils.isNullOrEmpty((String)this.pushIdentifier)) {
            eventData.put("pushidentifier", this.pushIdentifier);
        }
        if (!StringUtils.isNullOrEmpty((String)this.blob)) {
            eventData.put("blob", this.blob);
        }
        if (!StringUtils.isNullOrEmpty((String)this.locationHint)) {
            eventData.put("locationhint", this.locationHint);
        }
        if (this.customerIds != null && !this.customerIds.isEmpty()) {
            eventData.put("visitoridslist", this.convertVisitorIds(this.customerIds));
        }
        eventData.put("lastsync", this.lastSync);
        return eventData;
    }

    private List<Map<String, Object>> convertVisitorIds(List<VisitorID> visitorIDList) {
        ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
        for (VisitorID vId : visitorIDList) {
            data.add(VisitorIDSerializer.convertVisitorId((VisitorID)vId));
        }
        return data;
    }

    static List<VisitorID> convertVisitorIdsStringToVisitorIDObjects(String idString) {
        String[] customerIdComponentsArray;
        if (StringUtils.isNullOrEmpty((String)idString)) {
            return new ArrayList<VisitorID>();
        }
        ArrayList<VisitorID> visitorIDs = new ArrayList<VisitorID>();
        for (String customerIdString : customerIdComponentsArray = idString.split("&")) {
            if (StringUtils.isNullOrEmpty((String)customerIdString)) continue;
            VisitorID id = IdentityExtension.parseCustomerIDStringToVisitorIDObject(customerIdString);
            VisitorID duplicateId = null;
            for (VisitorID visitorID : visitorIDs) {
                if (!IdentityExtension.sameIdType(visitorID, id)) continue;
                duplicateId = visitorID;
                break;
            }
            if (duplicateId != null) {
                visitorIDs.remove(duplicateId);
            }
            if (id == null) continue;
            visitorIDs.add(id);
        }
        return visitorIDs;
    }

    StringBuilder generateVisitorIDURLPayload(ConfigurationSharedStateIdentity configSharedState, @Nullable Map<String, Object> analyticsSharedState) {
        String orgId;
        StringBuilder urlFragment = new StringBuilder();
        String theIdString = this.appendKVPToVisitorIdString(null, "TS", String.valueOf(TimeUtils.getUnixTimeInSeconds()));
        theIdString = this.appendKVPToVisitorIdString(theIdString, "MCMID", this.mid);
        String vid = null;
        if (analyticsSharedState != null) {
            String aid = DataReader.optString(analyticsSharedState, (String)"aid", null);
            if (!StringUtils.isNullOrEmpty((String)aid)) {
                theIdString = this.appendKVPToVisitorIdString(theIdString, "MCAID", aid);
            }
            vid = DataReader.optString(analyticsSharedState, (String)"vid", null);
        }
        String string = orgId = configSharedState != null ? configSharedState.getOrgID() : null;
        if (!StringUtils.isNullOrEmpty((String)orgId)) {
            theIdString = this.appendKVPToVisitorIdString(theIdString, "MCORGID", orgId);
        }
        urlFragment.append("adobe_mc");
        urlFragment.append("=");
        urlFragment.append(UrlUtils.urlEncode((String)theIdString));
        if (!StringUtils.isNullOrEmpty((String)vid)) {
            urlFragment.append("&");
            urlFragment.append("adobe_aa_vid");
            urlFragment.append("=");
            urlFragment.append(UrlUtils.urlEncode((String)vid));
        }
        return urlFragment;
    }

    String appendKVPToVisitorIdString(String originalString, String key, String value) {
        if (StringUtils.isNullOrEmpty((String)key) || StringUtils.isNullOrEmpty((String)value)) {
            return originalString;
        }
        String newUrlVariable = String.format("%s=%s", key, value);
        if (StringUtils.isNullOrEmpty((String)originalString)) {
            return newUrlVariable;
        }
        return String.format("%s|%s", originalString, newUrlVariable);
    }

    List<VisitorID> mergeCustomerIds(List<VisitorID> newCustomerIds) {
        if (newCustomerIds == null || newCustomerIds.isEmpty()) {
            return this.customerIds;
        }
        ArrayList<VisitorID> tempIds = this.customerIds != null ? new ArrayList<VisitorID>(this.customerIds) : new ArrayList();
        for (VisitorID newId : newCustomerIds) {
            VisitorID mergedId = null;
            VisitorID oldId = null;
            for (VisitorID visitorID : tempIds) {
                if (!IdentityExtension.sameIdType(visitorID, newId)) continue;
                mergedId = new VisitorID(visitorID.getIdOrigin(), visitorID.getIdType(), newId.getId(), newId.getAuthenticationState());
                oldId = visitorID;
                break;
            }
            if (mergedId != null) {
                tempIds.remove(oldId);
                tempIds.add(mergedId);
                continue;
            }
            tempIds.add(newId);
        }
        return tempIds;
    }

    void networkResponseLoaded(IdentityResponseObject result, Event event) {
        boolean requiresSharedStateUpdate = false;
        this.lastSync = TimeUtils.getUnixTimeInSeconds();
        if (this.privacyStatus != MobilePrivacyStatus.OPT_OUT) {
            requiresSharedStateUpdate = this.handleNetworkResponseMap(result);
            this.savePersistently();
        }
        Map<String, Object> updatedResponse = this.packageEventData();
        if (requiresSharedStateUpdate) {
            updatedResponse.put("updatesharedstate", true);
        }
        this.handleIdentityResponseEvent("UPDATED_IDENTITY_RESPONSE", updatedResponse, null);
        if (event != null) {
            this.handleIdentityResponseEvent("UPDATED_IDENTITY_RESPONSE", updatedResponse, event);
        }
    }

    private Map<String, String> extractDPID(Map<String, Object> eventData) {
        if (eventData == null) {
            return null;
        }
        HashMap<String, String> dpIDs = new HashMap<String, String>();
        if (eventData.containsKey("pushidentifier")) {
            try {
                String pushId = DataReader.optString(eventData, (String)"pushidentifier", null);
                this.updatePushIdentifier(pushId);
                dpIDs.put("20919", pushId);
            }
            catch (Exception e) {
                Log.error((String)"Identity", (String)LOG_SOURCE, (String)"extractDPID : Unable to update the push identifier due to: (%s).", (Object[])new Object[]{e});
            }
        }
        if (dpIDs.size() == 0) {
            return null;
        }
        return dpIDs;
    }

    private void updateAdvertisingIdentifier(String adid) {
        this.advertisingIdentifier = adid;
        this.savePersistently();
    }

    private void changePushStatusAndHitAnalytics(boolean isEnabled) {
        this.setPushStatus(isEnabled);
        HashMap<String, String> contextData = new HashMap<String, String>();
        contextData.put("a.push.optin", String.valueOf(isEnabled));
        HashMap<String, Object> analyticsData = new HashMap<String, Object>();
        analyticsData.put("action", "Push");
        analyticsData.put("contextdata", contextData);
        analyticsData.put("trackinternal", true);
        Event analyticsForMessageEvent = new Event.Builder("AnalyticsForIdentityRequest", "com.adobe.eventType.analytics", "com.adobe.eventSource.requestContent").setEventData(analyticsData).build();
        this.getApi().dispatch(analyticsForMessageEvent);
        Log.trace((String)"Identity", (String)LOG_SOURCE, (String)"dispatchAnalyticsHit : Analytics event has been added to event hub : (%s)", (Object[])new Object[]{analyticsForMessageEvent});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isPushEnabled() {
        Object object = pushEnabledMutex;
        synchronized (object) {
            if (this.namedCollection == null) {
                Log.trace((String)"Identity", (String)LOG_SOURCE, (String)"isPushEnabled : Unable to update push flag because the LocalStorageService was not available.", (Object[])new Object[0]);
                return false;
            }
            return this.namedCollection.getBoolean("ADOBEMOBILE_PUSH_ENABLED", false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPushStatus(boolean enabled) {
        Object object = pushEnabledMutex;
        synchronized (object) {
            if (this.namedCollection != null) {
                this.namedCollection.setBoolean("ADOBEMOBILE_PUSH_ENABLED", enabled);
                Log.trace((String)"Identity", (String)LOG_SOURCE, (String)("setPushStatus : Push notifications status is now: " + (enabled ? "Enabled" : "Disabled")), (Object[])new Object[0]);
            } else {
                Log.trace((String)"Identity", (String)LOG_SOURCE, (String)"setPushStatus : Unable to update push flag because the LocalStorageService was not available.", (Object[])new Object[0]);
            }
        }
    }

    private void handleIdentityResponseEvent(String eventName, Map<String, Object> eventData, Event event) {
        Event newEvent = event == null ? new Event.Builder(eventName, "com.adobe.eventType.identity", "com.adobe.eventSource.responseIdentity").setEventData(eventData).build() : new Event.Builder(eventName, "com.adobe.eventType.identity", "com.adobe.eventSource.responseIdentity").setEventData(eventData).inResponseToEvent(event).build();
        this.getApi().dispatch(newEvent);
        Log.trace((String)"Identity", (String)LOG_SOURCE, (String)"dispatchResponse : Identity Response event has been added to event hub : %s", (Object[])new Object[]{newEvent.toString()});
    }

    @VisibleForTesting
    void handleIdentityConfigurationUpdateEvent(Map<String, Object> eventData) {
        Event event = new Event.Builder("Configuration Update From IdentityExtension", "com.adobe.eventType.configuration", "com.adobe.eventSource.requestContent").setEventData(eventData).build();
        this.getApi().dispatch(event);
        Log.trace((String)"Identity", (String)LOG_SOURCE, (String)"dispatchConfigUpdateRequest : Configuration Update event has been added to event hub : %s", (Object[])new Object[]{event.toString()});
    }

    void processPrivacyChange(Event event, Map<String, Object> eventData) {
        if (eventData == null) {
            return;
        }
        String privacyString = DataReader.optString(eventData, (String)"global.privacy", (String)IdentityConstants.Defaults.DEFAULT_MOBILE_PRIVACY.getValue());
        MobilePrivacyStatus newPrivacyStatus = MobilePrivacyStatus.fromString((String)privacyString);
        if (this.privacyStatus == newPrivacyStatus) {
            return;
        }
        this.privacyStatus = newPrivacyStatus;
        Log.trace((String)"Identity", (String)LOG_SOURCE, (String)"processPrivacyChange : Processed privacy change request. New privacy status is: (%s).", (Object[])new Object[]{this.privacyStatus.getValue()});
        if (this.privacyStatus == MobilePrivacyStatus.OPT_OUT) {
            this.clearIdentifiers();
            this.savePersistently();
            this.getApi().createSharedState(this.packageEventData(), event);
        } else if (StringUtils.isNullOrEmpty((String)this.mid) && this.handleSyncIdentifiers(event, false)) {
            this.getApi().createSharedState(this.packageEventData(), event);
        }
        this.initializeHitQueueDatabase();
    }

    @VisibleForTesting
    void savePersistently() {
        if (this.namedCollection == null) {
            Log.trace((String)"Identity", (String)LOG_SOURCE, (String)"savePersistently : Unable to save the IdentityExtension fields into persistence because the data store was null.", (Object[])new Object[0]);
            return;
        }
        IdentityExtension.storeOrRemovePersistentString(this.namedCollection, "ADOBEMOBILE_VISITORID_IDS", this.stringFromVisitorIdList(this.customerIds));
        IdentityExtension.storeOrRemovePersistentString(this.namedCollection, "ADOBEMOBILE_PERSISTED_MID", this.mid);
        IdentityExtension.storeOrRemovePersistentString(this.namedCollection, "ADOBEMOBILE_PUSH_IDENTIFIER", this.pushIdentifier);
        IdentityExtension.storeOrRemovePersistentString(this.namedCollection, "ADOBEMOBILE_ADVERTISING_IDENTIFIER", this.advertisingIdentifier);
        IdentityExtension.storeOrRemovePersistentString(this.namedCollection, "ADOBEMOBILE_PERSISTED_MID_HINT", this.locationHint);
        IdentityExtension.storeOrRemovePersistentString(this.namedCollection, "ADOBEMOBILE_PERSISTED_MID_BLOB", this.blob);
        this.namedCollection.setLong("ADOBEMOBILE_VISITORID_TTL", this.ttl);
        this.namedCollection.setLong("ADOBEMOBILE_VISITORID_SYNC", this.lastSync);
        Log.trace((String)"Identity", (String)LOG_SOURCE, (String)"savePersistently : Successfully saved the Identity data into persistence.", (Object[])new Object[0]);
    }

    private static void storeOrRemovePersistentString(NamedCollection store, String key, String value) {
        if (StringUtils.isNullOrEmpty((String)value)) {
            store.remove(key);
        } else {
            store.setString(key, value);
        }
    }

    private String buildURLString(List<VisitorID> customerIds, Map<String, String> dpids, ConfigurationSharedStateIdentity configSharedState, boolean addConsentFlag) {
        String internalIdsString;
        LinkedHashMap<String, String> queryParameters = new LinkedHashMap<String, String>();
        queryParameters.put("d_ver", "2");
        queryParameters.put("d_rtbd", "json");
        if (addConsentFlag) {
            if (StringUtils.isNullOrEmpty((String)this.advertisingIdentifier)) {
                queryParameters.put("device_consent", "0");
                queryParameters.put("d_consent_ic", "DSID_20914");
            } else {
                queryParameters.put("device_consent", "1");
            }
        }
        queryParameters.put("d_orgid", configSharedState.getOrgID());
        if (this.mid != null) {
            queryParameters.put("d_mid", this.mid);
        }
        if (this.blob != null) {
            queryParameters.put("d_blob", this.blob);
        }
        if (this.locationHint != null) {
            queryParameters.put("dcs_region", this.locationHint);
        }
        URLBuilder urlBuilder = new URLBuilder();
        urlBuilder.addPath("id").setServer(configSharedState.getExperienceCloudServer()).addQueryParameters(queryParameters);
        String customerIdsString = this.generateURLEncodedValuesCustomerIdString(customerIds);
        if (!StringUtils.isNullOrEmpty((String)customerIdsString)) {
            urlBuilder.addQuery(customerIdsString, URLBuilder.EncodeType.NONE);
        }
        if (!StringUtils.isNullOrEmpty((String)(internalIdsString = this.generateInternalIdString(dpids)))) {
            urlBuilder.addQuery(internalIdsString, URLBuilder.EncodeType.NONE);
        }
        return urlBuilder.build();
    }

    private String buildOptOutURLString(ConfigurationSharedStateIdentity configSharedState) {
        if (configSharedState == null) {
            return null;
        }
        if (configSharedState.getOrgID() == null || this.mid == null) {
            return null;
        }
        HashMap<String, String> queryParameters = new HashMap<String, String>();
        queryParameters.put("d_orgid", configSharedState.getOrgID());
        queryParameters.put("d_mid", this.mid);
        URLBuilder urlBuilder = new URLBuilder();
        urlBuilder.addPath("demoptout.jpg").setServer(configSharedState.getExperienceCloudServer()).addQueryParameters(queryParameters);
        return urlBuilder.build();
    }

    private boolean shouldSync(List<VisitorID> identifiers, Map<String, String> dpids, boolean forceResync, ConfigurationSharedStateIdentity configuration) {
        boolean hasDpids;
        boolean syncForProps = true;
        boolean syncForIds = true;
        if (!configuration.canSyncIdentifiersWithCurrentConfiguration()) {
            Log.debug((String)"Identity", (String)LOG_SOURCE, (String)"shouldSync : Ignoring ID Sync due to privacy status opt-out or missing experienceCloud.org.", (Object[])new Object[0]);
            syncForProps = false;
        }
        boolean needResync = TimeUtils.getUnixTimeInSeconds() - this.lastSync > this.ttl || forceResync;
        boolean hasIdentifiers = identifiers != null && !identifiers.isEmpty();
        boolean bl = hasDpids = dpids != null;
        if (!(StringUtils.isNullOrEmpty((String)this.mid) || hasIdentifiers || hasDpids || needResync)) {
            syncForIds = false;
        } else if (StringUtils.isNullOrEmpty((String)this.mid)) {
            Log.trace((String)"Identity", (String)LOG_SOURCE, (String)"shouldSync : ECID is null when sync identifiers event received. Generate new ECID value.", (Object[])new Object[0]);
            this.mid = this.generateMID();
        }
        return syncForIds && syncForProps;
    }

    String generateInternalIdString(Map<String, String> dpids) {
        if (MapUtils.isNullOrEmpty(dpids)) {
            return "";
        }
        HashMap<String, String> dpidsCopy = new HashMap<String, String>(dpids);
        StringBuilder internalIdString = new StringBuilder();
        for (Map.Entry<String, String> entry : dpidsCopy.entrySet()) {
            internalIdString.append("&d_cid=");
            internalIdString.append(UrlUtils.urlEncode((String)entry.getKey()));
            internalIdString.append("%01");
            internalIdString.append(UrlUtils.urlEncode((String)entry.getValue()));
        }
        if (internalIdString.charAt(0) == '&') {
            internalIdString.deleteCharAt(0);
        }
        return internalIdString.toString();
    }

    List<VisitorID> cleanupVisitorIdentifiers(List<VisitorID> identifiers) {
        if (identifiers == null) {
            return null;
        }
        ArrayList<VisitorID> cleanIdentifiers = new ArrayList<VisitorID>(identifiers);
        try {
            Iterator iterator = cleanIdentifiers.iterator();
            while (iterator.hasNext()) {
                VisitorID identifier = (VisitorID)iterator.next();
                if (!StringUtils.isNullOrEmpty((String)identifier.getId())) continue;
                iterator.remove();
                Log.trace((String)"Identity", (String)LOG_SOURCE, (String)"cleanupVisitorIdentifiers : VisitorID was discarded due to an empty/null identifier value.", (Object[])new Object[0]);
            }
        }
        catch (NullPointerException e) {
            Log.error((String)"Identity", (String)LOG_SOURCE, (String)"cleanupVisitorIdentifiers : Caught NullPointerException while iterating through visitor identifiers: %s", (Object[])new Object[]{e.getLocalizedMessage()});
        }
        catch (ClassCastException e) {
            Log.error((String)"Identity", (String)LOG_SOURCE, (String)"cleanupVisitorIdentifiers : Caught ClassCastException while iterating through visitor identifiers: %s", (Object[])new Object[]{e.getLocalizedMessage()});
        }
        return cleanIdentifiers;
    }

    private static VisitorID parseCustomerIDStringToVisitorIDObject(String customerIdString) {
        String currentCustomerIdValue;
        String currentCustomerIdOrigin;
        int firstEqualsIndex = customerIdString.indexOf(61);
        if (firstEqualsIndex == -1) {
            Log.debug((String)"Identity", (String)LOG_SOURCE, (String)"parseCustomerIDStringToVisitorIDObject : Unable to load Visitor ID from Shared Preferences: (%s).", (Object[])new Object[]{customerIdString});
            return null;
        }
        try {
            currentCustomerIdOrigin = customerIdString.substring(0, firstEqualsIndex);
            currentCustomerIdValue = customerIdString.substring(firstEqualsIndex + 1);
        }
        catch (IndexOutOfBoundsException ex) {
            Log.debug((String)"Identity", (String)LOG_SOURCE, (String)"parseCustomerIDStringToVisitorIDObject : Unable to load Visitor ID: (%s) from Shared Preference because the name or value was malformed as in the exception: (%s).", (Object[])new Object[]{customerIdString, ex});
            return null;
        }
        List<String> idInfo = Arrays.asList(currentCustomerIdValue.split("%01"));
        if (idInfo.size() != 3) {
            Log.debug((String)"Identity", (String)LOG_SOURCE, (String)"parseCustomerIDStringToVisitorIDObject : Unable to load Visitor ID from Shared Preferences because the value was malformed: (%s).", (Object[])new Object[]{currentCustomerIdValue});
            return null;
        }
        if (StringUtils.isNullOrEmpty((String)idInfo.get(1))) {
            Log.debug((String)"Identity", (String)LOG_SOURCE, (String)"parseCustomerIDStringToVisitorIDObject : Unable to load Visitor ID from Shared Preferences because the ECID had null or empty id: (%s).", (Object[])new Object[]{currentCustomerIdValue});
            return null;
        }
        try {
            return new VisitorID(currentCustomerIdOrigin, idInfo.get(0), idInfo.get(1), VisitorID.AuthenticationState.fromInteger((int)Integer.parseInt(idInfo.get(2))));
        }
        catch (IllegalStateException | NumberFormatException ex) {
            Log.debug((String)"Identity", (String)LOG_SOURCE, (String)"parseCustomerIDStringToVisitorIDObject : Unable to parse the ECID: (%s) due to an exception: (%s).", (Object[])new Object[]{customerIdString, ex.getLocalizedMessage()});
            return null;
        }
    }

    private String stringFromVisitorIdList(List<VisitorID> visitorIDs) {
        if (visitorIDs == null) {
            return "";
        }
        StringBuilder customerIdString = new StringBuilder();
        for (VisitorID visitorID : visitorIDs) {
            customerIdString.append("&");
            customerIdString.append("d_cid_ic");
            customerIdString.append("=");
            customerIdString.append(visitorID.getIdType());
            customerIdString.append("%01");
            if (visitorID.getId() != null) {
                customerIdString.append(visitorID.getId());
            }
            customerIdString.append("%01");
            customerIdString.append(visitorID.getAuthenticationState().getValue());
        }
        return customerIdString.toString();
    }

    @VisibleForTesting
    boolean handleNetworkResponseMap(IdentityResponseObject identityResponseObject) {
        boolean requiresSharedStateUpdate = false;
        if (identityResponseObject == null) {
            Log.debug((String)"Identity", (String)LOG_SOURCE, (String)"handleNetworkResponseMap : Received an empty JSON in response from ECID Service, so there is nothing to handle.", (Object[])new Object[0]);
            return false;
        }
        if (identityResponseObject.optOutList != null && !identityResponseObject.optOutList.isEmpty()) {
            Log.debug((String)"Identity", (String)LOG_SOURCE, (String)"handleNetworkResponseMap : Received opt-out response from ECID Service, so updating the privacy status in the configuration to opt-out.", (Object[])new Object[0]);
            HashMap<String, String> updateConfig = new HashMap<String, String>();
            updateConfig.put("global.privacy", MobilePrivacyStatus.OPT_OUT.getValue());
            HashMap<String, Object> eventData = new HashMap<String, Object>();
            eventData.put("config.update", updateConfig);
            this.handleIdentityConfigurationUpdateEvent(eventData);
        }
        if (!StringUtils.isNullOrEmpty((String)identityResponseObject.error)) {
            Log.warning((String)"Identity", (String)LOG_SOURCE, (String)"handleNetworkResponseMap : ECID Service returned an error: (%s).", (Object[])new Object[]{identityResponseObject.error});
            if (this.mid == null) {
                Log.trace((String)"Identity", (String)LOG_SOURCE, (String)"handleNetworkResponseMap : ECID is null when network response error received. Generate new ECID value.", (Object[])new Object[0]);
                this.mid = this.generateMID();
                requiresSharedStateUpdate = true;
            }
            return requiresSharedStateUpdate;
        }
        if (!StringUtils.isNullOrEmpty((String)identityResponseObject.mid) && identityResponseObject.mid.equals(this.mid)) {
            try {
                if (identityResponseObject.blob != null && !identityResponseObject.blob.equals(this.blob) || StringUtils.isNullOrEmpty((String)identityResponseObject.blob) && !StringUtils.isNullOrEmpty((String)this.blob)) {
                    requiresSharedStateUpdate = true;
                }
                if (identityResponseObject.hint != null && !identityResponseObject.hint.equals(this.locationHint) || StringUtils.isNullOrEmpty((String)identityResponseObject.hint) && !StringUtils.isNullOrEmpty((String)this.locationHint)) {
                    requiresSharedStateUpdate = true;
                }
                this.blob = identityResponseObject.blob;
                this.locationHint = identityResponseObject.hint;
                this.ttl = identityResponseObject.ttl;
                Log.debug((String)"Identity", (String)LOG_SOURCE, (String)"handleNetworkResponseMap : ECID Service returned (mid: %s, blob: %s, hint: %s, ttl: %d).", (Object[])new Object[]{this.mid, this.blob, this.locationHint, this.ttl});
            }
            catch (Exception ex) {
                Log.warning((String)"Identity", (String)LOG_SOURCE, (String)"handleNetworkResponseMap : Error parsing the response from ECID Service : (%s).", (Object[])new Object[]{ex});
            }
        }
        return requiresSharedStateUpdate;
    }

    private static boolean sameIdType(VisitorID visitorId1, VisitorID visitorId2) {
        if (visitorId1 == null || visitorId2 == null) {
            return false;
        }
        return visitorId1.getIdType() != null ? visitorId1.getIdType().equals(visitorId2.getIdType()) : visitorId2.getIdType() == null;
    }

    private void loadPrivacyStatusFromConfigurationState(Map<String, Object> configState) {
        String privacyString = DataReader.optString(configState, (String)"global.privacy", (String)IdentityConstants.Defaults.DEFAULT_MOBILE_PRIVACY.getValue());
        this.privacyStatus = MobilePrivacyStatus.fromString((String)privacyString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearIdentifiers() {
        this.mid = null;
        this.advertisingIdentifier = null;
        this.blob = null;
        this.locationHint = null;
        this.customerIds = null;
        this.pushIdentifier = null;
        if (this.namedCollection != null) {
            this.namedCollection.remove("ADOBEMOBILE_AID_SYNCED");
            this.namedCollection.remove("ADOBEMOBILE_ANALYTICS_PUSH_SYNC");
            Object object = pushEnabledMutex;
            synchronized (object) {
                this.namedCollection.remove("ADOBEMOBILE_PUSH_ENABLED");
            }
        }
    }

    @VisibleForTesting
    String getMid() {
        return this.mid;
    }

    @VisibleForTesting
    void setLastSync(long lastSync) {
        this.lastSync = lastSync;
    }

    @VisibleForTesting
    long getLastSync() {
        return this.lastSync;
    }

    @VisibleForTesting
    void setMid(String mid) {
        this.mid = mid;
    }

    @VisibleForTesting
    void setHasSynced(boolean hasSynced) {
        this.hasSynced = hasSynced;
    }

    @VisibleForTesting
    void setPrivacyStatus(MobilePrivacyStatus privacyStatus) {
        this.privacyStatus = privacyStatus;
    }

    @VisibleForTesting
    void setBlob(String blob) {
        this.blob = blob;
    }

    @VisibleForTesting
    void setLocationHint(String locationHint) {
        this.locationHint = locationHint;
    }
}

