/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.adobe.marketing.mobile.AdobeCallback;
import com.adobe.marketing.mobile.AdobeCallbackWithError;
import com.adobe.marketing.mobile.AdobeError;
import com.adobe.marketing.mobile.Event;
import com.adobe.marketing.mobile.Extension;
import com.adobe.marketing.mobile.MobileCore;
import com.adobe.marketing.mobile.VisitorID;
import com.adobe.marketing.mobile.identity.IdentityExtension;
import com.adobe.marketing.mobile.internal.util.VisitorIDSerializer;
import com.adobe.marketing.mobile.services.Log;
import com.adobe.marketing.mobile.util.DataReader;
import com.adobe.marketing.mobile.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Identity {
    private static final String CLASS_NAME = "Identity";
    private static final String EXTENSION_VERSION = "3.0.2";
    private static final String REQUEST_IDENTITY_EVENT_NAME = "IdentityRequestIdentity";
    private static final int PUBLIC_API_TIME_OUT_MILLISECOND = 500;
    private static final String LOG_TAG = "Identity";
    public static final Class<? extends Extension> EXTENSION = IdentityExtension.class;

    private Identity() {
    }

    public static String extensionVersion() {
        return EXTENSION_VERSION;
    }

    public static void syncIdentifiers(@NonNull Map<String, String> identifiers) {
        Identity.syncIdentifiers(identifiers, VisitorID.AuthenticationState.UNKNOWN);
    }

    public static void syncIdentifiers(@NonNull Map<String, String> identifiers, @NonNull VisitorID.AuthenticationState authenticationState) {
        if (identifiers == null || identifiers.isEmpty()) {
            Log.warning((String)"Identity", (String)"Identity", (String)"syncIdentifiers(ids, state) : Unable to sync Visitor identifiers, provided map was null or empty", (Object[])new Object[0]);
            return;
        }
        Log.trace((String)"Identity", (String)"Identity", (String)"syncIdentifiers(ids, state) : Processing a request to sync Visitor identifiers.", (Object[])new Object[0]);
        HashMap<String, Object> syncMap = new HashMap<String, Object>();
        syncMap.put("visitoridentifiers", identifiers);
        syncMap.put("authenticationstate", authenticationState.getValue());
        syncMap.put("forcesync", false);
        syncMap.put("issyncevent", true);
        Event event = new Event.Builder(REQUEST_IDENTITY_EVENT_NAME, "com.adobe.eventType.identity", "com.adobe.eventSource.requestIdentity").setEventData(syncMap).build();
        MobileCore.dispatchEvent((Event)event);
        Log.trace((String)"Identity", (String)"Identity", (String)"dispatchIDSyncEvent : Identity Sync event has been added to event hub : %s", (Object[])new Object[]{event});
    }

    public static void syncIdentifier(@NonNull String identifierType, @Nullable String identifier, @NonNull VisitorID.AuthenticationState authenticationState) {
        if (StringUtils.isNullOrEmpty((String)identifierType)) {
            Log.warning((String)"Identity", (String)"Identity", (String)"syncIdentifier : Unable to sync Visitor identifier due to null or empty identifierType", (Object[])new Object[0]);
            return;
        }
        Log.trace((String)"Identity", (String)"Identity", (String)"syncIdentifier : Processing a request to sync Visitor identifier.", (Object[])new Object[0]);
        HashMap<String, String> identifiers = new HashMap<String, String>();
        identifiers.put(identifierType, identifier);
        Identity.syncIdentifiers(identifiers, authenticationState);
    }

    public static void appendVisitorInfoForURL(@NonNull String baseURL, @NonNull AdobeCallback<String> callback) {
        if (callback == null) {
            Log.warning((String)"Identity", (String)"Identity", (String)"appendVisitorInfoForURL : callback shouldn't be null.", (Object[])new Object[0]);
            return;
        }
        Log.trace((String)"Identity", (String)"Identity", (String)"appendVisitorInfoForURL : Processing a request to append Adobe visitor data to a URL string.", (Object[])new Object[0]);
        HashMap<String, Object> eventData = new HashMap<String, Object>();
        eventData.put("baseurl", baseURL);
        Identity.createIdentityRequestWithCallbacks(eventData, callback, (AdobeCallback<Event>)((AdobeCallback)event -> {
            String url = DataReader.optString((Map)event.getEventData(), (String)"updatedurl", (String)"");
            callback.call((Object)url);
        }));
    }

    public static void getUrlVariables(@NonNull AdobeCallback<String> callback) {
        if (callback == null) {
            Log.warning((String)"Identity", (String)"Identity", (String)"getUrlVariables : callback shouldn't be null.", (Object[])new Object[0]);
            return;
        }
        Log.trace((String)"Identity", (String)"Identity", (String)"getUrlVariables : Processing the request to get Visitor information as URL query parameters.", (Object[])new Object[0]);
        HashMap<String, Object> eventData = new HashMap<String, Object>();
        eventData.put("urlvariables", true);
        Identity.createIdentityRequestWithCallbacks(eventData, callback, (AdobeCallback<Event>)((AdobeCallback)event -> {
            String url = DataReader.optString((Map)event.getEventData(), (String)"urlvariables", (String)"");
            callback.call((Object)url);
        }));
    }

    public static void getIdentifiers(@NonNull AdobeCallback<List<VisitorID>> callback) {
        if (callback == null) {
            Log.warning((String)"Identity", (String)"Identity", (String)"getIdentifiers : callback shouldn't be null.", (Object[])new Object[0]);
            return;
        }
        Log.trace((String)"Identity", (String)"Identity", (String)"getIdentifiers : Processing a request to get all customer identifiers.", (Object[])new Object[0]);
        Identity.createIdentityRequestWithCallbacks(null, callback, (AdobeCallback<Event>)((AdobeCallback)event -> {
            List data = DataReader.optTypedList(Map.class, (Map)event.getEventData(), (String)"visitoridslist", new ArrayList());
            List list = VisitorIDSerializer.convertToVisitorIds((List)data);
            callback.call((Object)list);
        }));
    }

    public static void getExperienceCloudId(@NonNull AdobeCallback<String> callback) {
        if (callback == null) {
            Log.warning((String)"Identity", (String)"Identity", (String)"getIdentifiers : callback shouldn't be null.", (Object[])new Object[0]);
            return;
        }
        Log.trace((String)"Identity", (String)"Identity", (String)"getExperienceCloudId : Processing the request to get ECID.", (Object[])new Object[0]);
        Identity.createIdentityRequestWithCallbacks(null, callback, (AdobeCallback<Event>)((AdobeCallback)event -> {
            String mid = DataReader.optString((Map)event.getEventData(), (String)"mid", (String)"");
            callback.call((Object)mid);
        }));
    }

    private static <T> void createIdentityRequestWithCallbacks(Map<String, Object> eventData, final AdobeCallback<T> errorCallback, final @NonNull AdobeCallback<Event> callback) {
        Event event = eventData == null ? new Event.Builder(REQUEST_IDENTITY_EVENT_NAME, "com.adobe.eventType.identity", "com.adobe.eventSource.requestIdentity").build() : new Event.Builder(REQUEST_IDENTITY_EVENT_NAME, "com.adobe.eventType.identity", "com.adobe.eventSource.requestIdentity").setEventData(eventData).build();
        MobileCore.dispatchEventWithResponseCallback((Event)event, (long)500L, (AdobeCallbackWithError)new AdobeCallbackWithError<Event>(){

            public void fail(AdobeError error) {
                if (errorCallback instanceof AdobeCallbackWithError) {
                    AdobeCallbackWithError adobeCallbackWithError = (AdobeCallbackWithError)errorCallback;
                    adobeCallbackWithError.fail(error);
                }
            }

            public void call(Event e) {
                callback.call((Object)e);
            }
        });
        Log.trace((String)"Identity", (String)"Identity", (String)"createIdentityRequestWithOneTimeCallbackWithCallbackParam : Identity request event has been added to the event hub : %s", (Object[])new Object[]{event});
    }

    private static final class IdentityEventDataKeys {
        public static final String VISITOR_ID_MID = "mid";
        public static final String VISITOR_IDS_LIST = "visitoridslist";
        public static final String UPDATED_URL = "updatedurl";
        public static final String URL_VARIABLES = "urlvariables";
        public static final String BASE_URL = "baseurl";
        public static final String FORCE_SYNC = "forcesync";
        public static final String IDENTIFIERS = "visitoridentifiers";
        public static final String IS_SYNC_EVENT = "issyncevent";
        public static final String AUTHENTICATION_STATE = "authenticationstate";

        private IdentityEventDataKeys() {
        }
    }
}

