/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.campaignclassic.internal;

import androidx.annotation.VisibleForTesting;
import com.adobe.marketing.mobile.Event;
import com.adobe.marketing.mobile.ExtensionApi;
import com.adobe.marketing.mobile.MobilePrivacyStatus;
import com.adobe.marketing.mobile.campaignclassic.internal.CampaignClassicConfiguration;
import com.adobe.marketing.mobile.campaignclassic.internal.EventExtensionsKt;
import com.adobe.marketing.mobile.services.HttpConnecting;
import com.adobe.marketing.mobile.services.HttpMethod;
import com.adobe.marketing.mobile.services.Log;
import com.adobe.marketing.mobile.services.NetworkRequest;
import com.adobe.marketing.mobile.services.Networking;
import com.adobe.marketing.mobile.services.ServiceProvider;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0018\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\f\u0010\u0015\u001a\u00020\u0016*\u00020\u0010H\u0002J\f\u0010\u0017\u001a\u00020\u0016*\u00020\u0010H\u0002J\f\u0010\u0018\u001a\u00020\u0016*\u00020\u0010H\u0002R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/adobe/marketing/mobile/campaignclassic/internal/TrackRequestManager;", "", "extensionApi", "Lcom/adobe/marketing/mobile/ExtensionApi;", "(Lcom/adobe/marketing/mobile/ExtensionApi;)V", "networkService", "Lcom/adobe/marketing/mobile/services/Networking;", "(Lcom/adobe/marketing/mobile/ExtensionApi;Lcom/adobe/marketing/mobile/services/Networking;)V", "UUID_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "handleTrackRequest", "", "event", "Lcom/adobe/marketing/mobile/Event;", "tagId", "", "sendTrackingRequest", "trackUrl", "requestTimeout", "", "isDigitsOnly", "", "isNegative32BitDecimal", "isValidUUID", "Companion", "campaignclassic_phoneRelease"})
@SourceDebugExtension(value={"SMAP\nTrackRequestManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TrackRequestManager.kt\ncom/adobe/marketing/mobile/campaignclassic/internal/TrackRequestManager\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,227:1\n1064#2,2:228\n*S KotlinDebug\n*F\n+ 1 TrackRequestManager.kt\ncom/adobe/marketing/mobile/campaignclassic/internal/TrackRequestManager\n*L\n224#1:228,2\n*E\n"})
public final class TrackRequestManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final Pattern UUID_PATTERN;
    @NotNull
    private final ExtensionApi extensionApi;
    @Nullable
    private final Networking networkService;
    @NotNull
    private static final String SELF_TAG = "TrackRequestManager";

    public TrackRequestManager(@NotNull ExtensionApi extensionApi) {
        Intrinsics.checkNotNullParameter((Object)extensionApi, (String)"extensionApi");
        this.UUID_PATTERN = Pattern.compile("^(?i)[0-9a-f]{8}-([0-9a-f]{4}-){3}[0-9a-f]{12}$");
        this.extensionApi = extensionApi;
        this.networkService = ServiceProvider.getInstance().getNetworkService();
    }

    @VisibleForTesting
    public TrackRequestManager(@NotNull ExtensionApi extensionApi, @Nullable Networking networkService) {
        Intrinsics.checkNotNullParameter((Object)extensionApi, (String)"extensionApi");
        this.UUID_PATTERN = Pattern.compile("^(?i)[0-9a-f]{8}-([0-9a-f]{4}-){3}[0-9a-f]{12}$");
        this.extensionApi = extensionApi;
        this.networkService = networkService;
    }

    public final void handleTrackRequest(@NotNull Event event, @NotNull String tagId) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)tagId, (String)"tagId");
        CampaignClassicConfiguration configData = new CampaignClassicConfiguration(event, this.extensionApi);
        if (configData.getPrivacyStatus() != MobilePrivacyStatus.OPT_IN) {
            Log.debug((String)"CampaignClassicExtension", (String)SELF_TAG, (String)"handleTrackRequest - Failed to process TrackNotification request,MobilePrivacyStatus is not optedIn.", (Object[])new Object[0]);
            return;
        }
        String string = configData.getTrackingServer();
        if (string == null) {
            TrackRequestManager $this$handleTrackRequest_u24lambda_u240 = this;
            boolean bl = false;
            Log.debug((String)"CampaignClassicExtension", (String)SELF_TAG, (String)"handleTrackRequest - Failed to process TrackNotification request, Configuration not available.", (Object[])new Object[0]);
            return;
        }
        String trackingServer = string;
        String string2 = EventExtensionsKt.getDeliveryId(event);
        if (string2 == null) {
            TrackRequestManager $this$handleTrackRequest_u24lambda_u241 = this;
            boolean bl = false;
            Log.debug((String)"CampaignClassicExtension", (String)SELF_TAG, (String)"handleTrackRequest - Failed to process TrackNotification request,trackingInfo deliveryId is null (missing key `_dId` from tracking Info) or empty.", (Object[])new Object[0]);
            return;
        }
        String deliveryId = string2;
        String string3 = EventExtensionsKt.getMessageId(event);
        if (string3 == null) {
            TrackRequestManager $this$handleTrackRequest_u24lambda_u242 = this;
            boolean bl = false;
            Log.debug((String)"CampaignClassicExtension", (String)SELF_TAG, (String)"handleTrackRequest - Failed to process TrackNotification request,trackingInfo messageId is null (missing key `_mId` from tracking Info) or empty.", (Object[])new Object[0]);
            return;
        }
        String messageId = string3;
        if (!this.isValidUUID(messageId)) {
            try {
                if (this.isNegative32BitDecimal(messageId)) {
                    objectArray = new Object[]{Integer.parseInt(messageId)};
                    String string4 = String.format("%x", objectArray);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(\"%x\", messageId.toInt())");
                    messageId = string4;
                } else {
                    objectArray = new Object[]{Long.parseLong(messageId)};
                    String string5 = String.format("%x", objectArray);
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(\"%x\", messageId.toLong())");
                    messageId = string5;
                }
            }
            catch (NumberFormatException ex) {
                Log.debug((String)"CampaignClassicExtension", (String)SELF_TAG, (String)("handleTrackRequest - Failed to process TrackNotification request,messageId " + messageId + " could not be parsed as a UUID or a decimal (integer).Error " + ex.getMessage()), (Object[])new Object[0]);
                return;
            }
        }
        objectArray = new Object[]{trackingServer, messageId, deliveryId, tagId};
        String trackUrl = String.format("https://%s/r/?id=h%s,%s,%s", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)trackUrl, (String)"trackUrl");
        this.sendTrackingRequest(trackUrl, configData.getTimeout());
    }

    private final void sendTrackingRequest(String trackUrl, int requestTimeout) {
        if (this.networkService == null) {
            Log.debug((String)"CampaignClassicExtension", (String)SELF_TAG, (String)"sendTrackingRequest - Cannot send request, Network service is not available", (Object[])new Object[0]);
            return;
        }
        NetworkRequest networkRequest = new NetworkRequest(trackUrl, HttpMethod.GET, null, null, requestTimeout, requestTimeout);
        Log.trace((String)"CampaignClassicExtension", (String)SELF_TAG, (String)("sendTrackingRequest - TrackingNotification network call initiated with URL :  " + trackUrl + '.'), (Object[])new Object[0]);
        this.networkService.connectAsync(networkRequest, TrackRequestManager::sendTrackingRequest$lambda$3);
    }

    private final boolean isValidUUID(String $this$isValidUUID) {
        return this.UUID_PATTERN.matcher($this$isValidUUID).matches();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isNegative32BitDecimal(String $this$isNegative32BitDecimal) {
        if (!StringsKt.startsWith$default((String)$this$isNegative32BitDecimal, (String)"-", (boolean)false, (int)2, null)) return false;
        String string = $this$isNegative32BitDecimal.substring(1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
        if (!this.isDigitsOnly(string)) return false;
        if (StringsKt.toIntOrNull((String)$this$isNegative32BitDecimal) == null) return false;
        return true;
    }

    private final boolean isDigitsOnly(String $this$isDigitsOnly) {
        boolean bl;
        block1: {
            CharSequence $this$all$iv = $this$isDigitsOnly;
            boolean $i$f$all = false;
            for (int i = 0; i < $this$all$iv.length(); ++i) {
                char element$iv;
                char it = element$iv = $this$all$iv.charAt(i);
                boolean bl2 = false;
                if (Character.isDigit(it)) continue;
                bl = false;
                break block1;
            }
            bl = true;
        }
        return bl;
    }

    private static final void sendTrackingRequest$lambda$3(HttpConnecting it) {
        if (it != null) {
            if (it.getResponseCode() == 200) {
                Log.trace((String)"CampaignClassicExtension", (String)SELF_TAG, (String)("sendTrackingRequest - Connection successful " + it.getResponseMessage() + '.'), (Object[])new Object[0]);
            } else {
                Log.warning((String)"CampaignClassicExtension", (String)SELF_TAG, (String)("sendTrackingRequest - Connection failed " + it.getResponseMessage() + '.'), (Object[])new Object[0]);
            }
            it.close();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/adobe/marketing/mobile/campaignclassic/internal/TrackRequestManager$Companion;", "", "()V", "SELF_TAG", "", "campaignclassic_phoneRelease"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

