/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.campaignclassic.internal;

import androidx.annotation.VisibleForTesting;
import com.adobe.marketing.mobile.Event;
import com.adobe.marketing.mobile.ExtensionApi;
import com.adobe.marketing.mobile.MobilePrivacyStatus;
import com.adobe.marketing.mobile.campaignclassic.internal.CampaignClassicConfiguration;
import com.adobe.marketing.mobile.campaignclassic.internal.CampaignClassicMapSerializer;
import com.adobe.marketing.mobile.campaignclassic.internal.EventExtensionsKt;
import com.adobe.marketing.mobile.services.DataStoring;
import com.adobe.marketing.mobile.services.DeviceInforming;
import com.adobe.marketing.mobile.services.HttpConnecting;
import com.adobe.marketing.mobile.services.HttpMethod;
import com.adobe.marketing.mobile.services.Log;
import com.adobe.marketing.mobile.services.NamedCollection;
import com.adobe.marketing.mobile.services.NetworkRequest;
import com.adobe.marketing.mobile.services.Networking;
import com.adobe.marketing.mobile.services.ServiceProvider;
import com.adobe.marketing.mobile.util.UrlUtils;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\b\u0000\u0018\u0000 *2\u00020\u0001:\u0001*B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B-\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\u001c\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0012\u0010\u0015\u001a\u00020\u000e2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u000eH\u0002J\u0012\u0010\u001a\u001a\u00020\u00142\b\u0010\u001b\u001a\u0004\u0018\u00010\u000eH\u0002J(\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u000eH\u0002J\u000e\u0010!\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020#J*\u0010$\u001a\u00020\u00112\u0006\u0010%\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010\u000eH\u0002J\u0012\u0010)\u001a\u00020\u00112\b\u0010(\u001a\u0004\u0018\u00010\u000eH\u0002R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/adobe/marketing/mobile/campaignclassic/internal/RegistrationManager;", "", "extensionApi", "Lcom/adobe/marketing/mobile/ExtensionApi;", "(Lcom/adobe/marketing/mobile/ExtensionApi;)V", "deviceInfoService", "Lcom/adobe/marketing/mobile/services/DeviceInforming;", "dataStore", "Lcom/adobe/marketing/mobile/services/NamedCollection;", "networkService", "Lcom/adobe/marketing/mobile/services/Networking;", "(Lcom/adobe/marketing/mobile/ExtensionApi;Lcom/adobe/marketing/mobile/services/DeviceInforming;Lcom/adobe/marketing/mobile/services/NamedCollection;Lcom/adobe/marketing/mobile/services/Networking;)V", "buildHeaders", "", "", "payload", "clearRegistrationData", "", "dispatchRegistrationStatus", "registrationStatus", "", "formatLocale", "locale", "Ljava/util/Locale;", "getSha256Hash", "input", "hasRegistrationInfoChanged", "registrationInfoHash", "prepareRegistrationParams", "registrationToken", "integrationKey", "userKey", "additionalParameters", "registerDevice", "event", "Lcom/adobe/marketing/mobile/Event;", "sendRegistrationRequest", "requestUrl", "requestTimeout", "", "registrationHash", "updateDataStoreWithRegistrationInfo", "Companion", "campaignclassic_phoneRelease"})
public final class RegistrationManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExtensionApi extensionApi;
    @Nullable
    private final DeviceInforming deviceInfoService;
    @Nullable
    private final NamedCollection dataStore;
    @Nullable
    private final Networking networkService;
    @NotNull
    private static final String SELF_TAG = "RegistrationManager";

    public RegistrationManager(@NotNull ExtensionApi extensionApi) {
        Intrinsics.checkNotNullParameter((Object)extensionApi, (String)"extensionApi");
        this.extensionApi = extensionApi;
        this.deviceInfoService = ServiceProvider.getInstance().getDeviceInfoService();
        DataStoring dataStoring = ServiceProvider.getInstance().getDataStoreService();
        this.dataStore = dataStoring != null ? dataStoring.getNamedCollection("ADOBEMOBILE_CAMPAIGNCLASSIC") : null;
        this.networkService = ServiceProvider.getInstance().getNetworkService();
    }

    @VisibleForTesting
    public RegistrationManager(@NotNull ExtensionApi extensionApi, @Nullable DeviceInforming deviceInfoService, @Nullable NamedCollection dataStore, @Nullable Networking networkService) {
        Intrinsics.checkNotNullParameter((Object)extensionApi, (String)"extensionApi");
        this.extensionApi = extensionApi;
        this.deviceInfoService = deviceInfoService;
        this.dataStore = dataStore;
        this.networkService = networkService;
    }

    public final void registerDevice(@NotNull Event event) {
        String string;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        String string2 = EventExtensionsKt.getDeviceToken(event);
        if (string2 == null) {
            RegistrationManager $this$registerDevice_u24lambda_u240 = this;
            boolean bl = false;
            Log.debug((String)"CampaignClassicExtension", (String)SELF_TAG, (String)"registerDevice - Failed to process device registration request,device token is not available.", (Object[])new Object[0]);
            $this$registerDevice_u24lambda_u240.dispatchRegistrationStatus(false);
            return;
        }
        String registrationToken = string2;
        CampaignClassicConfiguration configData = new CampaignClassicConfiguration(event, this.extensionApi);
        if (configData.getPrivacyStatus() != MobilePrivacyStatus.OPT_IN) {
            Log.debug((String)"CampaignClassicExtension", (String)SELF_TAG, (String)"registerDevice - Failed to process device registration request,MobilePrivacyStatus is not optedIn.", (Object[])new Object[0]);
            this.dispatchRegistrationStatus(false);
            return;
        }
        String string3 = configData.getMarketingServer();
        if (string3 == null) {
            RegistrationManager $this$registerDevice_u24lambda_u241 = this;
            boolean bl = false;
            Log.debug((String)"CampaignClassicExtension", (String)SELF_TAG, (String)"registerDevice - Failed to process device registration request,Marketing server is not configured.", (Object[])new Object[0]);
            $this$registerDevice_u24lambda_u241.dispatchRegistrationStatus(false);
            return;
        }
        String marketingServer = string3;
        String string4 = configData.getIntegrationKey();
        if (string4 == null) {
            RegistrationManager $this$registerDevice_u24lambda_u242 = this;
            boolean bl = false;
            Log.debug((String)"CampaignClassicExtension", (String)SELF_TAG, (String)"registerDevice - Failed to process device registration request,Integration key is not configured.", (Object[])new Object[0]);
            $this$registerDevice_u24lambda_u242.dispatchRegistrationStatus(false);
            return;
        }
        String integrationKey = string4;
        String string5 = EventExtensionsKt.getUserKey(event);
        if (string5 == null) {
            string5 = "";
        }
        String userKey = string5;
        String additionalParametersString = CampaignClassicMapSerializer.serializeMap(EventExtensionsKt.getAdditionalParameters(event));
        DeviceInforming deviceInforming = this.deviceInfoService;
        String deviceUniqueId = deviceInforming != null ? deviceInforming.getDeviceUniqueId() : null;
        String string6 = deviceUniqueId != null ? new UUID(deviceUniqueId.hashCode(), deviceUniqueId.hashCode()).toString() : "";
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"if (deviceUniqueId != nu\u2026\n            \"\"\n        }");
        String deviceUuid = string6;
        try {
            string = this.getSha256Hash(registrationToken + userKey + additionalParametersString.hashCode() + deviceUuid);
        }
        catch (Exception ex) {
            Log.debug((String)"CampaignClassicExtension", (String)SELF_TAG, (String)("registerDevice - Failed to process device registration request,Cannot create registration info hash. Error " + ex + ".message"), (Object[])new Object[0]);
            string = null;
        }
        String registrationInfoHash = string;
        if (!this.hasRegistrationInfoChanged(registrationInfoHash)) {
            Log.debug((String)"CampaignClassicExtension", (String)SELF_TAG, (String)"registerDevice - Not sending device registration request,there is no change in registration info.", (Object[])new Object[0]);
            this.dispatchRegistrationStatus(true);
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)additionalParametersString, (String)"additionalParametersString");
        String payload = this.prepareRegistrationParams(registrationToken, integrationKey, userKey, additionalParametersString);
        String string7 = "https://%s/nms/mobile/1/registerAndroid.jssp";
        Object[] objectArray = new Object[]{marketingServer};
        String string8 = String.format(string7, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"format(format, *args)");
        String registerURL = string8;
        this.sendRegistrationRequest(registerURL, payload, configData.getTimeout(), registrationInfoHash);
    }

    public final void clearRegistrationData() {
        this.updateDataStoreWithRegistrationInfo(null);
    }

    private final boolean hasRegistrationInfoChanged(String registrationInfoHash) {
        if (this.dataStore == null) {
            Log.debug((String)"CampaignClassicExtension", (String)SELF_TAG, (String)"hasRegistrationInfoChanged - Cannot get registration info, Data store is not available.", (Object[])new Object[0]);
            return true;
        }
        String storedRegistrationInfoHash = this.dataStore.getString("ADOBEMOBILE_STOREDDEFAULTS_TOKENHASH", null);
        if (Intrinsics.areEqual((Object)registrationInfoHash, (Object)storedRegistrationInfoHash)) {
            Log.trace((String)"CampaignClassicExtension", (String)SELF_TAG, (String)"hasRegistrationInfoChanged - Registration information has not changed in Data store.", (Object[])new Object[0]);
            return false;
        }
        return true;
    }

    private final String prepareRegistrationParams(String registrationToken, String integrationKey, String userKey, String additionalParameters) {
        Object[] objectArray = new Object[12];
        objectArray[0] = UrlUtils.urlEncode((String)registrationToken);
        objectArray[1] = UrlUtils.urlEncode((String)integrationKey);
        objectArray[2] = UrlUtils.urlEncode((String)userKey);
        DeviceInforming deviceInforming = this.deviceInfoService;
        String string = deviceInforming != null ? deviceInforming.getDeviceUniqueId() : null;
        if (string == null) {
            string = "";
        }
        objectArray[3] = UrlUtils.urlEncode((String)string);
        DeviceInforming deviceInforming2 = this.deviceInfoService;
        String string2 = deviceInforming2 != null ? deviceInforming2.getDevice() : null;
        if (string2 == null) {
            string2 = "";
        }
        objectArray[4] = UrlUtils.urlEncode((String)string2);
        DeviceInforming deviceInforming3 = this.deviceInfoService;
        String string3 = deviceInforming3 != null ? deviceInforming3.getDeviceName() : null;
        if (string3 == null) {
            string3 = "";
        }
        objectArray[5] = UrlUtils.urlEncode((String)string3);
        DeviceInforming deviceInforming4 = this.deviceInfoService;
        String string4 = deviceInforming4 != null ? deviceInforming4.getDeviceBrand() : null;
        if (string4 == null) {
            string4 = "";
        }
        objectArray[6] = UrlUtils.urlEncode((String)string4);
        DeviceInforming deviceInforming5 = this.deviceInfoService;
        String string5 = deviceInforming5 != null ? deviceInforming5.getDeviceManufacturer() : null;
        if (string5 == null) {
            string5 = "";
        }
        objectArray[7] = UrlUtils.urlEncode((String)string5);
        objectArray[8] = UrlUtils.urlEncode((String)"android");
        DeviceInforming deviceInforming6 = this.deviceInfoService;
        DeviceInforming deviceInforming7 = this.deviceInfoService;
        objectArray[9] = UrlUtils.urlEncode((String)((deviceInforming6 != null ? deviceInforming6.getOperatingSystemName() : null) + ' ' + (deviceInforming7 != null ? deviceInforming7.getOperatingSystemVersion() : null)));
        DeviceInforming deviceInforming8 = this.deviceInfoService;
        objectArray[10] = UrlUtils.urlEncode((String)this.formatLocale(deviceInforming8 != null ? deviceInforming8.getActiveLocale() : null));
        objectArray[11] = UrlUtils.urlEncode((String)additionalParameters);
        String string6 = String.format("registrationToken=%s&mobileAppUuid=%s&userKey=%s&deviceImei=%s&deviceName=%s&deviceModel=%s&deviceBrand=%s&deviceManufacturer=%s&osName=%s&osVersion=%s&osLanguage=%s&additionalParams=%s", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"format(\n            Camp\u2026onalParameters)\n        )");
        return string6;
    }

    private final void sendRegistrationRequest(String requestUrl, String payload, int requestTimeout, String registrationHash) {
        if (this.networkService == null) {
            Log.debug((String)"CampaignClassicExtension", (String)SELF_TAG, (String)"sendRegistrationRequest - Cannot send request, Network service is not available.", (Object[])new Object[0]);
            this.dispatchRegistrationStatus(false);
            return;
        }
        Map<String, String> headers = this.buildHeaders(payload);
        String string = payload;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        byte[] postBody = byArray;
        NetworkRequest networkRequest = new NetworkRequest(requestUrl, HttpMethod.POST, postBody, headers, requestTimeout, requestTimeout);
        Log.trace((String)"CampaignClassicExtension", (String)SELF_TAG, (String)("sendRegistrationRequest - Registration request was sent with url " + requestUrl), (Object[])new Object[0]);
        this.networkService.connectAsync(networkRequest, arg_0 -> RegistrationManager.sendRegistrationRequest$lambda$3(this, registrationHash, arg_0));
    }

    private final void dispatchRegistrationStatus(boolean registrationStatus) {
        this.extensionApi.dispatch(new Event.Builder("Device Registration Status", "com.adobe.eventType.campaign", "com.adobe.eventSource.responseContent").setEventData(MapsKt.mapOf((Pair)TuplesKt.to((Object)"registrationstatus", (Object)registrationStatus))).build());
    }

    private final Map<String, String> buildHeaders(String payload) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"Content-Type", (Object)"application/x-www-form-urlencoded;charset=UTF-8"), TuplesKt.to((Object)"Content-Length", (Object)String.valueOf(payload.length()))};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    private final void updateDataStoreWithRegistrationInfo(String registrationHash) {
        if (this.dataStore == null) {
            Log.debug((String)"CampaignClassicExtension", (String)SELF_TAG, (String)"updateDataStoreWithRegistrationInfo - Cannot set registration info, data store is not available.", (Object[])new Object[0]);
            return;
        }
        CharSequence charSequence = registrationHash;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            this.dataStore.setString("ADOBEMOBILE_STOREDDEFAULTS_TOKENHASH", registrationHash);
        } else {
            this.dataStore.remove("ADOBEMOBILE_STOREDDEFAULTS_TOKENHASH");
        }
    }

    private final String formatLocale(Locale locale) {
        Object object = locale;
        if (object == null || (object = ((Locale)object).toString()) == null || (object = StringsKt.replace$default((String)object, (char)'_', (char)'-', (boolean)false, (int)4, null)) == null) {
            object = "";
        }
        return object;
    }

    private final String getSha256Hash(String input) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        Charset charset = Charset.forName("iso-8859-1");
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(charsetName)");
        byte[] byArray = input.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        byte[] textBytes = byArray;
        md.update(textBytes, 0, textBytes.length);
        StringBuilder sb = new StringBuilder();
        byte[] byArray2 = md.digest();
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"md.digest()");
        for (byte b : byArray2) {
            Object[] objectArray = new Object[]{b};
            sb.append(String.format("%02x", objectArray));
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    private static final void sendRegistrationRequest$lambda$3(RegistrationManager this$0, String $registrationHash, HttpConnecting it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (it == null) {
            Log.warning((String)"CampaignClassicExtension", (String)SELF_TAG, (String)"sendRegistrationRequest - Internet connection is not available. Registration request failed.", (Object[])new Object[0]);
            this$0.dispatchRegistrationStatus(false);
        } else {
            if (it.getResponseCode() == 200) {
                Log.debug((String)"CampaignClassicExtension", (String)SELF_TAG, (String)"sendRegistrationRequest - Registration successful.", (Object[])new Object[0]);
                this$0.dispatchRegistrationStatus(true);
                this$0.updateDataStoreWithRegistrationInfo($registrationHash);
            } else {
                Log.warning((String)"CampaignClassicExtension", (String)SELF_TAG, (String)("sendRegistrationRequest - Unsuccessful Registration request with connection status " + it.getResponseCode()), (Object[])new Object[0]);
                this$0.dispatchRegistrationStatus(false);
            }
            it.close();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/adobe/marketing/mobile/campaignclassic/internal/RegistrationManager$Companion;", "", "()V", "SELF_TAG", "", "campaignclassic_phoneRelease"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

