/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.campaignclassic.internal;

import androidx.annotation.VisibleForTesting;
import com.adobe.marketing.mobile.CampaignClassic;
import com.adobe.marketing.mobile.Event;
import com.adobe.marketing.mobile.Extension;
import com.adobe.marketing.mobile.ExtensionApi;
import com.adobe.marketing.mobile.MobilePrivacyStatus;
import com.adobe.marketing.mobile.SharedStateResolution;
import com.adobe.marketing.mobile.SharedStateResult;
import com.adobe.marketing.mobile.SharedStateStatus;
import com.adobe.marketing.mobile.campaignclassic.internal.CampaignClassicConfiguration;
import com.adobe.marketing.mobile.campaignclassic.internal.EventExtensionsKt;
import com.adobe.marketing.mobile.campaignclassic.internal.RegistrationManager;
import com.adobe.marketing.mobile.campaignclassic.internal.TrackRequestManager;
import com.adobe.marketing.mobile.services.Log;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u001f\b\u0011\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0014J\b\u0010\f\u001a\u00020\u000bH\u0014J\b\u0010\r\u001a\u00020\u000bH\u0014J\u0015\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u0012J\u0015\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u0014J\u0010\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u000bH\u0002J\b\u0010\u0018\u001a\u00020\u000fH\u0014J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/adobe/marketing/mobile/campaignclassic/internal/CampaignClassicExtension;", "Lcom/adobe/marketing/mobile/Extension;", "extensionApi", "Lcom/adobe/marketing/mobile/ExtensionApi;", "(Lcom/adobe/marketing/mobile/ExtensionApi;)V", "registrationManager", "Lcom/adobe/marketing/mobile/campaignclassic/internal/RegistrationManager;", "trackRequestManager", "Lcom/adobe/marketing/mobile/campaignclassic/internal/TrackRequestManager;", "(Lcom/adobe/marketing/mobile/ExtensionApi;Lcom/adobe/marketing/mobile/campaignclassic/internal/RegistrationManager;Lcom/adobe/marketing/mobile/campaignclassic/internal/TrackRequestManager;)V", "getFriendlyName", "", "getName", "getVersion", "handleCampaignRequestEvent", "", "event", "Lcom/adobe/marketing/mobile/Event;", "handleCampaignRequestEvent$campaignclassic_phoneRelease", "handleConfigurationResponseEvent", "handleConfigurationResponseEvent$campaignclassic_phoneRelease", "handleRegistrationRequest", "handleTrackRequest", "tagId", "onRegistered", "readyForEvent", "", "Companion", "campaignclassic_phoneRelease"})
public final class CampaignClassicExtension
extends Extension {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExtensionApi extensionApi;
    @NotNull
    private final RegistrationManager registrationManager;
    @NotNull
    private final TrackRequestManager trackRequestManager;
    @NotNull
    private static final String SELF_TAG = "CampaignClassicExtension";

    public CampaignClassicExtension(@NotNull ExtensionApi extensionApi) {
        Intrinsics.checkNotNullParameter((Object)extensionApi, (String)"extensionApi");
        super(extensionApi);
        this.extensionApi = extensionApi;
        ExtensionApi extensionApi2 = this.getApi();
        Intrinsics.checkNotNullExpressionValue((Object)extensionApi2, (String)"api");
        this.registrationManager = new RegistrationManager(extensionApi2);
        ExtensionApi extensionApi3 = this.getApi();
        Intrinsics.checkNotNullExpressionValue((Object)extensionApi3, (String)"api");
        this.trackRequestManager = new TrackRequestManager(extensionApi3);
    }

    @VisibleForTesting
    public CampaignClassicExtension(@NotNull ExtensionApi extensionApi, @NotNull RegistrationManager registrationManager, @NotNull TrackRequestManager trackRequestManager) {
        Intrinsics.checkNotNullParameter((Object)extensionApi, (String)"extensionApi");
        Intrinsics.checkNotNullParameter((Object)registrationManager, (String)"registrationManager");
        Intrinsics.checkNotNullParameter((Object)trackRequestManager, (String)"trackRequestManager");
        super(extensionApi);
        this.extensionApi = extensionApi;
        this.registrationManager = registrationManager;
        this.trackRequestManager = trackRequestManager;
    }

    @NotNull
    protected String getName() {
        return "com.adobe.module.campaignclassic";
    }

    @NotNull
    protected String getVersion() {
        String string = CampaignClassic.extensionVersion();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"extensionVersion()");
        return string;
    }

    @NotNull
    protected String getFriendlyName() {
        return "CampaignClassic";
    }

    protected void onRegistered() {
        this.getApi().registerEventListener("com.adobe.eventType.campaign", "com.adobe.eventSource.requestContent", arg_0 -> CampaignClassicExtension.onRegistered$lambda$0(this, arg_0));
        this.getApi().registerEventListener("com.adobe.eventType.configuration", "com.adobe.eventSource.responseContent", arg_0 -> CampaignClassicExtension.onRegistered$lambda$1(this, arg_0));
    }

    public boolean readyForEvent(@NotNull Event event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        SharedStateResult sharedStateResult = this.getApi().getSharedState("com.adobe.module.configuration", event, false, SharedStateResolution.ANY);
        return (sharedStateResult != null ? sharedStateResult.getStatus() : null) == SharedStateStatus.SET;
    }

    public final void handleConfigurationResponseEvent$campaignclassic_phoneRelease(@NotNull Event event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        CampaignClassicConfiguration configData = new CampaignClassicConfiguration(event, this.extensionApi);
        if (configData.getPrivacyStatus() == MobilePrivacyStatus.OPT_OUT) {
            Log.debug((String)SELF_TAG, (String)SELF_TAG, (String)"handleConfigurationResponseEvent - Privacy status is opt out, clearing persisted registration info.", (Object[])new Object[0]);
            this.registrationManager.clearRegistrationData();
        }
    }

    public final void handleCampaignRequestEvent$campaignclassic_phoneRelease(@NotNull Event event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getEventData() == null || event.getEventData().isEmpty()) {
            Log.debug((String)SELF_TAG, (String)SELF_TAG, (String)"handleCampaignRequestEvent - Failed to process CAMPAIGN_CLASSIC REQUEST_CONTENT event(event.eventData was null or empty)", (Object[])new Object[0]);
            return;
        }
        if (EventExtensionsKt.isRegisterEvent(event)) {
            this.handleRegistrationRequest(event);
        } else if (EventExtensionsKt.isTrackReceiveEvent(event)) {
            this.handleTrackRequest(event, "1");
        } else if (EventExtensionsKt.isTrackClickEvent(event)) {
            this.handleTrackRequest(event, "2");
        }
    }

    private final void handleRegistrationRequest(Event event) {
        this.registrationManager.registerDevice(event);
    }

    private final void handleTrackRequest(Event event, String tagId) {
        this.trackRequestManager.handleTrackRequest(event, tagId);
    }

    private static final void onRegistered$lambda$0(CampaignClassicExtension this$0, Event it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.handleCampaignRequestEvent$campaignclassic_phoneRelease(it);
    }

    private static final void onRegistered$lambda$1(CampaignClassicExtension this$0, Event it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.handleConfigurationResponseEvent$campaignclassic_phoneRelease(it);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/adobe/marketing/mobile/campaignclassic/internal/CampaignClassicExtension$Companion;", "", "()V", "SELF_TAG", "", "campaignclassic_phoneRelease"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

