/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.core.app.NotificationCompat;
import androidx.core.app.NotificationManagerCompat;
import com.adobe.marketing.mobile.CampaignClassic;
import com.adobe.marketing.mobile.campaignclassic.internal.CampaignClassicPushBroadcastReceiver;
import com.adobe.marketing.mobile.campaignclassic.internal.CampaignClassicPushPayload;
import com.adobe.marketing.mobile.campaignclassic.internal.CampaignClassicPushTrackerActivity;
import com.adobe.marketing.mobile.notificationbuilder.NotificationBuilder;
import com.adobe.marketing.mobile.notificationbuilder.NotificationConstructionFailedException;
import com.adobe.marketing.mobile.services.Log;
import com.adobe.marketing.mobile.util.StringUtils;
import com.google.firebase.messaging.RemoteMessage;
import java.util.HashMap;
import java.util.Map;

public class AEPMessagingService {
    private static final String LOG_TAG = "CampaignClassicExtension";
    static final String SELF_TAG = "AEPMessagingService";
    static final String TRACK_INFO_KEY_MESSAGE_ID = "_mId";
    static final String TRACK_INFO_KEY_DELIVERY_ID = "_dId";

    public static boolean handleRemoteMessage(@NonNull Context context, @NonNull RemoteMessage remoteMessage) {
        CampaignClassicPushPayload payload;
        NotificationManagerCompat notificationManager = NotificationManagerCompat.from((Context)context);
        try {
            payload = new CampaignClassicPushPayload(remoteMessage);
            String tag = payload.getTag();
            if (StringUtils.isNullOrEmpty((String)tag)) {
                Log.warning((String)LOG_TAG, (String)SELF_TAG, (String)"Failed to create a push notification, the notification tag is null or empty.", (Object[])new Object[0]);
                return false;
            }
            NotificationCompat.Builder notificationBuilder = NotificationBuilder.constructNotificationBuilder(payload.getMessageData(), CampaignClassicPushTrackerActivity.class, CampaignClassicPushBroadcastReceiver.class);
            notificationManager.notify(tag.hashCode(), notificationBuilder.build());
        }
        catch (IllegalArgumentException exception) {
            Log.error((String)LOG_TAG, (String)SELF_TAG, (String)"Failed to create a push notification, an illegal argument exception occurred: %s", (Object[])new Object[]{exception.getLocalizedMessage()});
            return false;
        }
        catch (NotificationConstructionFailedException exception) {
            Log.error((String)LOG_TAG, (String)SELF_TAG, (String)"Failed to create a push notification, a notification construction failed exception occurred: %s", (Object[])new Object[]{exception.getLocalizedMessage()});
            return false;
        }
        AEPMessagingService.trackNotificationReceive(payload);
        return true;
    }

    private static void trackNotificationReceive(final CampaignClassicPushPayload payload) {
        Log.trace((String)LOG_TAG, (String)SELF_TAG, (String)"Received push payload is valid, sending notification receive track request.", (Object[])new Object[0]);
        HashMap<String, String> trackInfo = new HashMap<String, String>(){
            {
                this.put(AEPMessagingService.TRACK_INFO_KEY_MESSAGE_ID, payload.getMessageId());
                this.put(AEPMessagingService.TRACK_INFO_KEY_DELIVERY_ID, payload.getDeliveryId());
            }
        };
        CampaignClassic.trackNotificationReceive((Map<String, String>)trackInfo);
    }
}

