/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.campaign;

import android.content.Context;
import com.adobe.marketing.mobile.campaign.CampaignExtension;
import com.adobe.marketing.mobile.campaign.CampaignMessage;
import com.adobe.marketing.mobile.campaign.CampaignMessageRequiredFieldMissingException;
import com.adobe.marketing.mobile.campaign.LocalNotificationService;
import com.adobe.marketing.mobile.campaign.NotificationSetting;
import com.adobe.marketing.mobile.launch.rulesengine.RuleConsequence;
import com.adobe.marketing.mobile.services.Log;
import com.adobe.marketing.mobile.services.ServiceProvider;
import com.adobe.marketing.mobile.util.DataReader;
import com.adobe.marketing.mobile.util.StringUtils;
import java.util.Map;

class LocalNotificationMessage
extends CampaignMessage {
    private final String SELF_TAG = "LocalNotificationMessage";
    private static final long DEFAULT_DELAY = -1L;
    String content;
    String deeplink;
    String sound;
    Map<String, Object> userdata;
    int localNotificationDelay;
    long fireDate;
    String title;
    Context context = ServiceProvider.getInstance().getAppContextService().getApplicationContext();

    LocalNotificationMessage(CampaignExtension extension, RuleConsequence consequence) throws CampaignMessageRequiredFieldMissingException {
        super(extension, consequence);
        this.parseLocalNotificationMessagePayload(consequence);
    }

    private void parseLocalNotificationMessagePayload(RuleConsequence consequence) throws CampaignMessageRequiredFieldMissingException {
        if (consequence == null) {
            throw new CampaignMessageRequiredFieldMissingException("Message consequence is null.");
        }
        Map detailDictionary = consequence.getDetail();
        if (detailDictionary == null || detailDictionary.isEmpty()) {
            throw new CampaignMessageRequiredFieldMissingException("Message \"detail\" is missing.");
        }
        this.content = DataReader.optString((Map)detailDictionary, (String)"content", (String)"");
        if (StringUtils.isNullOrEmpty((String)this.content)) {
            throw new CampaignMessageRequiredFieldMissingException("Message \"content\" is empty.");
        }
        this.fireDate = DataReader.optLong((Map)detailDictionary, (String)"date", (long)-1L);
        if (this.fireDate <= 0L) {
            this.localNotificationDelay = DataReader.optInt((Map)detailDictionary, (String)"wait", (int)0);
        }
        this.deeplink = DataReader.optString((Map)detailDictionary, (String)"adb_deeplink", (String)"");
        if (StringUtils.isNullOrEmpty((String)this.deeplink)) {
            Log.trace((String)"Campaign", (String)"LocalNotificationMessage", (String)"parseLocalNotificationMessagePayload -  Tried to read \"adb_deeplink\" for local notification but found none. This is not a required field.", (Object[])new Object[0]);
        }
        this.userdata = DataReader.optTypedMap(Object.class, (Map)detailDictionary, (String)"userData", null);
        if (this.userdata == null || this.userdata.isEmpty()) {
            Log.trace((String)"Campaign", (String)"LocalNotificationMessage", (String)"parseLocalNotificationMessagePayload -  Tried to read \"userData\" for local notification but found none. This is not a required field.", (Object[])new Object[0]);
        }
        this.sound = DataReader.optString((Map)detailDictionary, (String)"sound", (String)"");
        if (StringUtils.isNullOrEmpty((String)this.sound)) {
            Log.trace((String)"Campaign", (String)"LocalNotificationMessage", (String)"parseLocalNotificationMessagePayload -  Tried to read \"sound\" for local notification but found none. This is not a required field.", (Object[])new Object[0]);
        }
        this.title = DataReader.optString((Map)detailDictionary, (String)"title", (String)"");
        if (StringUtils.isNullOrEmpty((String)this.title)) {
            Log.trace((String)"Campaign", (String)"LocalNotificationMessage", (String)"parseLocalNotificationMessagePayload -  Tried to read \"title\" for local notification but found none. This is not a required field.", (Object[])new Object[0]);
        }
    }

    @Override
    void showMessage() {
        this.triggered();
        if (this.userdata != null && !this.userdata.isEmpty() && this.userdata.containsKey("broadlogId") && this.userdata.containsKey("deliveryId")) {
            String broadlogId = DataReader.optString(this.userdata, (String)"broadlogId", (String)"");
            String deliveryId = DataReader.optString(this.userdata, (String)"deliveryId", (String)"");
            if (!StringUtils.isNullOrEmpty((String)broadlogId) || !StringUtils.isNullOrEmpty((String)deliveryId)) {
                Log.trace((String)"Campaign", (String)"LocalNotificationMessage", (String)"showMessage -  Calling dispatch message Info with broadlogId(%s) and deliveryId(%s) for the triggered message.", (Object[])new Object[]{broadlogId, deliveryId});
                this.callDispatchMessageInfo(broadlogId, deliveryId, "7");
            } else {
                Log.debug((String)"Campaign", (String)"LocalNotificationMessage", (String)"showMessage -  Cannot dispatch message info because broadlogid and/or deliveryid are empty.", (Object[])new Object[0]);
            }
        }
        NotificationSetting notificationSetting = NotificationSetting.build(this.messageId, this.content, this.fireDate, this.localNotificationDelay, this.deeplink, this.userdata, this.sound, this.title);
        Log.debug((String)"Campaign", (String)"LocalNotificationMessage", (String)"showMessage -  Scheduling local notification message with ID (%s)", (Object[])new Object[]{this.messageId});
        LocalNotificationService.showLocalNotification(this.context, notificationSetting);
    }

    @Override
    boolean shouldDownloadAssets() {
        return false;
    }
}

