/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.campaign;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.adobe.marketing.mobile.campaign.CampaignExtension;
import com.adobe.marketing.mobile.campaign.CampaignMessage;
import com.adobe.marketing.mobile.campaign.CampaignMessageRequiredFieldMissingException;
import com.adobe.marketing.mobile.campaign.Utils;
import com.adobe.marketing.mobile.launch.rulesengine.RuleConsequence;
import com.adobe.marketing.mobile.services.Log;
import com.adobe.marketing.mobile.services.ServiceProvider;
import com.adobe.marketing.mobile.services.caching.CacheEntry;
import com.adobe.marketing.mobile.services.caching.CacheExpiry;
import com.adobe.marketing.mobile.services.caching.CacheResult;
import com.adobe.marketing.mobile.services.caching.CacheService;
import com.adobe.marketing.mobile.services.ui.InAppMessage;
import com.adobe.marketing.mobile.services.ui.Presentable;
import com.adobe.marketing.mobile.services.ui.Presentation;
import com.adobe.marketing.mobile.services.ui.PresentationError;
import com.adobe.marketing.mobile.services.ui.PresentationUtilityProvider;
import com.adobe.marketing.mobile.services.ui.UIService;
import com.adobe.marketing.mobile.services.ui.message.InAppMessageEventListener;
import com.adobe.marketing.mobile.services.ui.message.InAppMessageSettings;
import com.adobe.marketing.mobile.util.DataReader;
import com.adobe.marketing.mobile.util.DefaultPresentationUtilityProvider;
import com.adobe.marketing.mobile.util.StreamUtils;
import com.adobe.marketing.mobile.util.StringUtils;
import com.adobe.marketing.mobile.util.UrlUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class FullScreenMessage
extends CampaignMessage {
    private final String SELF_TAG = "FullScreenMessage";
    private static final int FILL_DEVICE_DISPLAY = 100;
    private final String MESSAGES_CACHE = "campaign" + File.separator + "messages" + File.separator;
    private final CacheService cacheService;
    private final UIService uiService;
    private String html;
    private String htmlContent;
    private String messageId;
    private final List<List<String>> assets = new ArrayList<List<String>>();

    FullScreenMessage(CampaignExtension extension, RuleConsequence consequence) throws CampaignMessageRequiredFieldMissingException {
        super(extension, consequence);
        this.cacheService = ServiceProvider.getInstance().getCacheService();
        this.uiService = ServiceProvider.getInstance().getUIService();
        this.parseFullScreenMessagePayload(consequence);
    }

    private void parseFullScreenMessagePayload(RuleConsequence consequence) throws CampaignMessageRequiredFieldMissingException {
        if (consequence == null) {
            throw new CampaignMessageRequiredFieldMissingException("Message consequence is null.");
        }
        Map detailDictionary = consequence.getDetail();
        if (detailDictionary == null || detailDictionary.isEmpty()) {
            throw new CampaignMessageRequiredFieldMissingException("Unable to create fullscreen message, message detail is missing or not an object.");
        }
        this.html = DataReader.optString((Map)detailDictionary, (String)"html", (String)"");
        if (StringUtils.isNullOrEmpty((String)this.html)) {
            Log.debug((String)"Campaign", (String)"FullScreenMessage", (String)"parseFullScreenMessagePayload -  Unable to create fullscreen message, html is missing/empty.", (Object[])new Object[0]);
            throw new CampaignMessageRequiredFieldMissingException("Messages - Unable to create fullscreen message, html is missing/empty.");
        }
        List assetsList = (List)detailDictionary.get("remoteAssets");
        if (assetsList != null && !assetsList.isEmpty()) {
            for (List assets : assetsList) {
                this.extractAssets(assets);
            }
        } else {
            Log.trace((String)"Campaign", (String)"FullScreenMessage", (String)"parseFullScreenMessagePayload -  Tried to read \"assets\" for fullscreen message but none found.  This is not a required field.", (Object[])new Object[0]);
        }
        this.messageId = consequence.getId();
    }

    private void extractAssets(List<String> assets) {
        if (assets == null || assets.isEmpty()) {
            Log.trace((String)"Campaign", (String)"FullScreenMessage", (String)"extractAssets - There are no assets to extract.", (Object[])new Object[0]);
            return;
        }
        ArrayList<String> foundAssets = new ArrayList<String>();
        for (String asset : assets) {
            foundAssets.add(asset);
        }
        Log.trace((String)"Campaign", (String)"FullScreenMessage", (String)"extractAssets - Adding %s to extracted assets.", (Object[])new Object[]{foundAssets});
        this.assets.add(foundAssets);
    }

    @Override
    void showMessage() {
        Log.debug((String)"Campaign", (String)"FullScreenMessage", (String)"showMessage - Attempting to show fullscreen message with ID %s", (Object[])new Object[]{this.messageId});
        if (this.uiService == null) {
            Log.warning((String)"Campaign", (String)"FullScreenMessage", (String)"showMessage - UI Service is unavailable. Unable to show fullscreen message with ID (%s)", (Object[])new Object[]{this.messageId});
            return;
        }
        if (this.cacheService == null) {
            Log.debug((String)"Campaign", (String)"FullScreenMessage", (String)"showMessage - No cache service found, to show fullscreen message with ID %s", (Object[])new Object[]{this.messageId});
            return;
        }
        CacheResult cacheResult = this.cacheService.get("campaign" + File.separator + "campaignRules", this.html);
        if (cacheResult == null) {
            Log.debug((String)"Campaign", (String)"FullScreenMessage", (String)"showMessage - Unable to find cached html content for fullscreen message with ID %s", (Object[])new Object[]{this.messageId});
            return;
        }
        this.htmlContent = StreamUtils.readAsString((InputStream)cacheResult.getData());
        if (StringUtils.isNullOrEmpty((String)this.htmlContent)) {
            Log.debug((String)"Campaign", (String)"FullScreenMessage", (String)"showMessage -  No html content in file (%s). File is missing or invalid!", (Object[])new Object[]{this.html});
            return;
        }
        Map<String, String> cachedResourcesMap = this.createCachedResourcesMap();
        FullScreenMessageUiListener fullScreenMessageUiListener = new FullScreenMessageUiListener();
        InAppMessageSettings messageSettings = new InAppMessageSettings.Builder().content(this.htmlContent).height(100).width(100).verticalAlignment(InAppMessageSettings.MessageAlignment.TOP).horizontalAlignment(InAppMessageSettings.MessageAlignment.CENTER).displayAnimation(InAppMessageSettings.MessageAnimation.BOTTOM).dismissAnimation(InAppMessageSettings.MessageAnimation.BOTTOM).backgroundColor("#FFFFFF").backdropOpacity(0.0f).assetMap(cachedResourcesMap).shouldTakeOverUi(true).build();
        Presentable fullscreenMessage = this.uiService.create((Presentation)new InAppMessage(messageSettings, (InAppMessageEventListener)fullScreenMessageUiListener), (PresentationUtilityProvider)new DefaultPresentationUtilityProvider());
        fullscreenMessage.show();
    }

    @Override
    boolean shouldDownloadAssets() {
        return true;
    }

    private Map<String, String> createCachedResourcesMap() {
        if (this.assets == null || this.assets.isEmpty()) {
            Log.debug((String)"Campaign", (String)"FullScreenMessage", (String)"createCachedResourcesMap - No valid remote asset list found for message with id %s.", (Object[])new Object[]{this.messageId});
            return Collections.emptyMap();
        }
        HashMap<String, String> cachedImagesMap = new HashMap<String, String>();
        HashMap<String, String> fallbackImagesMap = new HashMap<String, String>();
        String cacheName = this.MESSAGES_CACHE + this.messageId;
        for (List<String> currentAssetArray : this.assets) {
            if (currentAssetArray.isEmpty()) continue;
            String remoteAssetUrl = currentAssetArray.get(0);
            int currentAssetArrayCount = currentAssetArray.size();
            String assetCacheLocation = null;
            for (int currentAssetNumber = 0; currentAssetNumber < currentAssetArrayCount; ++currentAssetNumber) {
                String currentAsset = currentAssetArray.get(currentAssetNumber);
                CacheResult assetValueFile = this.cacheService.get(cacheName, currentAsset);
                if (assetValueFile == null) continue;
                assetCacheLocation = cacheName;
                break;
            }
            if (StringUtils.isNullOrEmpty(assetCacheLocation)) {
                String bundledFileName = currentAssetArray.get(currentAssetArrayCount - 1);
                boolean isLocalImage = !UrlUtils.isValidUrl((String)bundledFileName);
                if (!isLocalImage) continue;
                try {
                    Context applicationContext = ServiceProvider.getInstance().getAppContextService().getApplicationContext();
                    if (applicationContext == null) continue;
                    InputStream bundledFile = applicationContext.getAssets().open(bundledFileName);
                    String finalizedAssetUrl = !UrlUtils.isValidUrl((String)remoteAssetUrl) ? "file:///android_asset/" + remoteAssetUrl : remoteAssetUrl;
                    this.cacheService.set(cacheName, finalizedAssetUrl, new CacheEntry(bundledFile, CacheExpiry.never(), null));
                    fallbackImagesMap.put(finalizedAssetUrl, cacheName);
                    bundledFile.close();
                }
                catch (IOException exception) {
                    Log.debug((String)"Campaign", (String)"FullScreenMessage", (String)"createCachedResourcesMap - Exception occurred reading bundled asset: %s.", (Object[])new Object[]{exception.getMessage()});
                }
                continue;
            }
            cachedImagesMap.put(remoteAssetUrl, assetCacheLocation);
        }
        cachedImagesMap.putAll(fallbackImagesMap);
        return cachedImagesMap;
    }

    private void processMessageInteraction(Map<String, String> query) {
        if (query == null || query.isEmpty()) {
            Log.debug((String)"Campaign", (String)"FullScreenMessage", (String)"processMessageInteraction -  Cannot process message interaction, input query is null or empty.", (Object[])new Object[0]);
            return;
        }
        if (query.containsKey("id")) {
            String id = query.get("id");
            String[] strTokens = id.split(",");
            if (strTokens.length != 3) {
                Log.debug((String)"Campaign", (String)"FullScreenMessage", (String)"processMessageInteraction -  Cannot process message interaction, input query contains insufficient id tokens.", (Object[])new Object[0]);
                return;
            }
            int tagId = 0;
            try {
                tagId = Integer.parseInt(strTokens[2]);
            }
            catch (NumberFormatException e) {
                Log.debug((String)"Campaign", (String)"FullScreenMessage", (String)"processMessageInteraction -  Cannot parse tag Id from the id field in given query (%s).", (Object[])new Object[]{e});
            }
            switch (tagId) {
                case 3: 
                case 4: 
                case 5: {
                    this.clickedWithData(query);
                    this.viewed();
                    break;
                }
                default: {
                    Log.debug((String)"Campaign", (String)"FullScreenMessage", (String)"processMessageInteraction -  Unsupported tag Id found in the id field in the given query (%s).", (Object[])new Object[]{tagId});
                }
            }
        }
    }

    @VisibleForTesting
    List<List<String>> getAssetsList() {
        return this.assets;
    }

    class FullScreenMessageUiListener
    implements InAppMessageEventListener {
        FullScreenMessageUiListener() {
        }

        public void onShow(@NonNull Presentable<InAppMessage> presentable) {
            Log.debug((String)"Campaign", (String)"FullScreenMessage", (String)"Fullscreen on show callback received.", (Object[])new Object[0]);
            FullScreenMessage.this.triggered();
        }

        public void onDismiss(@NonNull Presentable<InAppMessage> presentable) {
            Log.debug((String)"Campaign", (String)"FullScreenMessage", (String)"Fullscreen on dismiss callback received.", (Object[])new Object[0]);
            FullScreenMessage.this.viewed();
        }

        public void onError(@NonNull Presentable<InAppMessage> presentable, @NonNull PresentationError presentationError) {
            Log.debug((String)"Campaign", (String)"FullScreenMessage", (String)"onShowFailure -  Fullscreen message failed to show.", (Object[])new Object[0]);
        }

        public void onHide(@NonNull Presentable<InAppMessage> presentable) {
        }

        public void onBackPressed(@NonNull Presentable<InAppMessage> presentable) {
        }

        public boolean onUrlLoading(@NonNull Presentable<InAppMessage> inAppMessagePresentable, @NonNull String urlString) {
            URI uri;
            Log.trace((String)"Campaign", (String)"Fullscreen overrideUrlLoad callback received with url (%s)", (String)urlString, (Object[])new Object[0]);
            if (StringUtils.isNullOrEmpty((String)urlString)) {
                Log.debug((String)"Campaign", (String)"FullScreenMessage", (String)"Cannot process provided URL string, it is null or empty.", (Object[])new Object[0]);
                return true;
            }
            try {
                uri = new URI(urlString);
            }
            catch (URISyntaxException ex) {
                Log.debug((String)"Campaign", (String)"FullScreenMessage", (String)"overrideUrlLoad -  Invalid message URI found (%s).", (Object[])new Object[]{urlString});
                return true;
            }
            String messageScheme = uri.getScheme();
            if (!messageScheme.equals("adbinapp")) {
                Log.debug((String)"Campaign", (String)"FullScreenMessage", (String)"overrideUrlLoad -  Invalid message scheme found in URI. (%s)", (Object[])new Object[]{urlString});
                return false;
            }
            String host = uri.getHost();
            if (!host.equals("confirm") && !host.equals("cancel")) {
                Log.debug((String)"Campaign", (String)"FullScreenMessage", (String)"overrideUrlLoad -  Unsupported URI host found, neither \"confirm\" nor \"cancel\". (%s)", (Object[])new Object[]{urlString});
                return false;
            }
            String query = uri.getRawQuery();
            Map<String, String> messageData = Utils.extractQueryParameters(query);
            if (messageData != null && !messageData.isEmpty()) {
                messageData.put("type", host);
                FullScreenMessage.this.processMessageInteraction(messageData);
            }
            inAppMessagePresentable.dismiss();
            return true;
        }
    }
}

