/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.campaign;

import android.database.sqlite.SQLiteDatabase;
import com.adobe.marketing.mobile.services.Log;
import com.adobe.marketing.mobile.services.ServiceProvider;
import com.adobe.marketing.mobile.util.StringUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0006H\u0007J\u001a\u0010\n\u001a\u00020\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\bH\u0007J\u001a\u0010\u000e\u001a\u00020\b2\b\u0010\u000f\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0010\u001a\u00020\u0006H\u0007J\"\u0010\u0011\u001a\u00020\b2\b\u0010\u0012\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/adobe/marketing/mobile/campaign/FileUtils;", "", "()V", "MAX_BUFFER_SIZE", "", "TAG", "", "deleteDatabaseFromCacheDir", "", "fileName", "deleteFile", "fileToDelete", "Ljava/io/File;", "recursive", "extractFromZip", "zipFile", "outputDirectoryPath", "readInputStreamIntoFile", "file", "inputStream", "Ljava/io/InputStream;", "append", "campaign_phoneRelease"})
public final class FileUtils {
    @NotNull
    public static final FileUtils INSTANCE = new FileUtils();
    @NotNull
    private static final String TAG = "FileUtils";
    private static final int MAX_BUFFER_SIZE = 4096;

    private FileUtils() {
    }

    @JvmStatic
    public static final boolean deleteDatabaseFromCacheDir(@Nullable String fileName) {
        boolean bl;
        try {
            File cacheDir = ServiceProvider.getInstance().getDeviceInfoService().getApplicationCacheDir();
            if (cacheDir == null || StringUtils.isNullOrEmpty((String)fileName)) {
                return false;
            }
            File databaseFile = new File(cacheDir, fileName);
            bl = SQLiteDatabase.deleteDatabase((File)databaseFile);
        }
        catch (Exception e) {
            Object[] objectArray = new Object[]{fileName, e.getLocalizedMessage()};
            Log.debug((String)"Campaign", (String)TAG, (String)"Failed to delete (%s) in cache folder, exception occurred: (%s)", (Object[])objectArray);
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    public static final boolean readInputStreamIntoFile(@Nullable File file, @NotNull InputStream inputStream, boolean append) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        try {
            Closeable closeable = new FileOutputStream(file, append);
            Throwable throwable = null;
            try {
                FileOutputStream outputStream = (FileOutputStream)closeable;
                boolean bl2 = false;
                long l = ByteStreamsKt.copyTo((InputStream)inputStream, (OutputStream)outputStream, (int)4096);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            bl = true;
        }
        catch (Exception e) {
            File file2 = file;
            Log.debug((String)"Campaign", (String)TAG, (String)("Unexpected exception while attempting to write to file: " + (file2 != null ? file2.getPath() : null) + " (" + e + ')'), (Object[])new Object[0]);
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    public static final boolean extractFromZip(@Nullable File zipFile, @NotNull String outputDirectoryPath) {
        Intrinsics.checkNotNullParameter((Object)outputDirectoryPath, (String)"outputDirectoryPath");
        if (zipFile == null) {
            return false;
        }
        File folder = new File(outputDirectoryPath);
        if (!folder.exists() && !folder.mkdir()) {
            Log.debug((String)"Campaign", (String)TAG, (String)("Could not create the output directory " + outputDirectoryPath), (Object[])new Object[0]);
            return false;
        }
        boolean extractedSuccessfully = false;
        extractedSuccessfully = true;
        try {
            Closeable closeable = new ZipInputStream(new FileInputStream(zipFile));
            Throwable throwable = null;
            try {
                ZipInputStream zipInputStream = (ZipInputStream)closeable;
                boolean bl = false;
                ZipEntry ze = zipInputStream.getNextEntry();
                String outputFolderCanonicalPath = folder.getCanonicalPath();
                if (ze == null) {
                    Log.debug((String)"Campaign", (String)TAG, (String)"Zip file was invalid", (Object[])new Object[0]);
                    boolean bl2 = false;
                    return bl2;
                }
                boolean entryProcessedSuccessfully = true;
                while (ze != null && entryProcessedSuccessfully) {
                    boolean bl3;
                    String fileName = ze.getName();
                    File newZipEntryFile = new File(outputDirectoryPath + File.separator + fileName);
                    String string = newZipEntryFile.getCanonicalPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"newZipEntryFile.canonicalPath");
                    Intrinsics.checkNotNullExpressionValue((Object)outputFolderCanonicalPath, (String)"outputFolderCanonicalPath");
                    if (!StringsKt.startsWith$default((String)string, (String)outputFolderCanonicalPath, (boolean)false, (int)2, null)) {
                        Log.debug((String)"Campaign", (String)TAG, (String)"The zip file contained an invalid path. Verify that your zip file is formatted correctly and has not been tampered with.", (Object[])new Object[0]);
                        boolean bl4 = false;
                        return bl4;
                    }
                    if (ze.isDirectory()) {
                        bl3 = newZipEntryFile.exists() || newZipEntryFile.mkdirs();
                    } else {
                        File parentFolder = newZipEntryFile.getParentFile();
                        if (parentFolder != null && (parentFolder.exists() || parentFolder.mkdirs())) {
                            bl3 = FileUtils.readInputStreamIntoFile(newZipEntryFile, zipInputStream, false);
                        } else {
                            Log.debug((String)"Campaign", (String)TAG, (String)("Could not extract the file " + newZipEntryFile.getAbsolutePath()), (Object[])new Object[0]);
                            boolean bl5 = false;
                            return bl5;
                        }
                    }
                    entryProcessedSuccessfully = bl3;
                    extractedSuccessfully = extractedSuccessfully && entryProcessedSuccessfully;
                    zipInputStream.closeEntry();
                    ze = zipInputStream.getNextEntry();
                }
                zipInputStream.closeEntry();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception ex) {
            Log.debug((String)"Campaign", (String)TAG, (String)("Extraction failed - " + ex), (Object[])new Object[0]);
            extractedSuccessfully = false;
        }
        return extractedSuccessfully;
    }

    @JvmStatic
    public static final boolean deleteFile(@Nullable File fileToDelete, boolean recursive) throws SecurityException {
        if (fileToDelete == null) {
            return false;
        }
        return recursive ? FilesKt.deleteRecursively((File)fileToDelete) : fileToDelete.delete();
    }
}

