/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.campaign;

import com.adobe.marketing.mobile.ExtensionApi;
import com.adobe.marketing.mobile.campaign.CampaignMessageAssetsDownloader;
import com.adobe.marketing.mobile.campaign.FileUtils;
import com.adobe.marketing.mobile.campaign.Utils;
import com.adobe.marketing.mobile.internal.util.StringEncoder;
import com.adobe.marketing.mobile.launch.rulesengine.LaunchRule;
import com.adobe.marketing.mobile.launch.rulesengine.LaunchRulesEngine;
import com.adobe.marketing.mobile.launch.rulesengine.RuleConsequence;
import com.adobe.marketing.mobile.launch.rulesengine.download.RulesLoadResult;
import com.adobe.marketing.mobile.launch.rulesengine.json.JSONRulesParser;
import com.adobe.marketing.mobile.services.HttpConnecting;
import com.adobe.marketing.mobile.services.HttpMethod;
import com.adobe.marketing.mobile.services.Log;
import com.adobe.marketing.mobile.services.NamedCollection;
import com.adobe.marketing.mobile.services.NetworkRequest;
import com.adobe.marketing.mobile.services.Networking;
import com.adobe.marketing.mobile.services.ServiceProvider;
import com.adobe.marketing.mobile.services.caching.CacheEntry;
import com.adobe.marketing.mobile.services.caching.CacheExpiry;
import com.adobe.marketing.mobile.services.caching.CacheResult;
import com.adobe.marketing.mobile.services.caching.CacheService;
import com.adobe.marketing.mobile.util.DataReader;
import com.adobe.marketing.mobile.util.StreamUtils;
import com.adobe.marketing.mobile.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class CampaignRulesDownloader {
    private static final String SELF_TAG = "CampaignRulesDownloader";
    private static final String TEMP_RULES_DIR = "campaign_temp";
    private final ExtensionApi extensionApi;
    private final LaunchRulesEngine campaignRulesEngine;
    private final NamedCollection campaignNamedCollection;
    private final CacheService cacheService;
    private final Networking networkService;
    private CampaignMessageAssetsDownloader campaignMessageAssetsDownloader;

    CampaignRulesDownloader(ExtensionApi extensionApi, LaunchRulesEngine campaignRulesEngine, NamedCollection campaignNamedCollection, CacheService cacheService) {
        this.extensionApi = extensionApi;
        this.campaignRulesEngine = campaignRulesEngine;
        this.campaignNamedCollection = campaignNamedCollection;
        this.cacheService = cacheService;
        this.networkService = ServiceProvider.getInstance().getNetworkService();
    }

    void loadRulesFromUrl(String url, String linkageFields) {
        if (this.networkService == null) {
            Log.debug((String)"Campaign", (String)SELF_TAG, (String)"loadRulesFromUrl - Cannot download rules, the network service is unavailable.", (Object[])new Object[0]);
            return;
        }
        if (StringUtils.isNullOrEmpty((String)url)) {
            Log.warning((String)"Campaign", (String)SELF_TAG, (String)"loadRulesFromUrl - Cannot download rules, provided url is null or empty. Cached rules will be used if present.", (Object[])new Object[0]);
            return;
        }
        Map<Object, Object> requestProperties = new HashMap();
        CacheResult cachedRules = this.cacheService.get("campaign" + File.separator + "campaignRules", "campaign_rules.zip");
        if (cachedRules != null) {
            requestProperties = Utils.extractHeadersFromCache(cachedRules);
        }
        if (!StringUtils.isNullOrEmpty((String)linkageFields)) {
            requestProperties.put("X-InApp-Auth", linkageFields);
        }
        NetworkRequest networkRequest = new NetworkRequest(url, HttpMethod.GET, null, requestProperties, 5, 5);
        this.networkService.connectAsync(networkRequest, httpConnecting -> {
            if (httpConnecting == null) {
                Log.warning((String)"Campaign", (String)SELF_TAG, (String)"loadRulesFromUrl - No internet connection. Unable to download rules.", (Object[])new Object[]{url});
                return;
            }
            this.onRulesDownloaded(url, httpConnecting);
        });
    }

    private void onRulesDownloaded(String url, HttpConnecting connection) {
        RulesLoadResult rulesLoadResult;
        switch (connection.getResponseCode()) {
            case 200: {
                rulesLoadResult = this.extractRules(url, connection.getInputStream(), Utils.extractMetadataFromResponse(connection));
                if (rulesLoadResult.getReason() == RulesLoadResult.Reason.SUCCESS) {
                    this.updateUrlInNamedCollection(url);
                }
                connection.close();
                break;
            }
            case 304: {
                Log.trace((String)"Campaign", (String)SELF_TAG, (String)"Rules from %s have not been modified. Will not re-download rules.", (Object[])new Object[]{url});
                connection.close();
                return;
            }
            default: {
                Log.error((String)"Campaign", (String)SELF_TAG, (String)"Received download response: %s", (Object[])new Object[]{connection.getResponseCode()});
                connection.close();
                return;
            }
        }
        this.registerRules(rulesLoadResult);
    }

    void registerRules(RulesLoadResult rulesLoadResult) {
        List campaignRules;
        if (rulesLoadResult.getData() != null && (campaignRules = JSONRulesParser.parse((String)rulesLoadResult.getData(), (ExtensionApi)this.extensionApi)) != null) {
            Log.trace((String)"Campaign", (String)SELF_TAG, (String)"Registering %s Campaign rule(s).", (Object[])new Object[]{campaignRules.size()});
            this.campaignRulesEngine.replaceRules(campaignRules);
            this.cacheRemoteAssets(campaignRules);
        }
    }

    void cacheRemoteAssets(List<LaunchRule> campaignRules) {
        if (campaignRules == null || campaignRules.isEmpty()) {
            Log.debug((String)"Campaign", (String)SELF_TAG, (String)"cacheRemoteAssets - Cannot load consequences, campaign rules list is null or empty.", (Object[])new Object[0]);
            return;
        }
        ArrayList<String> loadedMessageIds = new ArrayList<String>();
        block0: for (LaunchRule rule : campaignRules) {
            for (RuleConsequence consequence : rule.getConsequenceList()) {
                String consequenceType = consequence.getType();
                Map details = consequence.getDetail();
                String templateType = DataReader.optString((Map)details, (String)"template", (String)"");
                if (StringUtils.isNullOrEmpty((String)consequenceType) || !consequenceType.equals("iam") || !templateType.equals("fullscreen")) continue;
                String consequenceId = consequence.getId();
                if (!StringUtils.isNullOrEmpty((String)consequenceId)) {
                    loadedMessageIds.add(consequenceId);
                    List<String> assetUrls = this.createAssetUrlList(details);
                    if (assetUrls == null || assetUrls.isEmpty()) {
                        Log.debug((String)"Campaign", (String)SELF_TAG, (String)"cacheRemoteAssets - Can't download assets, no remote assets found in consequence for message id %s", (Object[])new Object[]{consequence.getId()});
                        continue block0;
                    }
                    this.campaignMessageAssetsDownloader = new CampaignMessageAssetsDownloader(assetUrls, consequenceId);
                    this.campaignMessageAssetsDownloader.downloadAssetCollection();
                    continue;
                }
                Log.debug((String)"Campaign", (String)SELF_TAG, (String)"cacheRemoteAssets - Can't download assets, Consequence id is null", (Object[])new Object[0]);
            }
        }
        File messageCacheDir = new File(ServiceProvider.getInstance().getDeviceInfoService().getApplicationCacheDir() + File.separator + "campaign" + File.separator + "messages");
        Utils.clearCachedAssetsNotInList(messageCacheDir, loadedMessageIds);
    }

    private RulesLoadResult extractRules(String key, InputStream zipContentStream, Map<String, String> metadata) {
        if (zipContentStream == null) {
            Log.debug((String)"Campaign", (String)"campaign", (String)"Zip content stream is null", (Object[])new Object[0]);
            return new RulesLoadResult(null, RulesLoadResult.Reason.NO_DATA);
        }
        File tempDirectory = this.getTemporaryDirectory(key);
        if (!tempDirectory.exists() && !tempDirectory.mkdirs()) {
            Log.debug((String)"Campaign", (String)SELF_TAG, (String)"Cannot access application cache directory to create temp dir.", (Object[])new Object[0]);
            return new RulesLoadResult(null, RulesLoadResult.Reason.CANNOT_CREATE_TEMP_DIR);
        }
        if (!FileUtils.readInputStreamIntoFile(this.getZipFileHandle(key), zipContentStream, false)) {
            Log.debug((String)"Campaign", (String)SELF_TAG, (String)"Couldn't extract zip contents to temp directory.", (Object[])new Object[0]);
            return new RulesLoadResult(null, RulesLoadResult.Reason.CANNOT_STORE_IN_TEMP_DIR);
        }
        if (!FileUtils.extractFromZip(this.getZipFileHandle(key), tempDirectory.getPath())) {
            Log.debug((String)"Campaign", (String)SELF_TAG, (String)"Failed to extract rules response zip into temp dir.", (Object[])new Object[0]);
            return new RulesLoadResult(null, RulesLoadResult.Reason.ZIP_EXTRACTION_FAILED);
        }
        boolean cached = this.cacheExtractedFiles(tempDirectory, metadata);
        if (!cached) {
            Log.debug((String)"Campaign", (String)SELF_TAG, (String)"Could not cache rules from source %s", (Object[])new Object[]{key});
        }
        this.deleteTemporaryDirectory(key);
        CacheResult cachedRulesJson = this.cacheService.get("campaign" + File.separator + "campaignRules", "rules.json");
        String rulesJsonString = StreamUtils.readAsString((InputStream)cachedRulesJson.getData());
        return new RulesLoadResult(rulesJsonString, RulesLoadResult.Reason.SUCCESS);
    }

    private List<String> createAssetUrlList(Map<String, Object> detailMap) {
        if (detailMap == null) {
            return null;
        }
        List assets = (List)detailMap.get("remoteAssets");
        if (assets == null || assets.isEmpty()) {
            return null;
        }
        ArrayList<String> assetsToDownload = new ArrayList<String>();
        for (List asset : assets) {
            assetsToDownload.addAll(asset);
        }
        return assetsToDownload;
    }

    private File getTemporaryDirectory(String tag) {
        String hash = StringEncoder.sha2hash((String)tag);
        String tempDir = ServiceProvider.getInstance().getDeviceInfoService().getApplicationCacheDir().getPath() + File.separator + TEMP_RULES_DIR + File.separator + hash;
        return new File(tempDir);
    }

    private File getZipFileHandle(String tag) {
        return new File(this.getTemporaryDirectory(tag).getPath() + File.separator + "campaign_rules.zip");
    }

    private void deleteTemporaryDirectory(String tag) {
        if (StringUtils.isNullOrEmpty((String)tag)) {
            return;
        }
        FileUtils.deleteFile(this.getTemporaryDirectory(tag), true);
    }

    private boolean cacheExtractedFiles(File tempDirectory, Map<String, String> metadata) {
        File[] filesList = tempDirectory.listFiles();
        if (filesList == null) {
            return false;
        }
        for (File fileEntry : filesList) {
            if (fileEntry.isDirectory()) {
                this.cacheExtractedFiles(fileEntry, metadata);
                continue;
            }
            try {
                String fileName = fileEntry.getName();
                Log.trace((String)"Campaign", (String)SELF_TAG, (String)"Caching file (%s)", (Object[])new Object[]{fileName});
                this.cacheService.set("campaign" + File.separator + "campaignRules", fileName, new CacheEntry((InputStream)new FileInputStream(fileEntry), CacheExpiry.never(), metadata));
            }
            catch (FileNotFoundException exception) {
                return false;
            }
        }
        return true;
    }

    private void updateUrlInNamedCollection(String url) {
        if (this.campaignNamedCollection == null) {
            Log.trace((String)"Campaign", (String)SELF_TAG, (String)"updateUrlInNamedCollection - Campaign Named Collection is null, cannot store url.", (Object[])new Object[0]);
            return;
        }
        if (StringUtils.isNullOrEmpty((String)url)) {
            Log.trace((String)"Campaign", (String)SELF_TAG, (String)"updateUrlInNamedCollection - Removing remotes URL key in Campaign Named Collection.", (Object[])new Object[0]);
            this.campaignNamedCollection.remove("CampaignRemoteUrl");
        } else {
            Log.trace((String)"Campaign", (String)SELF_TAG, (String)"updateUrlInNamedCollection - Persisting remotes URL (%s) in Campaign Named Collection.", (Object[])new Object[]{url});
            this.campaignNamedCollection.setString("CampaignRemoteUrl", url);
        }
    }
}

