/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.campaign;

import com.adobe.marketing.mobile.campaign.Utils;
import com.adobe.marketing.mobile.services.DeviceInforming;
import com.adobe.marketing.mobile.services.HttpConnecting;
import com.adobe.marketing.mobile.services.HttpMethod;
import com.adobe.marketing.mobile.services.Log;
import com.adobe.marketing.mobile.services.NetworkRequest;
import com.adobe.marketing.mobile.services.Networking;
import com.adobe.marketing.mobile.services.ServiceProvider;
import com.adobe.marketing.mobile.services.caching.CacheEntry;
import com.adobe.marketing.mobile.services.caching.CacheExpiry;
import com.adobe.marketing.mobile.services.caching.CacheResult;
import com.adobe.marketing.mobile.services.caching.CacheService;
import com.adobe.marketing.mobile.util.UrlUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class CampaignMessageAssetsDownloader {
    private static final String SELF_TAG = "CampaignMessageAssetsDownloader";
    private final List<String> assetsCollection;
    private final Networking networkService;
    private final DeviceInforming deviceInfoService;
    private final CacheService cacheService;
    private final String messageId;
    private File assetDir;

    CampaignMessageAssetsDownloader(List<String> assets, String parentMessageId) {
        this.assetsCollection = assets;
        this.networkService = ServiceProvider.getInstance().getNetworkService();
        this.deviceInfoService = ServiceProvider.getInstance().getDeviceInfoService();
        this.cacheService = ServiceProvider.getInstance().getCacheService();
        this.messageId = parentMessageId;
        this.createMessageAssetCacheDirectory();
    }

    void downloadAssetCollection() {
        ArrayList<String> assetsToRetain = new ArrayList<String>();
        if (this.assetsCollection != null && !this.assetsCollection.isEmpty()) {
            for (String currentAsset : this.assetsCollection) {
                if (!this.assetIsDownloadable(currentAsset)) continue;
                assetsToRetain.add(currentAsset);
            }
        }
        Utils.clearCachedAssetsNotInList(this.assetDir, assetsToRetain);
        for (String url : assetsToRetain) {
            CacheResult cachedAsset = this.cacheService.get(this.assetDir + File.separator + this.messageId, url);
            Map<String, String> requestProperties = Utils.extractHeadersFromCache(cachedAsset);
            NetworkRequest networkRequest = new NetworkRequest(url, HttpMethod.GET, null, requestProperties, 5, 5);
            this.networkService.connectAsync(networkRequest, connection -> {
                if (connection == null) {
                    Log.warning((String)"Campaign", (String)SELF_TAG, (String)"downloadAssetCollection - Internet not available. Failed to download asset from URL: %s", (Object[])new Object[]{url});
                    return;
                }
                if (connection.getResponseCode() == 304) {
                    Log.debug((String)"Campaign", (String)SELF_TAG, (String)"downloadAssetCollection - Asset was cached previously: %s", (Object[])new Object[]{url});
                    connection.close();
                    return;
                }
                if (connection.getResponseCode() != 200) {
                    Log.debug((String)"Campaign", (String)SELF_TAG, (String)"downloadAssetCollection - Failed to download asset from URL: %s", (Object[])new Object[]{url});
                    connection.close();
                    return;
                }
                this.cacheAssetData(connection, url, this.messageId);
                connection.close();
            });
        }
    }

    private void cacheAssetData(HttpConnecting connection, String key, String messageId) {
        if (!this.createDirectoryIfNeeded(messageId)) {
            Log.debug((String)"Campaign", (String)SELF_TAG, (String)"cacheAssetData - Cannot cache asset for message id %s, failed to create cache directory.", (Object[])new Object[]{messageId});
            return;
        }
        Log.debug((String)"Campaign", (String)SELF_TAG, (String)"cacheAssetData - Caching asset %s for message id %s.", (Object[])new Object[]{key, messageId});
        HashMap<String, String> metadata = Utils.extractMetadataFromResponse(connection);
        String assetStoragePath = "campaign" + File.separator + "messages" + File.separator + messageId;
        CacheEntry cacheEntry = new CacheEntry(connection.getInputStream(), CacheExpiry.never(), metadata);
        this.cacheService.set(assetStoragePath, key, cacheEntry);
    }

    private boolean assetIsDownloadable(String assetPath) {
        return UrlUtils.isValidUrl((String)assetPath) && (assetPath.startsWith("http") || assetPath.startsWith("https"));
    }

    private void createMessageAssetCacheDirectory() {
        try {
            this.assetDir = new File(this.deviceInfoService.getApplicationCacheDir() + File.separator + "aepsdkcache" + File.separator + "campaign" + File.separator + "messages");
            if (!this.assetDir.exists() && !this.assetDir.mkdirs()) {
                Log.warning((String)"Campaign", (String)SELF_TAG, (String)"createMessageAssetCacheDirectory - Unable to create directory for caching message assets", (Object[])new Object[0]);
            }
        }
        catch (Exception ex) {
            Log.warning((String)"Campaign", (String)SELF_TAG, (String)"createMessageAssetCacheDirectory - An unexpected error occurred while managing assets cache directory: \n %s", (Object[])new Object[]{ex});
        }
    }

    private boolean createDirectoryIfNeeded(String messageId) {
        if (!this.assetDir.exists()) {
            return false;
        }
        File cacheDirectory = new File(this.assetDir + File.separator + messageId);
        if (!cacheDirectory.exists()) {
            return cacheDirectory.mkdir();
        }
        return true;
    }
}

